/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.concurrency;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.slack.client.concurrency.CloseableExecutorService;
import com.hubspot.slack.client.concurrency.FollowThreadLocalsExecutorService;
import com.hubspot.slack.client.concurrency.ThreadFactories;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoreExecutors {
    private static final Logger LOG = LoggerFactory.getLogger(MoreExecutors.class);
    private static final AtomicBoolean HAS_WARNED_UNNAMED_THREADFACTORY = new AtomicBoolean(false);

    private MoreExecutors() {
    }

    public static ThreadPoolExecutorBuilder threadPoolNonDaemonExecutorBuilder(String namePrefix) {
        return new ThreadPoolExecutorBuilderImpl(namePrefix, false);
    }

    public static ThreadPoolExecutorBuilder threadPoolDaemonExecutorBuilder(String namePrefix) {
        return new ThreadPoolExecutorBuilderImpl(namePrefix, true);
    }

    private static class BlockCallerPolicy
    implements RejectedExecutionHandler {
        private BlockCallerPolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException("Unexpected InterruptedException", e);
            }
        }
    }

    private static class ThreadPoolExecutorBuilderImpl
    implements ThreadPoolExecutorBuilder {
        private final String namePrefix;
        private final boolean daemon;
        private boolean fair = false;
        private boolean blockWhenFull = false;
        private boolean fixed = true;
        private boolean unbounded = false;
        private int maxSize = 20;
        private long keepAliveTime = 60L;
        private Optional<Integer> queueSize = Optional.absent();
        private TimeUnit keepAliveTimeUnit = TimeUnit.SECONDS;
        private BlockingQueue<Runnable> queue = null;
        private boolean followThreadLocals = true;
        private long shutdownTimeout = 30L;
        private TimeUnit shutdownTimeUnit = TimeUnit.SECONDS;

        private ThreadPoolExecutorBuilderImpl(String namePrefix, boolean daemon) {
            this.namePrefix = namePrefix;
            this.daemon = daemon;
        }

        @Override
        public ThreadPoolExecutorBuilder setFollowThreadLocals(boolean followThreadLocals) {
            this.followThreadLocals = followThreadLocals;
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder setMaxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder setKeepAlive(long keepAlive, TimeUnit timeUnit) {
            this.keepAliveTime = keepAlive;
            this.keepAliveTimeUnit = timeUnit;
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder setWorkQueue(BlockingQueue<Runnable> workQueue) {
            this.queue = workQueue;
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder setUnbounded(boolean unbounded) {
            this.unbounded = unbounded;
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder setFixed(boolean fixed) {
            this.fixed = fixed;
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder setBlockWhenFull(int queueSize) {
            this.blockWhenFull = true;
            this.queueSize = Optional.of((Object)queueSize);
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder clearBlockWhenFull() {
            this.blockWhenFull = false;
            this.queueSize = Optional.absent();
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder setFair(boolean fair) {
            this.fair = fair;
            return this;
        }

        @Override
        public ThreadPoolExecutorBuilder setShutdownTimeout(long timeout, TimeUnit timeUnit) {
            this.shutdownTimeout = timeout;
            this.shutdownTimeUnit = timeUnit;
            return this;
        }

        @Override
        public CloseableExecutorService build() {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(this.unbounded ? 0 : this.maxSize, this.unbounded ? Integer.MAX_VALUE : this.maxSize, this.keepAliveTime, this.keepAliveTimeUnit, this.getQueue(), this.buildThreadFactory(), this.getRejectionPolicy());
            if (!this.fixed) {
                executor.allowCoreThreadTimeOut(true);
            }
            Object executorService = this.followThreadLocals ? new FollowThreadLocalsExecutorService(executor, this.namePrefix) : executor;
            return CloseableExecutorService.wrap((ExecutorService)executorService, this.namePrefix, this.shutdownTimeout, this.shutdownTimeUnit);
        }

        private ThreadFactory buildThreadFactory() {
            if (Strings.isNullOrEmpty((String)this.namePrefix)) {
                if (HAS_WARNED_UNNAMED_THREADFACTORY.compareAndSet(false, true)) {
                    LOG.error("(\u3065\uff61\u25d5\u203f\u203f\u25d5\uff61)\u3065  Your newborn ThreadFactory needs a name!", (Throwable)new RuntimeException("unnamed ThreadFactory"));
                }
                return new ThreadFactoryBuilder().setDaemon(this.daemon).build();
            }
            return ThreadFactories.newBuilder(this.namePrefix).setDaemon(this.daemon).build();
        }

        private BlockingQueue<Runnable> getQueue() {
            if (this.queue != null) {
                return this.queue;
            }
            if (this.unbounded) {
                return new SynchronousQueue<Runnable>(this.fair);
            }
            if (this.queueSize.isPresent() && (Integer)this.queueSize.get() == 0) {
                return new SynchronousQueue<Runnable>(this.fair);
            }
            if (this.queueSize.isPresent()) {
                return new ArrayBlockingQueue<Runnable>((Integer)this.queueSize.get(), this.fair);
            }
            return new LinkedBlockingQueue<Runnable>();
        }

        private RejectedExecutionHandler getRejectionPolicy() {
            if (this.blockWhenFull) {
                return new BlockCallerPolicy();
            }
            return new ThreadPoolExecutor.AbortPolicy();
        }
    }

    public static interface ThreadPoolExecutorBuilder {
        public ThreadPoolExecutorBuilder setMaxSize(int var1);

        public ThreadPoolExecutorBuilder setKeepAlive(long var1, TimeUnit var3);

        public ThreadPoolExecutorBuilder setWorkQueue(BlockingQueue<Runnable> var1);

        public ThreadPoolExecutorBuilder setFixed(boolean var1);

        public ThreadPoolExecutorBuilder setBlockWhenFull(int var1);

        public ThreadPoolExecutorBuilder setUnbounded(boolean var1);

        public ThreadPoolExecutorBuilder clearBlockWhenFull();

        public ThreadPoolExecutorBuilder setFair(boolean var1);

        public ThreadPoolExecutorBuilder setFollowThreadLocals(boolean var1);

        public ThreadPoolExecutorBuilder setShutdownTimeout(long var1, TimeUnit var3);

        public CloseableExecutorService build();
    }
}

