/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.horizon.HttpConfig;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.SlackClientRuntimeConfigIF;
import com.hubspot.slack.client.http.NioHttpClient;
import com.hubspot.slack.client.interceptors.calls.SlackMethodAcceptor;
import com.hubspot.slack.client.interceptors.http.RequestDebugger;
import com.hubspot.slack.client.interceptors.http.ResponseDebugger;
import com.hubspot.slack.client.ratelimiting.SlackRateLimiter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackClientRuntimeConfigIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackClientRuntimeConfig
implements SlackClientRuntimeConfigIF {
    private final Supplier<String> tokenSupplier;
    private final Supplier<String> slackApiBasePath;
    private final Supplier<Integer> usersListBatchSize;
    private final Supplier<Integer> channelsListBatchSize;
    private final Supplier<Integer> channelsHistoryMessageBatchSize;
    private final Supplier<Integer> conversationsHistoryMessageBatchSize;
    private final Supplier<Integer> conversationMembersBatchSize;
    @Nullable
    private final SlackRateLimiter slackRateLimiter;
    @Nullable
    private final HttpConfig httpConfig;
    @Nullable
    private final NioHttpClient httpClient;
    @Nullable
    private final SlackMethodAcceptor methodFilter;
    @Nullable
    private final RequestDebugger requestDebugger;
    @Nullable
    private final ResponseDebugger responseDebugger;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackClientRuntimeConfig(Builder builder) {
        this.tokenSupplier = builder.tokenSupplier;
        this.slackRateLimiter = builder.slackRateLimiter;
        this.httpConfig = builder.httpConfig;
        this.httpClient = builder.httpClient;
        this.methodFilter = builder.methodFilter;
        this.requestDebugger = builder.requestDebugger;
        this.responseDebugger = builder.responseDebugger;
        if (builder.slackApiBasePath != null) {
            this.initShim.setSlackApiBasePath(builder.slackApiBasePath);
        }
        if (builder.usersListBatchSize != null) {
            this.initShim.setUsersListBatchSize(builder.usersListBatchSize);
        }
        if (builder.channelsListBatchSize != null) {
            this.initShim.setChannelsListBatchSize(builder.channelsListBatchSize);
        }
        if (builder.channelsHistoryMessageBatchSize != null) {
            this.initShim.setChannelsHistoryMessageBatchSize(builder.channelsHistoryMessageBatchSize);
        }
        if (builder.conversationsHistoryMessageBatchSize != null) {
            this.initShim.setConversationsHistoryMessageBatchSize(builder.conversationsHistoryMessageBatchSize);
        }
        if (builder.conversationMembersBatchSize != null) {
            this.initShim.setConversationMembersBatchSize(builder.conversationMembersBatchSize);
        }
        this.slackApiBasePath = this.initShim.getSlackApiBasePath();
        this.usersListBatchSize = this.initShim.getUsersListBatchSize();
        this.channelsListBatchSize = this.initShim.getChannelsListBatchSize();
        this.channelsHistoryMessageBatchSize = this.initShim.getChannelsHistoryMessageBatchSize();
        this.conversationsHistoryMessageBatchSize = this.initShim.getConversationsHistoryMessageBatchSize();
        this.conversationMembersBatchSize = this.initShim.getConversationMembersBatchSize();
        this.initShim = null;
    }

    private SlackClientRuntimeConfig(Supplier<String> tokenSupplier, Supplier<String> slackApiBasePath, Supplier<Integer> usersListBatchSize, Supplier<Integer> channelsListBatchSize, Supplier<Integer> channelsHistoryMessageBatchSize, Supplier<Integer> conversationsHistoryMessageBatchSize, Supplier<Integer> conversationMembersBatchSize, @Nullable SlackRateLimiter slackRateLimiter, @Nullable HttpConfig httpConfig, @Nullable NioHttpClient httpClient, @Nullable SlackMethodAcceptor methodFilter, @Nullable RequestDebugger requestDebugger, @Nullable ResponseDebugger responseDebugger) {
        this.tokenSupplier = tokenSupplier;
        this.slackApiBasePath = slackApiBasePath;
        this.usersListBatchSize = usersListBatchSize;
        this.channelsListBatchSize = channelsListBatchSize;
        this.channelsHistoryMessageBatchSize = channelsHistoryMessageBatchSize;
        this.conversationsHistoryMessageBatchSize = conversationsHistoryMessageBatchSize;
        this.conversationMembersBatchSize = conversationMembersBatchSize;
        this.slackRateLimiter = slackRateLimiter;
        this.httpConfig = httpConfig;
        this.httpClient = httpClient;
        this.methodFilter = methodFilter;
        this.requestDebugger = requestDebugger;
        this.responseDebugger = responseDebugger;
        this.initShim = null;
    }

    private Supplier<String> getSlackApiBasePathInitialize() {
        return SlackClientRuntimeConfigIF.super.getSlackApiBasePath();
    }

    private Supplier<Integer> getUsersListBatchSizeInitialize() {
        return SlackClientRuntimeConfigIF.super.getUsersListBatchSize();
    }

    private Supplier<Integer> getChannelsListBatchSizeInitialize() {
        return SlackClientRuntimeConfigIF.super.getChannelsListBatchSize();
    }

    private Supplier<Integer> getChannelsHistoryMessageBatchSizeInitialize() {
        return SlackClientRuntimeConfigIF.super.getChannelsHistoryMessageBatchSize();
    }

    private Supplier<Integer> getConversationsHistoryMessageBatchSizeInitialize() {
        return SlackClientRuntimeConfigIF.super.getConversationsHistoryMessageBatchSize();
    }

    private Supplier<Integer> getConversationMembersBatchSizeInitialize() {
        return SlackClientRuntimeConfigIF.super.getConversationMembersBatchSize();
    }

    @Override
    @JsonProperty
    public Supplier<String> getTokenSupplier() {
        return this.tokenSupplier;
    }

    @Override
    @JsonProperty
    public Supplier<String> getSlackApiBasePath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSlackApiBasePath() : this.slackApiBasePath;
    }

    @Override
    @JsonProperty
    public Supplier<Integer> getUsersListBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUsersListBatchSize() : this.usersListBatchSize;
    }

    @Override
    @JsonProperty
    public Supplier<Integer> getChannelsListBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getChannelsListBatchSize() : this.channelsListBatchSize;
    }

    @Override
    @JsonProperty
    public Supplier<Integer> getChannelsHistoryMessageBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getChannelsHistoryMessageBatchSize() : this.channelsHistoryMessageBatchSize;
    }

    @Override
    @JsonProperty
    public Supplier<Integer> getConversationsHistoryMessageBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConversationsHistoryMessageBatchSize() : this.conversationsHistoryMessageBatchSize;
    }

    @Override
    @JsonProperty
    public Supplier<Integer> getConversationMembersBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getConversationMembersBatchSize() : this.conversationMembersBatchSize;
    }

    @Override
    @JsonProperty
    public Optional<SlackRateLimiter> getSlackRateLimiter() {
        return Optional.ofNullable(this.slackRateLimiter);
    }

    @Override
    @JsonProperty
    public Optional<HttpConfig> getHttpConfig() {
        return Optional.ofNullable(this.httpConfig);
    }

    @Override
    @JsonProperty
    public Optional<NioHttpClient> getHttpClient() {
        return Optional.ofNullable(this.httpClient);
    }

    @Override
    @JsonProperty
    public Optional<SlackMethodAcceptor> getMethodFilter() {
        return Optional.ofNullable(this.methodFilter);
    }

    @Override
    @JsonProperty
    public Optional<RequestDebugger> getRequestDebugger() {
        return Optional.ofNullable(this.requestDebugger);
    }

    @Override
    @JsonProperty
    public Optional<ResponseDebugger> getResponseDebugger() {
        return Optional.ofNullable(this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withTokenSupplier(Supplier<String> value) {
        if (this.tokenSupplier == value) {
            return this;
        }
        Supplier<String> newValue = Objects.requireNonNull(value, "tokenSupplier");
        return new SlackClientRuntimeConfig(newValue, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withSlackApiBasePath(Supplier<String> value) {
        if (this.slackApiBasePath == value) {
            return this;
        }
        Supplier<String> newValue = Objects.requireNonNull(value, "slackApiBasePath");
        return new SlackClientRuntimeConfig(this.tokenSupplier, newValue, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withUsersListBatchSize(Supplier<Integer> value) {
        if (this.usersListBatchSize == value) {
            return this;
        }
        Supplier<Integer> newValue = Objects.requireNonNull(value, "usersListBatchSize");
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, newValue, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withChannelsListBatchSize(Supplier<Integer> value) {
        if (this.channelsListBatchSize == value) {
            return this;
        }
        Supplier<Integer> newValue = Objects.requireNonNull(value, "channelsListBatchSize");
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, newValue, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withChannelsHistoryMessageBatchSize(Supplier<Integer> value) {
        if (this.channelsHistoryMessageBatchSize == value) {
            return this;
        }
        Supplier<Integer> newValue = Objects.requireNonNull(value, "channelsHistoryMessageBatchSize");
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, newValue, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withConversationsHistoryMessageBatchSize(Supplier<Integer> value) {
        if (this.conversationsHistoryMessageBatchSize == value) {
            return this;
        }
        Supplier<Integer> newValue = Objects.requireNonNull(value, "conversationsHistoryMessageBatchSize");
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, newValue, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withConversationMembersBatchSize(Supplier<Integer> value) {
        if (this.conversationMembersBatchSize == value) {
            return this;
        }
        Supplier<Integer> newValue = Objects.requireNonNull(value, "conversationMembersBatchSize");
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, newValue, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withSlackRateLimiter(@Nullable SlackRateLimiter value) {
        SlackRateLimiter newValue = value;
        if (this.slackRateLimiter == newValue) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, newValue, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withSlackRateLimiter(Optional<? extends SlackRateLimiter> optional) {
        SlackRateLimiter value = optional.orElse(null);
        if (this.slackRateLimiter == value) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, value, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withHttpConfig(@Nullable HttpConfig value) {
        HttpConfig newValue = value;
        if (this.httpConfig == newValue) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, newValue, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withHttpConfig(Optional<? extends HttpConfig> optional) {
        HttpConfig value = optional.orElse(null);
        if (this.httpConfig == value) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, value, this.httpClient, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withHttpClient(@Nullable NioHttpClient value) {
        NioHttpClient newValue = value;
        if (this.httpClient == newValue) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, newValue, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withHttpClient(Optional<? extends NioHttpClient> optional) {
        NioHttpClient value = optional.orElse(null);
        if (this.httpClient == value) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, value, this.methodFilter, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withMethodFilter(@Nullable SlackMethodAcceptor value) {
        SlackMethodAcceptor newValue = value;
        if (this.methodFilter == newValue) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, newValue, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withMethodFilter(Optional<? extends SlackMethodAcceptor> optional) {
        SlackMethodAcceptor value = optional.orElse(null);
        if (this.methodFilter == value) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, value, this.requestDebugger, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withRequestDebugger(@Nullable RequestDebugger value) {
        RequestDebugger newValue = value;
        if (this.requestDebugger == newValue) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, newValue, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withRequestDebugger(Optional<? extends RequestDebugger> optional) {
        RequestDebugger value = optional.orElse(null);
        if (this.requestDebugger == value) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, value, this.responseDebugger);
    }

    public final SlackClientRuntimeConfig withResponseDebugger(@Nullable ResponseDebugger value) {
        ResponseDebugger newValue = value;
        if (this.responseDebugger == newValue) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, newValue);
    }

    public final SlackClientRuntimeConfig withResponseDebugger(Optional<? extends ResponseDebugger> optional) {
        ResponseDebugger value = optional.orElse(null);
        if (this.responseDebugger == value) {
            return this;
        }
        return new SlackClientRuntimeConfig(this.tokenSupplier, this.slackApiBasePath, this.usersListBatchSize, this.channelsListBatchSize, this.channelsHistoryMessageBatchSize, this.conversationsHistoryMessageBatchSize, this.conversationMembersBatchSize, this.slackRateLimiter, this.httpConfig, this.httpClient, this.methodFilter, this.requestDebugger, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackClientRuntimeConfig && this.equalTo(0, (SlackClientRuntimeConfig)another);
    }

    private boolean equalTo(int synthetic, SlackClientRuntimeConfig another) {
        return this.tokenSupplier.equals(another.tokenSupplier) && this.slackApiBasePath.equals(another.slackApiBasePath) && this.usersListBatchSize.equals(another.usersListBatchSize) && this.channelsListBatchSize.equals(another.channelsListBatchSize) && this.channelsHistoryMessageBatchSize.equals(another.channelsHistoryMessageBatchSize) && this.conversationsHistoryMessageBatchSize.equals(another.conversationsHistoryMessageBatchSize) && this.conversationMembersBatchSize.equals(another.conversationMembersBatchSize) && Objects.equals(this.slackRateLimiter, another.slackRateLimiter) && Objects.equals(this.httpConfig, another.httpConfig) && Objects.equals(this.httpClient, another.httpClient) && Objects.equals(this.methodFilter, another.methodFilter) && Objects.equals(this.requestDebugger, another.requestDebugger) && Objects.equals(this.responseDebugger, another.responseDebugger);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.tokenSupplier.hashCode();
        h += (h << 5) + this.slackApiBasePath.hashCode();
        h += (h << 5) + this.usersListBatchSize.hashCode();
        h += (h << 5) + this.channelsListBatchSize.hashCode();
        h += (h << 5) + this.channelsHistoryMessageBatchSize.hashCode();
        h += (h << 5) + this.conversationsHistoryMessageBatchSize.hashCode();
        h += (h << 5) + this.conversationMembersBatchSize.hashCode();
        h += (h << 5) + Objects.hashCode(this.slackRateLimiter);
        h += (h << 5) + Objects.hashCode(this.httpConfig);
        h += (h << 5) + Objects.hashCode(this.httpClient);
        h += (h << 5) + Objects.hashCode(this.methodFilter);
        h += (h << 5) + Objects.hashCode(this.requestDebugger);
        h += (h << 5) + Objects.hashCode(this.responseDebugger);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackClientRuntimeConfig{");
        builder.append("tokenSupplier=").append(this.tokenSupplier);
        builder.append(", ");
        builder.append("slackApiBasePath=").append(this.slackApiBasePath);
        builder.append(", ");
        builder.append("usersListBatchSize=").append(this.usersListBatchSize);
        builder.append(", ");
        builder.append("channelsListBatchSize=").append(this.channelsListBatchSize);
        builder.append(", ");
        builder.append("channelsHistoryMessageBatchSize=").append(this.channelsHistoryMessageBatchSize);
        builder.append(", ");
        builder.append("conversationsHistoryMessageBatchSize=").append(this.conversationsHistoryMessageBatchSize);
        builder.append(", ");
        builder.append("conversationMembersBatchSize=").append(this.conversationMembersBatchSize);
        if (this.slackRateLimiter != null) {
            builder.append(", ");
            builder.append("slackRateLimiter=").append(this.slackRateLimiter);
        }
        if (this.httpConfig != null) {
            builder.append(", ");
            builder.append("httpConfig=").append(this.httpConfig);
        }
        if (this.httpClient != null) {
            builder.append(", ");
            builder.append("httpClient=").append(this.httpClient);
        }
        if (this.methodFilter != null) {
            builder.append(", ");
            builder.append("methodFilter=").append(this.methodFilter);
        }
        if (this.requestDebugger != null) {
            builder.append(", ");
            builder.append("requestDebugger=").append(this.requestDebugger);
        }
        if (this.responseDebugger != null) {
            builder.append(", ");
            builder.append("responseDebugger=").append(this.responseDebugger);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackClientRuntimeConfig fromJson(Json json) {
        Builder builder = SlackClientRuntimeConfig.builder();
        if (json.tokenSupplier != null) {
            builder.setTokenSupplier(json.tokenSupplier);
        }
        if (json.slackApiBasePath != null) {
            builder.setSlackApiBasePath(json.slackApiBasePath);
        }
        if (json.usersListBatchSize != null) {
            builder.setUsersListBatchSize(json.usersListBatchSize);
        }
        if (json.channelsListBatchSize != null) {
            builder.setChannelsListBatchSize(json.channelsListBatchSize);
        }
        if (json.channelsHistoryMessageBatchSize != null) {
            builder.setChannelsHistoryMessageBatchSize(json.channelsHistoryMessageBatchSize);
        }
        if (json.conversationsHistoryMessageBatchSize != null) {
            builder.setConversationsHistoryMessageBatchSize(json.conversationsHistoryMessageBatchSize);
        }
        if (json.conversationMembersBatchSize != null) {
            builder.setConversationMembersBatchSize(json.conversationMembersBatchSize);
        }
        if (json.slackRateLimiter != null) {
            builder.setSlackRateLimiter(json.slackRateLimiter);
        }
        if (json.httpConfig != null) {
            builder.setHttpConfig(json.httpConfig);
        }
        if (json.httpClient != null) {
            builder.setHttpClient(json.httpClient);
        }
        if (json.methodFilter != null) {
            builder.setMethodFilter(json.methodFilter);
        }
        if (json.requestDebugger != null) {
            builder.setRequestDebugger(json.requestDebugger);
        }
        if (json.responseDebugger != null) {
            builder.setResponseDebugger(json.responseDebugger);
        }
        return builder.build();
    }

    public static SlackClientRuntimeConfig copyOf(SlackClientRuntimeConfigIF instance) {
        if (instance instanceof SlackClientRuntimeConfig) {
            return (SlackClientRuntimeConfig)instance;
        }
        return SlackClientRuntimeConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackClientRuntimeConfigIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN_SUPPLIER = 1L;
        private long initBits = 1L;
        @Nullable
        private Supplier<String> tokenSupplier;
        @Nullable
        private Supplier<String> slackApiBasePath;
        @Nullable
        private Supplier<Integer> usersListBatchSize;
        @Nullable
        private Supplier<Integer> channelsListBatchSize;
        @Nullable
        private Supplier<Integer> channelsHistoryMessageBatchSize;
        @Nullable
        private Supplier<Integer> conversationsHistoryMessageBatchSize;
        @Nullable
        private Supplier<Integer> conversationMembersBatchSize;
        @Nullable
        private SlackRateLimiter slackRateLimiter;
        @Nullable
        private HttpConfig httpConfig;
        @Nullable
        private NioHttpClient httpClient;
        @Nullable
        private SlackMethodAcceptor methodFilter;
        @Nullable
        private RequestDebugger requestDebugger;
        @Nullable
        private ResponseDebugger responseDebugger;

        private Builder() {
        }

        public final Builder from(SlackClientRuntimeConfigIF instance) {
            Optional<ResponseDebugger> responseDebuggerOptional;
            Optional<RequestDebugger> requestDebuggerOptional;
            Optional<SlackMethodAcceptor> methodFilterOptional;
            Optional<NioHttpClient> httpClientOptional;
            Optional<HttpConfig> httpConfigOptional;
            Objects.requireNonNull(instance, "instance");
            this.setTokenSupplier(instance.getTokenSupplier());
            this.setSlackApiBasePath(instance.getSlackApiBasePath());
            this.setUsersListBatchSize(instance.getUsersListBatchSize());
            this.setChannelsListBatchSize(instance.getChannelsListBatchSize());
            this.setChannelsHistoryMessageBatchSize(instance.getChannelsHistoryMessageBatchSize());
            this.setConversationsHistoryMessageBatchSize(instance.getConversationsHistoryMessageBatchSize());
            this.setConversationMembersBatchSize(instance.getConversationMembersBatchSize());
            Optional<SlackRateLimiter> slackRateLimiterOptional = instance.getSlackRateLimiter();
            if (slackRateLimiterOptional.isPresent()) {
                this.setSlackRateLimiter(slackRateLimiterOptional);
            }
            if ((httpConfigOptional = instance.getHttpConfig()).isPresent()) {
                this.setHttpConfig(httpConfigOptional);
            }
            if ((httpClientOptional = instance.getHttpClient()).isPresent()) {
                this.setHttpClient(httpClientOptional);
            }
            if ((methodFilterOptional = instance.getMethodFilter()).isPresent()) {
                this.setMethodFilter(methodFilterOptional);
            }
            if ((requestDebuggerOptional = instance.getRequestDebugger()).isPresent()) {
                this.setRequestDebugger(requestDebuggerOptional);
            }
            if ((responseDebuggerOptional = instance.getResponseDebugger()).isPresent()) {
                this.setResponseDebugger(responseDebuggerOptional);
            }
            return this;
        }

        public final Builder setTokenSupplier(Supplier<String> tokenSupplier) {
            this.tokenSupplier = Objects.requireNonNull(tokenSupplier, "tokenSupplier");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSlackApiBasePath(Supplier<String> slackApiBasePath) {
            this.slackApiBasePath = Objects.requireNonNull(slackApiBasePath, "slackApiBasePath");
            return this;
        }

        public final Builder setUsersListBatchSize(Supplier<Integer> usersListBatchSize) {
            this.usersListBatchSize = Objects.requireNonNull(usersListBatchSize, "usersListBatchSize");
            return this;
        }

        public final Builder setChannelsListBatchSize(Supplier<Integer> channelsListBatchSize) {
            this.channelsListBatchSize = Objects.requireNonNull(channelsListBatchSize, "channelsListBatchSize");
            return this;
        }

        public final Builder setChannelsHistoryMessageBatchSize(Supplier<Integer> channelsHistoryMessageBatchSize) {
            this.channelsHistoryMessageBatchSize = Objects.requireNonNull(channelsHistoryMessageBatchSize, "channelsHistoryMessageBatchSize");
            return this;
        }

        public final Builder setConversationsHistoryMessageBatchSize(Supplier<Integer> conversationsHistoryMessageBatchSize) {
            this.conversationsHistoryMessageBatchSize = Objects.requireNonNull(conversationsHistoryMessageBatchSize, "conversationsHistoryMessageBatchSize");
            return this;
        }

        public final Builder setConversationMembersBatchSize(Supplier<Integer> conversationMembersBatchSize) {
            this.conversationMembersBatchSize = Objects.requireNonNull(conversationMembersBatchSize, "conversationMembersBatchSize");
            return this;
        }

        public final Builder setSlackRateLimiter(@Nullable SlackRateLimiter slackRateLimiter) {
            this.slackRateLimiter = slackRateLimiter;
            return this;
        }

        public final Builder setSlackRateLimiter(Optional<? extends SlackRateLimiter> slackRateLimiter) {
            this.slackRateLimiter = slackRateLimiter.orElse(null);
            return this;
        }

        public final Builder setHttpConfig(@Nullable HttpConfig httpConfig) {
            this.httpConfig = httpConfig;
            return this;
        }

        public final Builder setHttpConfig(Optional<? extends HttpConfig> httpConfig) {
            this.httpConfig = httpConfig.orElse(null);
            return this;
        }

        public final Builder setHttpClient(@Nullable NioHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public final Builder setHttpClient(Optional<? extends NioHttpClient> httpClient) {
            this.httpClient = httpClient.orElse(null);
            return this;
        }

        public final Builder setMethodFilter(@Nullable SlackMethodAcceptor methodFilter) {
            this.methodFilter = methodFilter;
            return this;
        }

        public final Builder setMethodFilter(Optional<? extends SlackMethodAcceptor> methodFilter) {
            this.methodFilter = methodFilter.orElse(null);
            return this;
        }

        public final Builder setRequestDebugger(@Nullable RequestDebugger requestDebugger) {
            this.requestDebugger = requestDebugger;
            return this;
        }

        public final Builder setRequestDebugger(Optional<? extends RequestDebugger> requestDebugger) {
            this.requestDebugger = requestDebugger.orElse(null);
            return this;
        }

        public final Builder setResponseDebugger(@Nullable ResponseDebugger responseDebugger) {
            this.responseDebugger = responseDebugger;
            return this;
        }

        public final Builder setResponseDebugger(Optional<? extends ResponseDebugger> responseDebugger) {
            this.responseDebugger = responseDebugger.orElse(null);
            return this;
        }

        public SlackClientRuntimeConfig build() {
            this.checkRequiredAttributes();
            return new SlackClientRuntimeConfig(this);
        }

        private boolean tokenSupplierIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.tokenSupplierIsSet()) {
                attributes.add("tokenSupplier");
            }
            return "Cannot build SlackClientRuntimeConfig, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackClientRuntimeConfigIF", generator="Immutables")
    static final class Json
    implements SlackClientRuntimeConfigIF {
        @Nullable
        Supplier<String> tokenSupplier;
        @Nullable
        Supplier<String> slackApiBasePath;
        @Nullable
        Supplier<Integer> usersListBatchSize;
        @Nullable
        Supplier<Integer> channelsListBatchSize;
        @Nullable
        Supplier<Integer> channelsHistoryMessageBatchSize;
        @Nullable
        Supplier<Integer> conversationsHistoryMessageBatchSize;
        @Nullable
        Supplier<Integer> conversationMembersBatchSize;
        @Nullable
        Optional<SlackRateLimiter> slackRateLimiter = Optional.empty();
        @Nullable
        Optional<HttpConfig> httpConfig = Optional.empty();
        @Nullable
        Optional<NioHttpClient> httpClient = Optional.empty();
        @Nullable
        Optional<SlackMethodAcceptor> methodFilter = Optional.empty();
        @Nullable
        Optional<RequestDebugger> requestDebugger = Optional.empty();
        @Nullable
        Optional<ResponseDebugger> responseDebugger = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTokenSupplier(Supplier<String> tokenSupplier) {
            this.tokenSupplier = tokenSupplier;
        }

        @JsonProperty
        public void setSlackApiBasePath(Supplier<String> slackApiBasePath) {
            this.slackApiBasePath = slackApiBasePath;
        }

        @JsonProperty
        public void setUsersListBatchSize(Supplier<Integer> usersListBatchSize) {
            this.usersListBatchSize = usersListBatchSize;
        }

        @JsonProperty
        public void setChannelsListBatchSize(Supplier<Integer> channelsListBatchSize) {
            this.channelsListBatchSize = channelsListBatchSize;
        }

        @JsonProperty
        public void setChannelsHistoryMessageBatchSize(Supplier<Integer> channelsHistoryMessageBatchSize) {
            this.channelsHistoryMessageBatchSize = channelsHistoryMessageBatchSize;
        }

        @JsonProperty
        public void setConversationsHistoryMessageBatchSize(Supplier<Integer> conversationsHistoryMessageBatchSize) {
            this.conversationsHistoryMessageBatchSize = conversationsHistoryMessageBatchSize;
        }

        @JsonProperty
        public void setConversationMembersBatchSize(Supplier<Integer> conversationMembersBatchSize) {
            this.conversationMembersBatchSize = conversationMembersBatchSize;
        }

        @JsonProperty
        public void setSlackRateLimiter(Optional<SlackRateLimiter> slackRateLimiter) {
            this.slackRateLimiter = slackRateLimiter;
        }

        @JsonProperty
        public void setHttpConfig(Optional<HttpConfig> httpConfig) {
            this.httpConfig = httpConfig;
        }

        @JsonProperty
        public void setHttpClient(Optional<NioHttpClient> httpClient) {
            this.httpClient = httpClient;
        }

        @JsonProperty
        public void setMethodFilter(Optional<SlackMethodAcceptor> methodFilter) {
            this.methodFilter = methodFilter;
        }

        @JsonProperty
        public void setRequestDebugger(Optional<RequestDebugger> requestDebugger) {
            this.requestDebugger = requestDebugger;
        }

        @JsonProperty
        public void setResponseDebugger(Optional<ResponseDebugger> responseDebugger) {
            this.responseDebugger = responseDebugger;
        }

        @Override
        public Supplier<String> getTokenSupplier() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Supplier<String> getSlackApiBasePath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Supplier<Integer> getUsersListBatchSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Supplier<Integer> getChannelsListBatchSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Supplier<Integer> getChannelsHistoryMessageBatchSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Supplier<Integer> getConversationsHistoryMessageBatchSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Supplier<Integer> getConversationMembersBatchSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackRateLimiter> getSlackRateLimiter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<HttpConfig> getHttpConfig() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<NioHttpClient> getHttpClient() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMethodAcceptor> getMethodFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<RequestDebugger> getRequestDebugger() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseDebugger> getResponseDebugger() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="SlackClientRuntimeConfigIF", generator="Immutables")
    private final class InitShim {
        private byte slackApiBasePathBuildStage = 0;
        private Supplier<String> slackApiBasePath;
        private byte usersListBatchSizeBuildStage = 0;
        private Supplier<Integer> usersListBatchSize;
        private byte channelsListBatchSizeBuildStage = 0;
        private Supplier<Integer> channelsListBatchSize;
        private byte channelsHistoryMessageBatchSizeBuildStage = 0;
        private Supplier<Integer> channelsHistoryMessageBatchSize;
        private byte conversationsHistoryMessageBatchSizeBuildStage = 0;
        private Supplier<Integer> conversationsHistoryMessageBatchSize;
        private byte conversationMembersBatchSizeBuildStage = 0;
        private Supplier<Integer> conversationMembersBatchSize;

        private InitShim() {
        }

        Supplier<String> getSlackApiBasePath() {
            if (this.slackApiBasePathBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.slackApiBasePathBuildStage == 0) {
                this.slackApiBasePathBuildStage = (byte)-1;
                this.slackApiBasePath = Objects.requireNonNull(SlackClientRuntimeConfig.this.getSlackApiBasePathInitialize(), "slackApiBasePath");
                this.slackApiBasePathBuildStage = 1;
            }
            return this.slackApiBasePath;
        }

        void setSlackApiBasePath(Supplier<String> slackApiBasePath) {
            this.slackApiBasePath = slackApiBasePath;
            this.slackApiBasePathBuildStage = 1;
        }

        Supplier<Integer> getUsersListBatchSize() {
            if (this.usersListBatchSizeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.usersListBatchSizeBuildStage == 0) {
                this.usersListBatchSizeBuildStage = (byte)-1;
                this.usersListBatchSize = Objects.requireNonNull(SlackClientRuntimeConfig.this.getUsersListBatchSizeInitialize(), "usersListBatchSize");
                this.usersListBatchSizeBuildStage = 1;
            }
            return this.usersListBatchSize;
        }

        void setUsersListBatchSize(Supplier<Integer> usersListBatchSize) {
            this.usersListBatchSize = usersListBatchSize;
            this.usersListBatchSizeBuildStage = 1;
        }

        Supplier<Integer> getChannelsListBatchSize() {
            if (this.channelsListBatchSizeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.channelsListBatchSizeBuildStage == 0) {
                this.channelsListBatchSizeBuildStage = (byte)-1;
                this.channelsListBatchSize = Objects.requireNonNull(SlackClientRuntimeConfig.this.getChannelsListBatchSizeInitialize(), "channelsListBatchSize");
                this.channelsListBatchSizeBuildStage = 1;
            }
            return this.channelsListBatchSize;
        }

        void setChannelsListBatchSize(Supplier<Integer> channelsListBatchSize) {
            this.channelsListBatchSize = channelsListBatchSize;
            this.channelsListBatchSizeBuildStage = 1;
        }

        Supplier<Integer> getChannelsHistoryMessageBatchSize() {
            if (this.channelsHistoryMessageBatchSizeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.channelsHistoryMessageBatchSizeBuildStage == 0) {
                this.channelsHistoryMessageBatchSizeBuildStage = (byte)-1;
                this.channelsHistoryMessageBatchSize = Objects.requireNonNull(SlackClientRuntimeConfig.this.getChannelsHistoryMessageBatchSizeInitialize(), "channelsHistoryMessageBatchSize");
                this.channelsHistoryMessageBatchSizeBuildStage = 1;
            }
            return this.channelsHistoryMessageBatchSize;
        }

        void setChannelsHistoryMessageBatchSize(Supplier<Integer> channelsHistoryMessageBatchSize) {
            this.channelsHistoryMessageBatchSize = channelsHistoryMessageBatchSize;
            this.channelsHistoryMessageBatchSizeBuildStage = 1;
        }

        Supplier<Integer> getConversationsHistoryMessageBatchSize() {
            if (this.conversationsHistoryMessageBatchSizeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.conversationsHistoryMessageBatchSizeBuildStage == 0) {
                this.conversationsHistoryMessageBatchSizeBuildStage = (byte)-1;
                this.conversationsHistoryMessageBatchSize = Objects.requireNonNull(SlackClientRuntimeConfig.this.getConversationsHistoryMessageBatchSizeInitialize(), "conversationsHistoryMessageBatchSize");
                this.conversationsHistoryMessageBatchSizeBuildStage = 1;
            }
            return this.conversationsHistoryMessageBatchSize;
        }

        void setConversationsHistoryMessageBatchSize(Supplier<Integer> conversationsHistoryMessageBatchSize) {
            this.conversationsHistoryMessageBatchSize = conversationsHistoryMessageBatchSize;
            this.conversationsHistoryMessageBatchSizeBuildStage = 1;
        }

        Supplier<Integer> getConversationMembersBatchSize() {
            if (this.conversationMembersBatchSizeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.conversationMembersBatchSizeBuildStage == 0) {
                this.conversationMembersBatchSizeBuildStage = (byte)-1;
                this.conversationMembersBatchSize = Objects.requireNonNull(SlackClientRuntimeConfig.this.getConversationMembersBatchSizeInitialize(), "conversationMembersBatchSize");
                this.conversationMembersBatchSizeBuildStage = 1;
            }
            return this.conversationMembersBatchSize;
        }

        void setConversationMembersBatchSize(Supplier<Integer> conversationMembersBatchSize) {
            this.conversationMembersBatchSize = conversationMembersBatchSize;
            this.conversationMembersBatchSizeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.slackApiBasePathBuildStage == -1) {
                attributes.add("slackApiBasePath");
            }
            if (this.usersListBatchSizeBuildStage == -1) {
                attributes.add("usersListBatchSize");
            }
            if (this.channelsListBatchSizeBuildStage == -1) {
                attributes.add("channelsListBatchSize");
            }
            if (this.channelsHistoryMessageBatchSizeBuildStage == -1) {
                attributes.add("channelsHistoryMessageBatchSize");
            }
            if (this.conversationsHistoryMessageBatchSizeBuildStage == -1) {
                attributes.add("conversationsHistoryMessageBatchSize");
            }
            if (this.conversationMembersBatchSizeBuildStage == -1) {
                attributes.add("conversationMembersBatchSize");
            }
            return "Cannot build SlackClientRuntimeConfig, attribute initializers form cycle " + attributes;
        }
    }
}

