/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.users.SlackUserCore;
import com.hubspot.slack.client.models.users.SlackUserLiteIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackUserLiteIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackUserLite
implements SlackUserLiteIF {
    private final String id;
    @Nullable
    private final String username;
    @Nullable
    private final String accessToken;

    private SlackUserLite(String id, @Nullable String username, @Nullable String accessToken) {
        this.id = id;
        this.username = username;
        this.accessToken = accessToken;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    @JsonProperty
    public Optional<String> getAccessToken() {
        return Optional.ofNullable(this.accessToken);
    }

    public final SlackUserLite withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new SlackUserLite(newValue, this.username, this.accessToken);
    }

    public final SlackUserLite withUsername(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return new SlackUserLite(this.id, newValue, this.accessToken);
    }

    public final SlackUserLite withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new SlackUserLite(this.id, value, this.accessToken);
    }

    public final SlackUserLite withAccessToken(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.accessToken, newValue)) {
            return this;
        }
        return new SlackUserLite(this.id, this.username, newValue);
    }

    public final SlackUserLite withAccessToken(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.accessToken, value)) {
            return this;
        }
        return new SlackUserLite(this.id, this.username, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackUserLite && this.equalTo(0, (SlackUserLite)another);
    }

    private boolean equalTo(int synthetic, SlackUserLite another) {
        return this.id.equals(another.id) && Objects.equals(this.username, another.username) && Objects.equals(this.accessToken, another.accessToken);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.accessToken);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackUserLite{");
        builder.append("id=").append(this.id);
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        if (this.accessToken != null) {
            builder.append(", ");
            builder.append("accessToken=").append(this.accessToken);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackUserLite fromJson(Json json) {
        Builder builder = SlackUserLite.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.accessToken != null) {
            builder.setAccessToken(json.accessToken);
        }
        return builder.build();
    }

    public static SlackUserLite copyOf(SlackUserLiteIF instance) {
        if (instance instanceof SlackUserLite) {
            return (SlackUserLite)instance;
        }
        return SlackUserLite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackUserLiteIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String username;
        @Nullable
        private String accessToken;

        private Builder() {
        }

        public final Builder from(SlackUserCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackUserLiteIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackUserCore instance;
            long bits = 0L;
            if (object instanceof SlackUserCore) {
                instance = (SlackUserCore)object;
                if ((bits & 1L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> usernameOptional = instance.getUsername();
                    if (usernameOptional.isPresent()) {
                        this.setUsername(usernameOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof SlackUserLiteIF) {
                instance = (SlackUserLiteIF)object;
                Optional<String> accessTokenOptional = instance.getAccessToken();
                if (accessTokenOptional.isPresent()) {
                    this.setAccessToken(accessTokenOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> usernameOptional = instance.getUsername();
                    if (usernameOptional.isPresent()) {
                        this.setUsername(usernameOptional);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder setUsername(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public final Builder setAccessToken(@Nullable String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public final Builder setAccessToken(Optional<String> accessToken) {
            this.accessToken = accessToken.orElse(null);
            return this;
        }

        public SlackUserLite build() {
            this.checkRequiredAttributes();
            return new SlackUserLite(this.id, this.username, this.accessToken);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build SlackUserLite, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackUserLiteIF", generator="Immutables")
    static final class Json
    implements SlackUserLiteIF {
        @Nullable
        String id;
        @Nullable
        Optional<String> username = Optional.empty();
        @Nullable
        Optional<String> accessToken = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @JsonProperty
        public void setAccessToken(Optional<String> accessToken) {
            this.accessToken = accessToken;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAccessToken() {
            throw new UnsupportedOperationException();
        }
    }
}

