/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.users.SlackUserCore;
import com.hubspot.slack.client.models.users.SlackUserIF;
import com.hubspot.slack.client.models.users.UserProfile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackUserIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackUser
implements SlackUserIF {
    private final String id;
    @Nullable
    private final String username;
    @Nullable
    private final UserProfile profile;
    @Nullable
    private final Boolean deleted;
    @Nullable
    private final String color;
    @Nullable
    private final String admin;
    @Nullable
    private final String owner;
    @Nullable
    private final String teamId;
    @Nullable
    private final String realName;
    @Nullable
    private final Boolean primaryOwner;
    @Nullable
    private final Boolean restricted;
    @Nullable
    private final Boolean ultraRestricted;
    @Nullable
    private final Boolean bot;
    @Nullable
    private final Boolean appUser;
    @Nullable
    private final String timezone;
    @Nullable
    private final String timezoneLabel;
    @Nullable
    private final String timezoneOffset;
    @Nullable
    private final Integer rawUpdated;
    @Nullable
    private final String locale;
    private final transient Optional<Long> updatedAt;

    private SlackUser(String id, @Nullable String username, @Nullable UserProfile profile, @Nullable Boolean deleted, @Nullable String color, @Nullable String admin, @Nullable String owner, @Nullable String teamId, @Nullable String realName, @Nullable Boolean primaryOwner, @Nullable Boolean restricted, @Nullable Boolean ultraRestricted, @Nullable Boolean bot, @Nullable Boolean appUser, @Nullable String timezone, @Nullable String timezoneLabel, @Nullable String timezoneOffset, @Nullable Integer rawUpdated, @Nullable String locale) {
        this.id = id;
        this.username = username;
        this.profile = profile;
        this.deleted = deleted;
        this.color = color;
        this.admin = admin;
        this.owner = owner;
        this.teamId = teamId;
        this.realName = realName;
        this.primaryOwner = primaryOwner;
        this.restricted = restricted;
        this.ultraRestricted = ultraRestricted;
        this.bot = bot;
        this.appUser = appUser;
        this.timezone = timezone;
        this.timezoneLabel = timezoneLabel;
        this.timezoneOffset = timezoneOffset;
        this.rawUpdated = rawUpdated;
        this.locale = locale;
        this.updatedAt = Objects.requireNonNull(SlackUserIF.super.getUpdatedAt(), "updatedAt");
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    @JsonProperty
    public Optional<UserProfile> getProfile() {
        return Optional.ofNullable(this.profile);
    }

    @Override
    @JsonProperty(value="deleted")
    public Optional<Boolean> isDeleted() {
        return Optional.ofNullable(this.deleted);
    }

    @Override
    @JsonProperty
    public Optional<String> getColor() {
        return Optional.ofNullable(this.color);
    }

    @Override
    @JsonProperty
    public Optional<String> isAdmin() {
        return Optional.ofNullable(this.admin);
    }

    @Override
    @JsonProperty
    public Optional<String> isOwner() {
        return Optional.ofNullable(this.owner);
    }

    @Override
    @JsonProperty
    public Optional<String> getTeamId() {
        return Optional.ofNullable(this.teamId);
    }

    @Override
    @JsonProperty
    public Optional<String> getRealName() {
        return Optional.ofNullable(this.realName);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isPrimaryOwner() {
        return Optional.ofNullable(this.primaryOwner);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isRestricted() {
        return Optional.ofNullable(this.restricted);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isUltraRestricted() {
        return Optional.ofNullable(this.ultraRestricted);
    }

    @Override
    @JsonProperty(value="is_bot")
    public Optional<Boolean> isBot() {
        return Optional.ofNullable(this.bot);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isAppUser() {
        return Optional.ofNullable(this.appUser);
    }

    @Override
    @JsonProperty(value="tz")
    public Optional<String> getTimezone() {
        return Optional.ofNullable(this.timezone);
    }

    @Override
    @JsonProperty(value="tz_label")
    public Optional<String> getTimezoneLabel() {
        return Optional.ofNullable(this.timezoneLabel);
    }

    @Override
    @JsonProperty(value="tz_offset")
    public Optional<String> getTimezoneOffset() {
        return Optional.ofNullable(this.timezoneOffset);
    }

    @Override
    @JsonProperty(value="updated")
    public Optional<Integer> getRawUpdated() {
        return Optional.ofNullable(this.rawUpdated);
    }

    @Override
    @JsonProperty
    public Optional<String> getLocale() {
        return Optional.ofNullable(this.locale);
    }

    @Override
    @JsonProperty
    public Optional<Long> getUpdatedAt() {
        return this.updatedAt;
    }

    public final SlackUser withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new SlackUser(newValue, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withUsername(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return new SlackUser(this.id, newValue, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new SlackUser(this.id, value, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withProfile(@Nullable UserProfile value) {
        UserProfile newValue = value;
        if (this.profile == newValue) {
            return this;
        }
        return new SlackUser(this.id, this.username, newValue, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withProfile(Optional<? extends UserProfile> optional) {
        UserProfile value = optional.orElse(null);
        if (this.profile == value) {
            return this;
        }
        return new SlackUser(this.id, this.username, value, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withDeleted(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.deleted, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, newValue, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withDeleted(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.deleted, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, value, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withColor(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.color, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, newValue, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withColor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.color, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, value, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withAdmin(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.admin, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, newValue, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withAdmin(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.admin, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, value, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withOwner(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.owner, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, newValue, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withOwner(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.owner, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, value, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withTeamId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.teamId, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, newValue, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withTeamId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.teamId, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, value, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withRealName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.realName, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, newValue, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withRealName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.realName, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, value, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withPrimaryOwner(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.primaryOwner, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, newValue, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withPrimaryOwner(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.primaryOwner, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, value, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withRestricted(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.restricted, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, newValue, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withRestricted(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.restricted, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, value, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withUltraRestricted(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.ultraRestricted, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, newValue, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withUltraRestricted(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.ultraRestricted, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, value, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withBot(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.bot, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, newValue, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withBot(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.bot, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, value, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withAppUser(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.appUser, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, newValue, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withAppUser(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.appUser, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, value, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withTimezone(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.timezone, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, newValue, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withTimezone(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.timezone, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, value, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withTimezoneLabel(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.timezoneLabel, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, newValue, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withTimezoneLabel(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.timezoneLabel, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, value, this.timezoneOffset, this.rawUpdated, this.locale);
    }

    public final SlackUser withTimezoneOffset(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.timezoneOffset, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, newValue, this.rawUpdated, this.locale);
    }

    public final SlackUser withTimezoneOffset(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.timezoneOffset, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, value, this.rawUpdated, this.locale);
    }

    public final SlackUser withRawUpdated(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.rawUpdated, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, newValue, this.locale);
    }

    public final SlackUser withRawUpdated(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.rawUpdated, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, value, this.locale);
    }

    public final SlackUser withLocale(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.locale, newValue)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, newValue);
    }

    public final SlackUser withLocale(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.locale, value)) {
            return this;
        }
        return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackUser && this.equalTo(0, (SlackUser)another);
    }

    private boolean equalTo(int synthetic, SlackUser another) {
        return this.id.equals(another.id) && Objects.equals(this.username, another.username) && Objects.equals(this.profile, another.profile) && Objects.equals(this.deleted, another.deleted) && Objects.equals(this.color, another.color) && Objects.equals(this.admin, another.admin) && Objects.equals(this.owner, another.owner) && Objects.equals(this.teamId, another.teamId) && Objects.equals(this.realName, another.realName) && Objects.equals(this.primaryOwner, another.primaryOwner) && Objects.equals(this.restricted, another.restricted) && Objects.equals(this.ultraRestricted, another.ultraRestricted) && Objects.equals(this.bot, another.bot) && Objects.equals(this.appUser, another.appUser) && Objects.equals(this.timezone, another.timezone) && Objects.equals(this.timezoneLabel, another.timezoneLabel) && Objects.equals(this.timezoneOffset, another.timezoneOffset) && Objects.equals(this.rawUpdated, another.rawUpdated) && Objects.equals(this.locale, another.locale) && this.updatedAt.equals(another.updatedAt);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + Objects.hashCode(this.profile);
        h += (h << 5) + Objects.hashCode(this.deleted);
        h += (h << 5) + Objects.hashCode(this.color);
        h += (h << 5) + Objects.hashCode(this.admin);
        h += (h << 5) + Objects.hashCode(this.owner);
        h += (h << 5) + Objects.hashCode(this.teamId);
        h += (h << 5) + Objects.hashCode(this.realName);
        h += (h << 5) + Objects.hashCode(this.primaryOwner);
        h += (h << 5) + Objects.hashCode(this.restricted);
        h += (h << 5) + Objects.hashCode(this.ultraRestricted);
        h += (h << 5) + Objects.hashCode(this.bot);
        h += (h << 5) + Objects.hashCode(this.appUser);
        h += (h << 5) + Objects.hashCode(this.timezone);
        h += (h << 5) + Objects.hashCode(this.timezoneLabel);
        h += (h << 5) + Objects.hashCode(this.timezoneOffset);
        h += (h << 5) + Objects.hashCode(this.rawUpdated);
        h += (h << 5) + Objects.hashCode(this.locale);
        h += (h << 5) + this.updatedAt.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackUser{");
        builder.append("id=").append(this.id);
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        if (this.profile != null) {
            builder.append(", ");
            builder.append("profile=").append(this.profile);
        }
        if (this.deleted != null) {
            builder.append(", ");
            builder.append("deleted=").append(this.deleted);
        }
        if (this.color != null) {
            builder.append(", ");
            builder.append("color=").append(this.color);
        }
        if (this.admin != null) {
            builder.append(", ");
            builder.append("admin=").append(this.admin);
        }
        if (this.owner != null) {
            builder.append(", ");
            builder.append("owner=").append(this.owner);
        }
        if (this.teamId != null) {
            builder.append(", ");
            builder.append("teamId=").append(this.teamId);
        }
        if (this.realName != null) {
            builder.append(", ");
            builder.append("realName=").append(this.realName);
        }
        if (this.primaryOwner != null) {
            builder.append(", ");
            builder.append("primaryOwner=").append(this.primaryOwner);
        }
        if (this.restricted != null) {
            builder.append(", ");
            builder.append("restricted=").append(this.restricted);
        }
        if (this.ultraRestricted != null) {
            builder.append(", ");
            builder.append("ultraRestricted=").append(this.ultraRestricted);
        }
        if (this.bot != null) {
            builder.append(", ");
            builder.append("bot=").append(this.bot);
        }
        if (this.appUser != null) {
            builder.append(", ");
            builder.append("appUser=").append(this.appUser);
        }
        if (this.timezone != null) {
            builder.append(", ");
            builder.append("timezone=").append(this.timezone);
        }
        if (this.timezoneLabel != null) {
            builder.append(", ");
            builder.append("timezoneLabel=").append(this.timezoneLabel);
        }
        if (this.timezoneOffset != null) {
            builder.append(", ");
            builder.append("timezoneOffset=").append(this.timezoneOffset);
        }
        if (this.rawUpdated != null) {
            builder.append(", ");
            builder.append("rawUpdated=").append(this.rawUpdated);
        }
        if (this.locale != null) {
            builder.append(", ");
            builder.append("locale=").append(this.locale);
        }
        builder.append(", ");
        builder.append("updatedAt=").append(this.updatedAt);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackUser fromJson(Json json) {
        Builder builder = SlackUser.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.profile != null) {
            builder.setProfile(json.profile);
        }
        if (json.deleted != null) {
            builder.setDeleted(json.deleted);
        }
        if (json.color != null) {
            builder.setColor(json.color);
        }
        if (json.admin != null) {
            builder.setAdmin(json.admin);
        }
        if (json.owner != null) {
            builder.setOwner(json.owner);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.realName != null) {
            builder.setRealName(json.realName);
        }
        if (json.primaryOwner != null) {
            builder.setPrimaryOwner(json.primaryOwner);
        }
        if (json.restricted != null) {
            builder.setRestricted(json.restricted);
        }
        if (json.ultraRestricted != null) {
            builder.setUltraRestricted(json.ultraRestricted);
        }
        if (json.bot != null) {
            builder.setBot(json.bot);
        }
        if (json.appUser != null) {
            builder.setAppUser(json.appUser);
        }
        if (json.timezone != null) {
            builder.setTimezone(json.timezone);
        }
        if (json.timezoneLabel != null) {
            builder.setTimezoneLabel(json.timezoneLabel);
        }
        if (json.timezoneOffset != null) {
            builder.setTimezoneOffset(json.timezoneOffset);
        }
        if (json.rawUpdated != null) {
            builder.setRawUpdated(json.rawUpdated);
        }
        if (json.locale != null) {
            builder.setLocale(json.locale);
        }
        return builder.build();
    }

    public static SlackUser copyOf(SlackUserIF instance) {
        if (instance instanceof SlackUser) {
            return (SlackUser)instance;
        }
        return SlackUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackUserIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String username;
        @Nullable
        private UserProfile profile;
        @Nullable
        private Boolean deleted;
        @Nullable
        private String color;
        @Nullable
        private String admin;
        @Nullable
        private String owner;
        @Nullable
        private String teamId;
        @Nullable
        private String realName;
        @Nullable
        private Boolean primaryOwner;
        @Nullable
        private Boolean restricted;
        @Nullable
        private Boolean ultraRestricted;
        @Nullable
        private Boolean bot;
        @Nullable
        private Boolean appUser;
        @Nullable
        private String timezone;
        @Nullable
        private String timezoneLabel;
        @Nullable
        private String timezoneOffset;
        @Nullable
        private Integer rawUpdated;
        @Nullable
        private String locale;

        private Builder() {
        }

        public final Builder from(SlackUserIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackUserCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackUserCore instance;
            long bits = 0L;
            if (object instanceof SlackUserIF) {
                Optional<Integer> rawUpdatedOptional;
                Optional<Boolean> ultraRestrictedOptional;
                Optional<String> teamIdOptional;
                Optional<Boolean> restrictedOptional;
                Optional<String> timezoneOffsetOptional;
                Optional<Boolean> deletedOptional;
                Optional<String> realNameOptional;
                Optional<String> localeOptional;
                Optional<String> adminOptional;
                Optional<Boolean> primaryOwnerOptional;
                Optional<UserProfile> profileOptional;
                Optional<String> timezoneOptional;
                Optional<Boolean> botOptional;
                Optional<String> colorOptional;
                Optional<String> timezoneLabelOptional;
                Optional<Boolean> appUserOptional;
                instance = (SlackUserIF)object;
                Optional<String> ownerOptional = instance.isOwner();
                if (ownerOptional.isPresent()) {
                    this.setOwner(ownerOptional);
                }
                if ((appUserOptional = instance.isAppUser()).isPresent()) {
                    this.setAppUser(appUserOptional);
                }
                if ((timezoneLabelOptional = instance.getTimezoneLabel()).isPresent()) {
                    this.setTimezoneLabel(timezoneLabelOptional);
                }
                if ((colorOptional = instance.getColor()).isPresent()) {
                    this.setColor(colorOptional);
                }
                if ((botOptional = instance.isBot()).isPresent()) {
                    this.setBot(botOptional);
                }
                if ((timezoneOptional = instance.getTimezone()).isPresent()) {
                    this.setTimezone(timezoneOptional);
                }
                if ((profileOptional = instance.getProfile()).isPresent()) {
                    this.setProfile(profileOptional);
                }
                if ((primaryOwnerOptional = instance.isPrimaryOwner()).isPresent()) {
                    this.setPrimaryOwner(primaryOwnerOptional);
                }
                if ((adminOptional = instance.isAdmin()).isPresent()) {
                    this.setAdmin(adminOptional);
                }
                if ((localeOptional = instance.getLocale()).isPresent()) {
                    this.setLocale(localeOptional);
                }
                if ((realNameOptional = instance.getRealName()).isPresent()) {
                    this.setRealName(realNameOptional);
                }
                if ((deletedOptional = instance.isDeleted()).isPresent()) {
                    this.setDeleted(deletedOptional);
                }
                if ((timezoneOffsetOptional = instance.getTimezoneOffset()).isPresent()) {
                    this.setTimezoneOffset(timezoneOffsetOptional);
                }
                if ((restrictedOptional = instance.isRestricted()).isPresent()) {
                    this.setRestricted(restrictedOptional);
                }
                if ((teamIdOptional = instance.getTeamId()).isPresent()) {
                    this.setTeamId(teamIdOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 1L;
                }
                if ((ultraRestrictedOptional = instance.isUltraRestricted()).isPresent()) {
                    this.setUltraRestricted(ultraRestrictedOptional);
                }
                if ((rawUpdatedOptional = instance.getRawUpdated()).isPresent()) {
                    this.setRawUpdated(rawUpdatedOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> usernameOptional = instance.getUsername();
                    if (usernameOptional.isPresent()) {
                        this.setUsername(usernameOptional);
                    }
                    bits |= 2L;
                }
            }
            if (object instanceof SlackUserCore) {
                instance = (SlackUserCore)object;
                if ((bits & 1L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<String> usernameOptional = instance.getUsername();
                    if (usernameOptional.isPresent()) {
                        this.setUsername(usernameOptional);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder setUsername(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public final Builder setProfile(@Nullable UserProfile profile) {
            this.profile = profile;
            return this;
        }

        public final Builder setProfile(Optional<? extends UserProfile> profile) {
            this.profile = profile.orElse(null);
            return this;
        }

        public final Builder setDeleted(@Nullable Boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public final Builder setDeleted(Optional<Boolean> deleted) {
            this.deleted = deleted.orElse(null);
            return this;
        }

        public final Builder setColor(@Nullable String color) {
            this.color = color;
            return this;
        }

        public final Builder setColor(Optional<String> color) {
            this.color = color.orElse(null);
            return this;
        }

        public final Builder setAdmin(@Nullable String admin) {
            this.admin = admin;
            return this;
        }

        public final Builder setAdmin(Optional<String> admin) {
            this.admin = admin.orElse(null);
            return this;
        }

        public final Builder setOwner(@Nullable String owner) {
            this.owner = owner;
            return this;
        }

        public final Builder setOwner(Optional<String> owner) {
            this.owner = owner.orElse(null);
            return this;
        }

        public final Builder setTeamId(@Nullable String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final Builder setTeamId(Optional<String> teamId) {
            this.teamId = teamId.orElse(null);
            return this;
        }

        public final Builder setRealName(@Nullable String realName) {
            this.realName = realName;
            return this;
        }

        public final Builder setRealName(Optional<String> realName) {
            this.realName = realName.orElse(null);
            return this;
        }

        public final Builder setPrimaryOwner(@Nullable Boolean primaryOwner) {
            this.primaryOwner = primaryOwner;
            return this;
        }

        public final Builder setPrimaryOwner(Optional<Boolean> primaryOwner) {
            this.primaryOwner = primaryOwner.orElse(null);
            return this;
        }

        public final Builder setRestricted(@Nullable Boolean restricted) {
            this.restricted = restricted;
            return this;
        }

        public final Builder setRestricted(Optional<Boolean> restricted) {
            this.restricted = restricted.orElse(null);
            return this;
        }

        public final Builder setUltraRestricted(@Nullable Boolean ultraRestricted) {
            this.ultraRestricted = ultraRestricted;
            return this;
        }

        public final Builder setUltraRestricted(Optional<Boolean> ultraRestricted) {
            this.ultraRestricted = ultraRestricted.orElse(null);
            return this;
        }

        public final Builder setBot(@Nullable Boolean bot) {
            this.bot = bot;
            return this;
        }

        public final Builder setBot(Optional<Boolean> bot) {
            this.bot = bot.orElse(null);
            return this;
        }

        public final Builder setAppUser(@Nullable Boolean appUser) {
            this.appUser = appUser;
            return this;
        }

        public final Builder setAppUser(Optional<Boolean> appUser) {
            this.appUser = appUser.orElse(null);
            return this;
        }

        public final Builder setTimezone(@Nullable String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Builder setTimezone(Optional<String> timezone) {
            this.timezone = timezone.orElse(null);
            return this;
        }

        public final Builder setTimezoneLabel(@Nullable String timezoneLabel) {
            this.timezoneLabel = timezoneLabel;
            return this;
        }

        public final Builder setTimezoneLabel(Optional<String> timezoneLabel) {
            this.timezoneLabel = timezoneLabel.orElse(null);
            return this;
        }

        public final Builder setTimezoneOffset(@Nullable String timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
            return this;
        }

        public final Builder setTimezoneOffset(Optional<String> timezoneOffset) {
            this.timezoneOffset = timezoneOffset.orElse(null);
            return this;
        }

        public final Builder setRawUpdated(@Nullable Integer rawUpdated) {
            this.rawUpdated = rawUpdated;
            return this;
        }

        public final Builder setRawUpdated(Optional<Integer> rawUpdated) {
            this.rawUpdated = rawUpdated.orElse(null);
            return this;
        }

        public final Builder setLocale(@Nullable String locale) {
            this.locale = locale;
            return this;
        }

        public final Builder setLocale(Optional<String> locale) {
            this.locale = locale.orElse(null);
            return this;
        }

        public SlackUser build() {
            this.checkRequiredAttributes();
            return new SlackUser(this.id, this.username, this.profile, this.deleted, this.color, this.admin, this.owner, this.teamId, this.realName, this.primaryOwner, this.restricted, this.ultraRestricted, this.bot, this.appUser, this.timezone, this.timezoneLabel, this.timezoneOffset, this.rawUpdated, this.locale);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build SlackUser, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackUserIF", generator="Immutables")
    static final class Json
    implements SlackUserIF {
        @Nullable
        String id;
        @Nullable
        Optional<String> username = Optional.empty();
        @Nullable
        Optional<UserProfile> profile = Optional.empty();
        @Nullable
        Optional<Boolean> deleted = Optional.empty();
        @Nullable
        Optional<String> color = Optional.empty();
        @Nullable
        Optional<String> admin = Optional.empty();
        @Nullable
        Optional<String> owner = Optional.empty();
        @Nullable
        Optional<String> teamId = Optional.empty();
        @Nullable
        Optional<String> realName = Optional.empty();
        @Nullable
        Optional<Boolean> primaryOwner = Optional.empty();
        @Nullable
        Optional<Boolean> restricted = Optional.empty();
        @Nullable
        Optional<Boolean> ultraRestricted = Optional.empty();
        @Nullable
        Optional<Boolean> bot = Optional.empty();
        @Nullable
        Optional<Boolean> appUser = Optional.empty();
        @Nullable
        Optional<String> timezone = Optional.empty();
        @Nullable
        Optional<String> timezoneLabel = Optional.empty();
        @Nullable
        Optional<String> timezoneOffset = Optional.empty();
        @Nullable
        Optional<Integer> rawUpdated = Optional.empty();
        @Nullable
        Optional<String> locale = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @JsonProperty
        public void setProfile(Optional<UserProfile> profile) {
            this.profile = profile;
        }

        @JsonProperty(value="deleted")
        public void setDeleted(Optional<Boolean> deleted) {
            this.deleted = deleted;
        }

        @JsonProperty
        public void setColor(Optional<String> color) {
            this.color = color;
        }

        @JsonProperty
        public void setAdmin(Optional<String> admin) {
            this.admin = admin;
        }

        @JsonProperty
        public void setOwner(Optional<String> owner) {
            this.owner = owner;
        }

        @JsonProperty
        public void setTeamId(Optional<String> teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setRealName(Optional<String> realName) {
            this.realName = realName;
        }

        @JsonProperty
        public void setPrimaryOwner(Optional<Boolean> primaryOwner) {
            this.primaryOwner = primaryOwner;
        }

        @JsonProperty
        public void setRestricted(Optional<Boolean> restricted) {
            this.restricted = restricted;
        }

        @JsonProperty
        public void setUltraRestricted(Optional<Boolean> ultraRestricted) {
            this.ultraRestricted = ultraRestricted;
        }

        @JsonProperty(value="is_bot")
        public void setBot(Optional<Boolean> bot) {
            this.bot = bot;
        }

        @JsonProperty
        public void setAppUser(Optional<Boolean> appUser) {
            this.appUser = appUser;
        }

        @JsonProperty(value="tz")
        public void setTimezone(Optional<String> timezone) {
            this.timezone = timezone;
        }

        @JsonProperty(value="tz_label")
        public void setTimezoneLabel(Optional<String> timezoneLabel) {
            this.timezoneLabel = timezoneLabel;
        }

        @JsonProperty(value="tz_offset")
        public void setTimezoneOffset(Optional<String> timezoneOffset) {
            this.timezoneOffset = timezoneOffset;
        }

        @JsonProperty(value="updated")
        public void setRawUpdated(Optional<Integer> rawUpdated) {
            this.rawUpdated = rawUpdated;
        }

        @JsonProperty
        public void setLocale(Optional<String> locale) {
            this.locale = locale;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UserProfile> getProfile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isDeleted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getColor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> isAdmin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> isOwner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRealName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isPrimaryOwner() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isRestricted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isUltraRestricted() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isBot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isAppUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTimezone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTimezoneLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTimezoneOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getRawUpdated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Optional<Long> getUpdatedAt() {
            throw new UnsupportedOperationException();
        }
    }
}

