/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.users.UsersListResponseIF;
import com.hubspot.slack.client.models.users.SlackUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsersListResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsersListResponse
implements UsersListResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final List<SlackUser> members;

    private UsersListResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, List<SlackUser> members) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.members = members;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public List<SlackUser> getMembers() {
        return this.members;
    }

    public final UsersListResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new UsersListResponse(value, this.responseMetadata, this.members);
    }

    public final UsersListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new UsersListResponse(this.ok, newValue, this.members);
    }

    public final UsersListResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new UsersListResponse(this.ok, value, this.members);
    }

    public final UsersListResponse withMembers(SlackUser ... elements) {
        List<SlackUser> newValue = UsersListResponse.createUnmodifiableList(false, UsersListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new UsersListResponse(this.ok, this.responseMetadata, newValue);
    }

    public final UsersListResponse withMembers(Iterable<? extends SlackUser> elements) {
        if (this.members == elements) {
            return this;
        }
        List<SlackUser> newValue = UsersListResponse.createUnmodifiableList(false, UsersListResponse.createSafeList(elements, true, false));
        return new UsersListResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsersListResponse && this.equalTo(0, (UsersListResponse)another);
    }

    private boolean equalTo(int synthetic, UsersListResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.members.equals(another.members);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.members.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsersListResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("members=").append(this.members);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsersListResponse fromJson(Json json) {
        Builder builder = UsersListResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.members != null) {
            builder.addAllMembers(json.members);
        }
        return builder.build();
    }

    public static UsersListResponse copyOf(UsersListResponseIF instance) {
        if (instance instanceof UsersListResponse) {
            return (UsersListResponse)instance;
        }
        return UsersListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="UsersListResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private List<SlackUser> members = new ArrayList<SlackUser>();

        private Builder() {
        }

        public final Builder from(UsersListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof UsersListResponseIF) {
                instance = (UsersListResponseIF)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.addAllMembers(instance.getMembers());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder addMembers(SlackUser element) {
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        public final Builder addMembers(SlackUser ... elements) {
            for (SlackUser element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        public final Builder setMembers(Iterable<? extends SlackUser> elements) {
            this.members.clear();
            return this.addAllMembers(elements);
        }

        public final Builder addAllMembers(Iterable<? extends SlackUser> elements) {
            for (SlackUser slackUser : elements) {
                this.members.add(Objects.requireNonNull(slackUser, "members element"));
            }
            return this;
        }

        public UsersListResponse build() {
            this.checkRequiredAttributes();
            return new UsersListResponse(this.ok, this.responseMetadata, UsersListResponse.createUnmodifiableList(true, this.members));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build UsersListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsersListResponseIF", generator="Immutables")
    static final class Json
    implements UsersListResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        List<SlackUser> members = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setMembers(List<SlackUser> members) {
            this.members = members;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackUser> getMembers() {
            throw new UnsupportedOperationException();
        }
    }
}

