/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.migration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.migration.MigrationExchangeResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MigrationExchangeResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class MigrationExchangeResponse
implements MigrationExchangeResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final String teamId;
    private final String enterpriseId;
    private final Map<String, String> userIdMap;
    private final Set<String> invalidUserIds;

    private MigrationExchangeResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, String teamId, String enterpriseId, Map<String, String> userIdMap, Set<String> invalidUserIds) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.teamId = teamId;
        this.enterpriseId = enterpriseId;
        this.userIdMap = userIdMap;
        this.invalidUserIds = invalidUserIds;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty
    public String getEnterpriseId() {
        return this.enterpriseId;
    }

    @Override
    @JsonProperty
    public Map<String, String> getUserIdMap() {
        return this.userIdMap;
    }

    @Override
    @JsonProperty
    public Set<String> getInvalidUserIds() {
        return this.invalidUserIds;
    }

    public final MigrationExchangeResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new MigrationExchangeResponse(value, this.responseMetadata, this.teamId, this.enterpriseId, this.userIdMap, this.invalidUserIds);
    }

    public final MigrationExchangeResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new MigrationExchangeResponse(this.ok, newValue, this.teamId, this.enterpriseId, this.userIdMap, this.invalidUserIds);
    }

    public final MigrationExchangeResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new MigrationExchangeResponse(this.ok, value, this.teamId, this.enterpriseId, this.userIdMap, this.invalidUserIds);
    }

    public final MigrationExchangeResponse withTeamId(String value) {
        String newValue = Objects.requireNonNull(value, "teamId");
        if (this.teamId.equals(newValue)) {
            return this;
        }
        return new MigrationExchangeResponse(this.ok, this.responseMetadata, newValue, this.enterpriseId, this.userIdMap, this.invalidUserIds);
    }

    public final MigrationExchangeResponse withEnterpriseId(String value) {
        String newValue = Objects.requireNonNull(value, "enterpriseId");
        if (this.enterpriseId.equals(newValue)) {
            return this;
        }
        return new MigrationExchangeResponse(this.ok, this.responseMetadata, this.teamId, newValue, this.userIdMap, this.invalidUserIds);
    }

    public final MigrationExchangeResponse withUserIdMap(Map<String, ? extends String> entries) {
        if (this.userIdMap == entries) {
            return this;
        }
        Map<String, String> newValue = MigrationExchangeResponse.createUnmodifiableMap(true, false, entries);
        return new MigrationExchangeResponse(this.ok, this.responseMetadata, this.teamId, this.enterpriseId, newValue, this.invalidUserIds);
    }

    public final MigrationExchangeResponse withInvalidUserIds(String ... elements) {
        Set<String> newValue = MigrationExchangeResponse.createUnmodifiableSet(MigrationExchangeResponse.createSafeList(Arrays.asList(elements), true, false));
        return new MigrationExchangeResponse(this.ok, this.responseMetadata, this.teamId, this.enterpriseId, this.userIdMap, newValue);
    }

    public final MigrationExchangeResponse withInvalidUserIds(Iterable<String> elements) {
        if (this.invalidUserIds == elements) {
            return this;
        }
        Set<String> newValue = MigrationExchangeResponse.createUnmodifiableSet(MigrationExchangeResponse.createSafeList(elements, true, false));
        return new MigrationExchangeResponse(this.ok, this.responseMetadata, this.teamId, this.enterpriseId, this.userIdMap, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MigrationExchangeResponse && this.equalTo(0, (MigrationExchangeResponse)another);
    }

    private boolean equalTo(int synthetic, MigrationExchangeResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.teamId.equals(another.teamId) && this.enterpriseId.equals(another.enterpriseId) && this.userIdMap.equals(another.userIdMap) && this.invalidUserIds.equals(another.invalidUserIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.teamId.hashCode();
        h += (h << 5) + this.enterpriseId.hashCode();
        h += (h << 5) + this.userIdMap.hashCode();
        h += (h << 5) + this.invalidUserIds.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MigrationExchangeResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("teamId=").append(this.teamId);
        builder.append(", ");
        builder.append("enterpriseId=").append(this.enterpriseId);
        builder.append(", ");
        builder.append("userIdMap=").append(this.userIdMap);
        builder.append(", ");
        builder.append("invalidUserIds=").append(this.invalidUserIds);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MigrationExchangeResponse fromJson(Json json) {
        Builder builder = MigrationExchangeResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.enterpriseId != null) {
            builder.setEnterpriseId(json.enterpriseId);
        }
        if (json.userIdMap != null) {
            builder.putAllUserIdMap(json.userIdMap);
        }
        if (json.invalidUserIds != null) {
            builder.addAllInvalidUserIds(json.invalidUserIds);
        }
        return builder.build();
    }

    public static MigrationExchangeResponse copyOf(MigrationExchangeResponseIF instance) {
        if (instance instanceof MigrationExchangeResponse) {
            return (MigrationExchangeResponse)instance;
        }
        return MigrationExchangeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="MigrationExchangeResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_TEAM_ID = 2L;
        private static final long INIT_BIT_ENTERPRISE_ID = 4L;
        private long initBits = 7L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private String teamId;
        @Nullable
        private String enterpriseId;
        private Map<String, String> userIdMap = new LinkedHashMap<String, String>();
        private List<String> invalidUserIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(MigrationExchangeResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof MigrationExchangeResponseIF) {
                instance = (MigrationExchangeResponseIF)object;
                this.putAllUserIdMap(instance.getUserIdMap());
                this.addAllInvalidUserIds(instance.getInvalidUserIds());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                this.setEnterpriseId(instance.getEnterpriseId());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setTeamId(instance.getTeamId());
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setEnterpriseId(String enterpriseId) {
            this.enterpriseId = Objects.requireNonNull(enterpriseId, "enterpriseId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder putUserIdMap(String key, String value) {
            this.userIdMap.put(Objects.requireNonNull(key, "userIdMap key"), Objects.requireNonNull(value, value == null ? "userIdMap value for key: " + key : null));
            return this;
        }

        public final Builder putUserIdMap(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.userIdMap.put(Objects.requireNonNull(k, "userIdMap key"), Objects.requireNonNull(v, (v = entry.getValue()) == null ? "userIdMap value for key: " + k : null));
            return this;
        }

        public final Builder setUserIdMap(Map<String, ? extends String> entries) {
            this.userIdMap.clear();
            return this.putAllUserIdMap(entries);
        }

        public final Builder putAllUserIdMap(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.userIdMap.put(Objects.requireNonNull(k, "userIdMap key"), Objects.requireNonNull(v, (v = e.getValue()) == null ? "userIdMap value for key: " + k : null));
            }
            return this;
        }

        public final Builder addInvalidUserIds(String element) {
            this.invalidUserIds.add(Objects.requireNonNull(element, "invalidUserIds element"));
            return this;
        }

        public final Builder addInvalidUserIds(String ... elements) {
            for (String element : elements) {
                this.invalidUserIds.add(Objects.requireNonNull(element, "invalidUserIds element"));
            }
            return this;
        }

        public final Builder setInvalidUserIds(Iterable<String> elements) {
            this.invalidUserIds.clear();
            return this.addAllInvalidUserIds(elements);
        }

        public final Builder addAllInvalidUserIds(Iterable<String> elements) {
            for (String element : elements) {
                this.invalidUserIds.add(Objects.requireNonNull(element, "invalidUserIds element"));
            }
            return this;
        }

        public MigrationExchangeResponse build() {
            this.checkRequiredAttributes();
            return new MigrationExchangeResponse(this.ok, this.responseMetadata, this.teamId, this.enterpriseId, MigrationExchangeResponse.createUnmodifiableMap(false, false, this.userIdMap), MigrationExchangeResponse.createUnmodifiableSet(this.invalidUserIds));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean teamIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean enterpriseIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.teamIdIsSet()) {
                attributes.add("teamId");
            }
            if (!this.enterpriseIdIsSet()) {
                attributes.add("enterpriseId");
            }
            return "Cannot build MigrationExchangeResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MigrationExchangeResponseIF", generator="Immutables")
    static final class Json
    implements MigrationExchangeResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        String teamId;
        @Nullable
        String enterpriseId;
        @Nullable
        Map<String, String> userIdMap = Collections.emptyMap();
        @Nullable
        Set<String> invalidUserIds = Collections.emptySet();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setEnterpriseId(String enterpriseId) {
            this.enterpriseId = enterpriseId;
        }

        @JsonProperty
        public void setUserIdMap(Map<String, String> userIdMap) {
            this.userIdMap = userIdMap;
        }

        @JsonProperty
        public void setInvalidUserIds(Set<String> invalidUserIds) {
            this.invalidUserIds = invalidUserIds;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEnterpriseId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getUserIdMap() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getInvalidUserIds() {
            throw new UnsupportedOperationException();
        }
    }
}

