/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.files.GetUploadUrlExternalResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="GetUploadUrlExternalResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class GetUploadUrlExternalResponse
implements GetUploadUrlExternalResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final String uploadUrl;
    private final String fileId;

    private GetUploadUrlExternalResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, String uploadUrl, String fileId) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.uploadUrl = uploadUrl;
        this.fileId = fileId;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public String getUploadUrl() {
        return this.uploadUrl;
    }

    @Override
    @JsonProperty
    public String getFileId() {
        return this.fileId;
    }

    public final GetUploadUrlExternalResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new GetUploadUrlExternalResponse(value, this.responseMetadata, this.uploadUrl, this.fileId);
    }

    public final GetUploadUrlExternalResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new GetUploadUrlExternalResponse(this.ok, newValue, this.uploadUrl, this.fileId);
    }

    public final GetUploadUrlExternalResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new GetUploadUrlExternalResponse(this.ok, value, this.uploadUrl, this.fileId);
    }

    public final GetUploadUrlExternalResponse withUploadUrl(String value) {
        String newValue = Objects.requireNonNull(value, "uploadUrl");
        if (this.uploadUrl.equals(newValue)) {
            return this;
        }
        return new GetUploadUrlExternalResponse(this.ok, this.responseMetadata, newValue, this.fileId);
    }

    public final GetUploadUrlExternalResponse withFileId(String value) {
        String newValue = Objects.requireNonNull(value, "fileId");
        if (this.fileId.equals(newValue)) {
            return this;
        }
        return new GetUploadUrlExternalResponse(this.ok, this.responseMetadata, this.uploadUrl, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GetUploadUrlExternalResponse && this.equalTo(0, (GetUploadUrlExternalResponse)another);
    }

    private boolean equalTo(int synthetic, GetUploadUrlExternalResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.uploadUrl.equals(another.uploadUrl) && this.fileId.equals(another.fileId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.uploadUrl.hashCode();
        h += (h << 5) + this.fileId.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GetUploadUrlExternalResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("uploadUrl=").append(this.uploadUrl);
        builder.append(", ");
        builder.append("fileId=").append(this.fileId);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GetUploadUrlExternalResponse fromJson(Json json) {
        Builder builder = GetUploadUrlExternalResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.uploadUrl != null) {
            builder.setUploadUrl(json.uploadUrl);
        }
        if (json.fileId != null) {
            builder.setFileId(json.fileId);
        }
        return builder.build();
    }

    public static GetUploadUrlExternalResponse copyOf(GetUploadUrlExternalResponseIF instance) {
        if (instance instanceof GetUploadUrlExternalResponse) {
            return (GetUploadUrlExternalResponse)instance;
        }
        return GetUploadUrlExternalResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GetUploadUrlExternalResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_UPLOAD_URL = 2L;
        private static final long INIT_BIT_FILE_ID = 4L;
        private long initBits = 7L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private String uploadUrl;
        @Nullable
        private String fileId;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(GetUploadUrlExternalResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof GetUploadUrlExternalResponseIF) {
                instance = (GetUploadUrlExternalResponseIF)object;
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                this.setUploadUrl(instance.getUploadUrl());
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setFileId(instance.getFileId());
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setUploadUrl(String uploadUrl) {
            this.uploadUrl = Objects.requireNonNull(uploadUrl, "uploadUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setFileId(String fileId) {
            this.fileId = Objects.requireNonNull(fileId, "fileId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public GetUploadUrlExternalResponse build() {
            this.checkRequiredAttributes();
            return new GetUploadUrlExternalResponse(this.ok, this.responseMetadata, this.uploadUrl, this.fileId);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean uploadUrlIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean fileIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.uploadUrlIsSet()) {
                attributes.add("uploadUrl");
            }
            if (!this.fileIdIsSet()) {
                attributes.add("fileId");
            }
            return "Cannot build GetUploadUrlExternalResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GetUploadUrlExternalResponseIF", generator="Immutables")
    static final class Json
    implements GetUploadUrlExternalResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        String uploadUrl;
        @Nullable
        String fileId;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setUploadUrl(String uploadUrl) {
            this.uploadUrl = uploadUrl;
        }

        @JsonProperty
        public void setFileId(String fileId) {
            this.fileId = fileId;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUploadUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFileId() {
            throw new UnsupportedOperationException();
        }
    }
}

