/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.files.SlackFile;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.files.CompleteUploadExternalResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CompleteUploadExternalResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class CompleteUploadExternalResponse
implements CompleteUploadExternalResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final List<SlackFile> files;

    private CompleteUploadExternalResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, List<SlackFile> files) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.files = files;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public List<SlackFile> getFiles() {
        return this.files;
    }

    public final CompleteUploadExternalResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new CompleteUploadExternalResponse(value, this.responseMetadata, this.files);
    }

    public final CompleteUploadExternalResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new CompleteUploadExternalResponse(this.ok, newValue, this.files);
    }

    public final CompleteUploadExternalResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new CompleteUploadExternalResponse(this.ok, value, this.files);
    }

    public final CompleteUploadExternalResponse withFiles(SlackFile ... elements) {
        List<SlackFile> newValue = CompleteUploadExternalResponse.createUnmodifiableList(false, CompleteUploadExternalResponse.createSafeList(Arrays.asList(elements), true, false));
        return new CompleteUploadExternalResponse(this.ok, this.responseMetadata, newValue);
    }

    public final CompleteUploadExternalResponse withFiles(Iterable<? extends SlackFile> elements) {
        if (this.files == elements) {
            return this;
        }
        List<SlackFile> newValue = CompleteUploadExternalResponse.createUnmodifiableList(false, CompleteUploadExternalResponse.createSafeList(elements, true, false));
        return new CompleteUploadExternalResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CompleteUploadExternalResponse && this.equalTo(0, (CompleteUploadExternalResponse)another);
    }

    private boolean equalTo(int synthetic, CompleteUploadExternalResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.files.equals(another.files);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.files.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CompleteUploadExternalResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("files=").append(this.files);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CompleteUploadExternalResponse fromJson(Json json) {
        Builder builder = CompleteUploadExternalResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.files != null) {
            builder.addAllFiles(json.files);
        }
        return builder.build();
    }

    public static CompleteUploadExternalResponse copyOf(CompleteUploadExternalResponseIF instance) {
        if (instance instanceof CompleteUploadExternalResponse) {
            return (CompleteUploadExternalResponse)instance;
        }
        return CompleteUploadExternalResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CompleteUploadExternalResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private List<SlackFile> files = new ArrayList<SlackFile>();

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(CompleteUploadExternalResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof CompleteUploadExternalResponseIF) {
                instance = (CompleteUploadExternalResponseIF)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.addAllFiles(instance.getFiles());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder addFiles(SlackFile element) {
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        public final Builder addFiles(SlackFile ... elements) {
            for (SlackFile element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        public final Builder setFiles(Iterable<? extends SlackFile> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends SlackFile> elements) {
            for (SlackFile slackFile : elements) {
                this.files.add(Objects.requireNonNull(slackFile, "files element"));
            }
            return this;
        }

        public CompleteUploadExternalResponse build() {
            this.checkRequiredAttributes();
            return new CompleteUploadExternalResponse(this.ok, this.responseMetadata, CompleteUploadExternalResponse.createUnmodifiableList(true, this.files));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build CompleteUploadExternalResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CompleteUploadExternalResponseIF", generator="Immutables")
    static final class Json
    implements CompleteUploadExternalResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        List<SlackFile> files = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setFiles(List<SlackFile> files) {
            this.files = files;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFile> getFiles() {
            throw new UnsupportedOperationException();
        }
    }
}

