/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.dnd;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.json.InstantDeserializer;
import com.hubspot.slack.client.models.json.InstantSerializer;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.dnd.DndSnoozeResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DndSnoozeResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class DndSnoozeResponse
implements DndSnoozeResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final boolean snoozeEnabled;
    @Nullable
    private final Instant snoozeEnd;
    @Nullable
    private final Integer snoozeRemaining;

    private DndSnoozeResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, boolean snoozeEnabled, @Nullable Instant snoozeEnd, @Nullable Integer snoozeRemaining) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.snoozeEnabled = snoozeEnabled;
        this.snoozeEnd = snoozeEnd;
        this.snoozeRemaining = snoozeRemaining;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public boolean isSnoozeEnabled() {
        return this.snoozeEnabled;
    }

    @Override
    @JsonProperty(value="snooze_endtime")
    @JsonSerialize(contentUsing=InstantSerializer.class)
    @JsonDeserialize(contentUsing=InstantDeserializer.class)
    public Optional<Instant> getSnoozeEnd() {
        return Optional.ofNullable(this.snoozeEnd);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getSnoozeRemaining() {
        return Optional.ofNullable(this.snoozeRemaining);
    }

    public final DndSnoozeResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new DndSnoozeResponse(value, this.responseMetadata, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndSnoozeResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new DndSnoozeResponse(this.ok, newValue, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndSnoozeResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new DndSnoozeResponse(this.ok, value, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndSnoozeResponse withSnoozeEnabled(boolean value) {
        if (this.snoozeEnabled == value) {
            return this;
        }
        return new DndSnoozeResponse(this.ok, this.responseMetadata, value, this.snoozeEnd, this.snoozeRemaining);
    }

    public final DndSnoozeResponse withSnoozeEnd(@Nullable Instant value) {
        Instant newValue = value;
        if (this.snoozeEnd == newValue) {
            return this;
        }
        return new DndSnoozeResponse(this.ok, this.responseMetadata, this.snoozeEnabled, newValue, this.snoozeRemaining);
    }

    public final DndSnoozeResponse withSnoozeEnd(Optional<? extends Instant> optional) {
        Instant value = optional.orElse(null);
        if (this.snoozeEnd == value) {
            return this;
        }
        return new DndSnoozeResponse(this.ok, this.responseMetadata, this.snoozeEnabled, value, this.snoozeRemaining);
    }

    public final DndSnoozeResponse withSnoozeRemaining(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.snoozeRemaining, newValue)) {
            return this;
        }
        return new DndSnoozeResponse(this.ok, this.responseMetadata, this.snoozeEnabled, this.snoozeEnd, newValue);
    }

    public final DndSnoozeResponse withSnoozeRemaining(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.snoozeRemaining, value)) {
            return this;
        }
        return new DndSnoozeResponse(this.ok, this.responseMetadata, this.snoozeEnabled, this.snoozeEnd, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DndSnoozeResponse && this.equalTo(0, (DndSnoozeResponse)another);
    }

    private boolean equalTo(int synthetic, DndSnoozeResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.snoozeEnabled == another.snoozeEnabled && Objects.equals(this.snoozeEnd, another.snoozeEnd) && Objects.equals(this.snoozeRemaining, another.snoozeRemaining);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + Boolean.hashCode(this.snoozeEnabled);
        h += (h << 5) + Objects.hashCode(this.snoozeEnd);
        h += (h << 5) + Objects.hashCode(this.snoozeRemaining);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DndSnoozeResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("snoozeEnabled=").append(this.snoozeEnabled);
        if (this.snoozeEnd != null) {
            builder.append(", ");
            builder.append("snoozeEnd=").append(this.snoozeEnd);
        }
        if (this.snoozeRemaining != null) {
            builder.append(", ");
            builder.append("snoozeRemaining=").append(this.snoozeRemaining);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static DndSnoozeResponse fromJson(Json json) {
        Builder builder = DndSnoozeResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.snoozeEnabledIsSet) {
            builder.setSnoozeEnabled(json.snoozeEnabled);
        }
        if (json.snoozeEnd != null) {
            builder.setSnoozeEnd(json.snoozeEnd);
        }
        if (json.snoozeRemaining != null) {
            builder.setSnoozeRemaining(json.snoozeRemaining);
        }
        return builder.build();
    }

    public static DndSnoozeResponse copyOf(DndSnoozeResponseIF instance) {
        if (instance instanceof DndSnoozeResponse) {
            return (DndSnoozeResponse)instance;
        }
        return DndSnoozeResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DndSnoozeResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_SNOOZE_ENABLED = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private boolean snoozeEnabled;
        @Nullable
        private Instant snoozeEnd;
        @Nullable
        private Integer snoozeRemaining;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(DndSnoozeResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof DndSnoozeResponseIF) {
                Optional<Integer> snoozeRemainingOptional;
                instance = (DndSnoozeResponseIF)object;
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((snoozeRemainingOptional = instance.getSnoozeRemaining()).isPresent()) {
                    this.setSnoozeRemaining(snoozeRemainingOptional);
                }
                this.setSnoozeEnabled(instance.isSnoozeEnabled());
                Optional<Instant> snoozeEndOptional = instance.getSnoozeEnd();
                if (snoozeEndOptional.isPresent()) {
                    this.setSnoozeEnd(snoozeEndOptional);
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setSnoozeEnabled(boolean snoozeEnabled) {
            this.snoozeEnabled = snoozeEnabled;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSnoozeEnd(@Nullable Instant snoozeEnd) {
            this.snoozeEnd = snoozeEnd;
            return this;
        }

        public final Builder setSnoozeEnd(Optional<? extends Instant> snoozeEnd) {
            this.snoozeEnd = snoozeEnd.orElse(null);
            return this;
        }

        public final Builder setSnoozeRemaining(@Nullable Integer snoozeRemaining) {
            this.snoozeRemaining = snoozeRemaining;
            return this;
        }

        public final Builder setSnoozeRemaining(Optional<Integer> snoozeRemaining) {
            this.snoozeRemaining = snoozeRemaining.orElse(null);
            return this;
        }

        public DndSnoozeResponse build() {
            this.checkRequiredAttributes();
            return new DndSnoozeResponse(this.ok, this.responseMetadata, this.snoozeEnabled, this.snoozeEnd, this.snoozeRemaining);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean snoozeEnabledIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.snoozeEnabledIsSet()) {
                attributes.add("snoozeEnabled");
            }
            return "Cannot build DndSnoozeResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DndSnoozeResponseIF", generator="Immutables")
    static final class Json
    implements DndSnoozeResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        boolean snoozeEnabled;
        boolean snoozeEnabledIsSet;
        @Nullable
        Optional<Instant> snoozeEnd = Optional.empty();
        @Nullable
        Optional<Integer> snoozeRemaining = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setSnoozeEnabled(boolean snoozeEnabled) {
            this.snoozeEnabled = snoozeEnabled;
            this.snoozeEnabledIsSet = true;
        }

        @JsonProperty(value="snooze_endtime")
        @JsonSerialize(contentUsing=InstantSerializer.class)
        @JsonDeserialize(contentUsing=InstantDeserializer.class)
        public void setSnoozeEnd(Optional<Instant> snoozeEnd) {
            this.snoozeEnd = snoozeEnd;
        }

        @JsonProperty
        public void setSnoozeRemaining(Optional<Integer> snoozeRemaining) {
            this.snoozeRemaining = snoozeRemaining;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSnoozeEnabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Instant> getSnoozeEnd() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getSnoozeRemaining() {
            throw new UnsupportedOperationException();
        }
    }
}

