/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ScheduledMessage;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.chat.ChatScheduledMessagesListResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatScheduledMessagesListResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatScheduledMessagesListResponse
implements ChatScheduledMessagesListResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final Set<ScheduledMessage> scheduledMessages;

    private ChatScheduledMessagesListResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, Set<ScheduledMessage> scheduledMessages) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.scheduledMessages = scheduledMessages;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public Set<ScheduledMessage> getScheduledMessages() {
        return this.scheduledMessages;
    }

    public final ChatScheduledMessagesListResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new ChatScheduledMessagesListResponse(value, this.responseMetadata, this.scheduledMessages);
    }

    public final ChatScheduledMessagesListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new ChatScheduledMessagesListResponse(this.ok, newValue, this.scheduledMessages);
    }

    public final ChatScheduledMessagesListResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new ChatScheduledMessagesListResponse(this.ok, value, this.scheduledMessages);
    }

    public final ChatScheduledMessagesListResponse withScheduledMessages(ScheduledMessage ... elements) {
        Set<ScheduledMessage> newValue = ChatScheduledMessagesListResponse.createUnmodifiableSet(ChatScheduledMessagesListResponse.createSafeList(Arrays.asList(elements), true, false));
        return new ChatScheduledMessagesListResponse(this.ok, this.responseMetadata, newValue);
    }

    public final ChatScheduledMessagesListResponse withScheduledMessages(Iterable<? extends ScheduledMessage> elements) {
        if (this.scheduledMessages == elements) {
            return this;
        }
        Set<ScheduledMessage> newValue = ChatScheduledMessagesListResponse.createUnmodifiableSet(ChatScheduledMessagesListResponse.createSafeList(elements, true, false));
        return new ChatScheduledMessagesListResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatScheduledMessagesListResponse && this.equalTo(0, (ChatScheduledMessagesListResponse)another);
    }

    private boolean equalTo(int synthetic, ChatScheduledMessagesListResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.scheduledMessages.equals(another.scheduledMessages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.scheduledMessages.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatScheduledMessagesListResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("scheduledMessages=").append(this.scheduledMessages);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatScheduledMessagesListResponse fromJson(Json json) {
        Builder builder = ChatScheduledMessagesListResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.scheduledMessages != null) {
            builder.addAllScheduledMessages(json.scheduledMessages);
        }
        return builder.build();
    }

    public static ChatScheduledMessagesListResponse copyOf(ChatScheduledMessagesListResponseIF instance) {
        if (instance instanceof ChatScheduledMessagesListResponse) {
            return (ChatScheduledMessagesListResponse)instance;
        }
        return ChatScheduledMessagesListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="ChatScheduledMessagesListResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private long initBits = 1L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        private List<ScheduledMessage> scheduledMessages = new ArrayList<ScheduledMessage>();

        private Builder() {
        }

        public final Builder from(ChatScheduledMessagesListResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof ChatScheduledMessagesListResponseIF) {
                instance = (ChatScheduledMessagesListResponseIF)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.addAllScheduledMessages(instance.getScheduledMessages());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder addScheduledMessages(ScheduledMessage element) {
            this.scheduledMessages.add(Objects.requireNonNull(element, "scheduledMessages element"));
            return this;
        }

        public final Builder addScheduledMessages(ScheduledMessage ... elements) {
            for (ScheduledMessage element : elements) {
                this.scheduledMessages.add(Objects.requireNonNull(element, "scheduledMessages element"));
            }
            return this;
        }

        public final Builder setScheduledMessages(Iterable<? extends ScheduledMessage> elements) {
            this.scheduledMessages.clear();
            return this.addAllScheduledMessages(elements);
        }

        public final Builder addAllScheduledMessages(Iterable<? extends ScheduledMessage> elements) {
            for (ScheduledMessage scheduledMessage : elements) {
                this.scheduledMessages.add(Objects.requireNonNull(scheduledMessage, "scheduledMessages element"));
            }
            return this;
        }

        public ChatScheduledMessagesListResponse build() {
            this.checkRequiredAttributes();
            return new ChatScheduledMessagesListResponse(this.ok, this.responseMetadata, ChatScheduledMessagesListResponse.createUnmodifiableSet(this.scheduledMessages));
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            return "Cannot build ChatScheduledMessagesListResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatScheduledMessagesListResponseIF", generator="Immutables")
    static final class Json
    implements ChatScheduledMessagesListResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        Set<ScheduledMessage> scheduledMessages = Collections.emptySet();

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setScheduledMessages(Set<ScheduledMessage> scheduledMessages) {
            this.scheduledMessages = scheduledMessages;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ScheduledMessage> getScheduledMessages() {
            throw new UnsupportedOperationException();
        }
    }
}

