/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response.bookmarks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.bookmarks.Bookmark;
import com.hubspot.slack.client.models.response.ResponseMetadata;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.response.bookmarks.BookmarkEditResponseIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BookmarkEditResponseIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class BookmarkEditResponse
implements BookmarkEditResponseIF {
    private final boolean ok;
    @Nullable
    private final ResponseMetadata responseMetadata;
    private final Bookmark bookmark;

    private BookmarkEditResponse(boolean ok, @Nullable ResponseMetadata responseMetadata, Bookmark bookmark) {
        this.ok = ok;
        this.responseMetadata = responseMetadata;
        this.bookmark = bookmark;
    }

    @Override
    @JsonProperty
    public boolean isOk() {
        return this.ok;
    }

    @Override
    @JsonProperty(value="response_metadata")
    public Optional<ResponseMetadata> getResponseMetadata() {
        return Optional.ofNullable(this.responseMetadata);
    }

    @Override
    @JsonProperty
    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public final BookmarkEditResponse withOk(boolean value) {
        if (this.ok == value) {
            return this;
        }
        return new BookmarkEditResponse(value, this.responseMetadata, this.bookmark);
    }

    public final BookmarkEditResponse withResponseMetadata(@Nullable ResponseMetadata value) {
        ResponseMetadata newValue = value;
        if (this.responseMetadata == newValue) {
            return this;
        }
        return new BookmarkEditResponse(this.ok, newValue, this.bookmark);
    }

    public final BookmarkEditResponse withResponseMetadata(Optional<? extends ResponseMetadata> optional) {
        ResponseMetadata value = optional.orElse(null);
        if (this.responseMetadata == value) {
            return this;
        }
        return new BookmarkEditResponse(this.ok, value, this.bookmark);
    }

    public final BookmarkEditResponse withBookmark(Bookmark value) {
        if (this.bookmark == value) {
            return this;
        }
        Bookmark newValue = Objects.requireNonNull(value, "bookmark");
        return new BookmarkEditResponse(this.ok, this.responseMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BookmarkEditResponse && this.equalTo(0, (BookmarkEditResponse)another);
    }

    private boolean equalTo(int synthetic, BookmarkEditResponse another) {
        return this.ok == another.ok && Objects.equals(this.responseMetadata, another.responseMetadata) && this.bookmark.equals(another.bookmark);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.ok);
        h += (h << 5) + Objects.hashCode(this.responseMetadata);
        h += (h << 5) + this.bookmark.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("BookmarkEditResponse{");
        builder.append("ok=").append(this.ok);
        if (this.responseMetadata != null) {
            builder.append(", ");
            builder.append("responseMetadata=").append(this.responseMetadata);
        }
        builder.append(", ");
        builder.append("bookmark=").append(this.bookmark);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static BookmarkEditResponse fromJson(Json json) {
        Builder builder = BookmarkEditResponse.builder();
        if (json.okIsSet) {
            builder.setOk(json.ok);
        }
        if (json.responseMetadata != null) {
            builder.setResponseMetadata(json.responseMetadata);
        }
        if (json.bookmark != null) {
            builder.setBookmark(json.bookmark);
        }
        return builder.build();
    }

    public static BookmarkEditResponse copyOf(BookmarkEditResponseIF instance) {
        if (instance instanceof BookmarkEditResponse) {
            return (BookmarkEditResponse)instance;
        }
        return BookmarkEditResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BookmarkEditResponseIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_OK = 1L;
        private static final long INIT_BIT_BOOKMARK = 2L;
        private long initBits = 3L;
        private boolean ok;
        @Nullable
        private ResponseMetadata responseMetadata;
        @Nullable
        private Bookmark bookmark;

        private Builder() {
        }

        public final Builder from(SlackResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(BookmarkEditResponseIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<ResponseMetadata> responseMetadataOptional;
            SlackResponse instance;
            long bits = 0L;
            if (object instanceof SlackResponse) {
                instance = (SlackResponse)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof BookmarkEditResponseIF) {
                instance = (BookmarkEditResponseIF)object;
                if ((bits & 2L) == 0L) {
                    this.setOk(instance.isOk());
                    bits |= 2L;
                }
                this.setBookmark(instance.getBookmark());
                if ((bits & 1L) == 0L) {
                    responseMetadataOptional = instance.getResponseMetadata();
                    if (responseMetadataOptional.isPresent()) {
                        this.setResponseMetadata(responseMetadataOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setOk(boolean ok) {
            this.ok = ok;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
            this.responseMetadata = responseMetadata;
            return this;
        }

        public final Builder setResponseMetadata(Optional<? extends ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata.orElse(null);
            return this;
        }

        public final Builder setBookmark(Bookmark bookmark) {
            this.bookmark = Objects.requireNonNull(bookmark, "bookmark");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public BookmarkEditResponse build() {
            this.checkRequiredAttributes();
            return new BookmarkEditResponse(this.ok, this.responseMetadata, this.bookmark);
        }

        private boolean okIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean bookmarkIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.okIsSet()) {
                attributes.add("ok");
            }
            if (!this.bookmarkIsSet()) {
                attributes.add("bookmark");
            }
            return "Cannot build BookmarkEditResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookmarkEditResponseIF", generator="Immutables")
    static final class Json
    implements BookmarkEditResponseIF {
        boolean ok;
        boolean okIsSet;
        @Nullable
        Optional<ResponseMetadata> responseMetadata = Optional.empty();
        @Nullable
        Bookmark bookmark;

        Json() {
        }

        @JsonProperty
        public void setOk(boolean ok) {
            this.ok = ok;
            this.okIsSet = true;
        }

        @JsonProperty(value="response_metadata")
        public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
            this.responseMetadata = responseMetadata;
        }

        @JsonProperty
        public void setBookmark(Bookmark bookmark) {
            this.bookmark = bookmark;
        }

        @Override
        public boolean isOk() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ResponseMetadata> getResponseMetadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Bookmark getBookmark() {
            throw new UnsupportedOperationException();
        }
    }
}

