/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction.views;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.views.UsersSelectInputIF;
import com.hubspot.slack.client.models.interaction.views.ViewInput;
import com.hubspot.slack.client.models.interaction.views.ViewInputType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsersSelectInputIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsersSelectInput
implements UsersSelectInputIF {
    private final ViewInputType type;
    @Nullable
    private final String selectedUser;

    private UsersSelectInput(ViewInputType type, @Nullable String selectedUser) {
        this.type = type;
        this.selectedUser = selectedUser;
    }

    @Override
    @JsonProperty
    public ViewInputType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getSelectedUser() {
        return Optional.ofNullable(this.selectedUser);
    }

    public final UsersSelectInput withType(ViewInputType value) {
        ViewInputType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new UsersSelectInput(newValue, this.selectedUser);
    }

    public final UsersSelectInput withSelectedUser(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.selectedUser, newValue)) {
            return this;
        }
        return new UsersSelectInput(this.type, newValue);
    }

    public final UsersSelectInput withSelectedUser(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.selectedUser, value)) {
            return this;
        }
        return new UsersSelectInput(this.type, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsersSelectInput && this.equalTo(0, (UsersSelectInput)another);
    }

    private boolean equalTo(int synthetic, UsersSelectInput another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.selectedUser, another.selectedUser);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.selectedUser);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsersSelectInput{");
        builder.append("type=").append((Object)this.type);
        if (this.selectedUser != null) {
            builder.append(", ");
            builder.append("selectedUser=").append(this.selectedUser);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsersSelectInput fromJson(Json json) {
        Builder builder = UsersSelectInput.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.selectedUser != null) {
            builder.setSelectedUser(json.selectedUser);
        }
        return builder.build();
    }

    public static UsersSelectInput copyOf(UsersSelectInputIF instance) {
        if (instance instanceof UsersSelectInput) {
            return (UsersSelectInput)instance;
        }
        return UsersSelectInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UsersSelectInputIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private ViewInputType type;
        @Nullable
        private String selectedUser;

        private Builder() {
        }

        public final Builder from(ViewInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(UsersSelectInputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            ViewInput instance;
            long bits = 0L;
            if (object instanceof ViewInput) {
                instance = (ViewInput)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof UsersSelectInputIF) {
                Optional<String> selectedUserOptional;
                instance = (UsersSelectInputIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((selectedUserOptional = instance.getSelectedUser()).isPresent()) {
                    this.setSelectedUser(selectedUserOptional);
                }
            }
        }

        public final Builder setType(ViewInputType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSelectedUser(@Nullable String selectedUser) {
            this.selectedUser = selectedUser;
            return this;
        }

        public final Builder setSelectedUser(Optional<String> selectedUser) {
            this.selectedUser = selectedUser.orElse(null);
            return this;
        }

        public UsersSelectInput build() {
            this.checkRequiredAttributes();
            return new UsersSelectInput(this.type, this.selectedUser);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build UsersSelectInput, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsersSelectInputIF", generator="Immutables")
    static final class Json
    implements UsersSelectInputIF {
        @Nullable
        ViewInputType type;
        @Nullable
        Optional<String> selectedUser = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(ViewInputType type) {
            this.type = type;
        }

        @JsonProperty
        public void setSelectedUser(Optional<String> selectedUser) {
            this.selectedUser = selectedUser;
        }

        @Override
        public ViewInputType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSelectedUser() {
            throw new UnsupportedOperationException();
        }
    }
}

