/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.ViewStateValuesBlockIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewStateValuesBlockIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewStateValuesBlock
implements ViewStateValuesBlockIF {
    private final String type;
    private final String value;

    private ViewStateValuesBlock(String type, String value) {
        this.type = type;
        this.value = value;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public final ViewStateValuesBlock withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ViewStateValuesBlock(newValue, this.value);
    }

    public final ViewStateValuesBlock withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ViewStateValuesBlock(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewStateValuesBlock && this.equalTo(0, (ViewStateValuesBlock)another);
    }

    private boolean equalTo(int synthetic, ViewStateValuesBlock another) {
        return this.type.equals(another.type) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "ViewStateValuesBlock{type=" + this.type + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewStateValuesBlock fromJson(Json json) {
        Builder builder = ViewStateValuesBlock.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        return builder.build();
    }

    public static ViewStateValuesBlock copyOf(ViewStateValuesBlockIF instance) {
        if (instance instanceof ViewStateValuesBlock) {
            return (ViewStateValuesBlock)instance;
        }
        return ViewStateValuesBlock.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewStateValuesBlockIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String type;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(ViewStateValuesBlockIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setType(instance.getType());
            this.setValue(instance.getValue());
            return this;
        }

        public final Builder setType(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ViewStateValuesBlock build() {
            this.checkRequiredAttributes();
            return new ViewStateValuesBlock(this.type, this.value);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean valueIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build ViewStateValuesBlock, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewStateValuesBlockIF", generator="Immutables")
    static final class Json
    implements ViewStateValuesBlockIF {
        @Nullable
        String type;
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

