/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.Container;
import com.hubspot.slack.client.models.interaction.ContainerType;
import com.hubspot.slack.client.models.interaction.ViewContainerIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ViewContainerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ViewContainer
implements ViewContainerIF {
    private final ContainerType type;
    private final String viewId;

    private ViewContainer(ContainerType type, String viewId) {
        this.type = type;
        this.viewId = viewId;
    }

    @Override
    @JsonProperty
    public ContainerType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getViewId() {
        return this.viewId;
    }

    public final ViewContainer withType(ContainerType value) {
        ContainerType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ViewContainer(newValue, this.viewId);
    }

    public final ViewContainer withViewId(String value) {
        String newValue = Objects.requireNonNull(value, "viewId");
        if (this.viewId.equals(newValue)) {
            return this;
        }
        return new ViewContainer(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ViewContainer && this.equalTo(0, (ViewContainer)another);
    }

    private boolean equalTo(int synthetic, ViewContainer another) {
        return this.type.equals((Object)another.type) && this.viewId.equals(another.viewId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.viewId.hashCode();
        return h;
    }

    public String toString() {
        return "ViewContainer{type=" + this.type + ", viewId=" + this.viewId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ViewContainer fromJson(Json json) {
        Builder builder = ViewContainer.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.viewId != null) {
            builder.setViewId(json.viewId);
        }
        return builder.build();
    }

    public static ViewContainer copyOf(ViewContainerIF instance) {
        if (instance instanceof ViewContainer) {
            return (ViewContainer)instance;
        }
        return ViewContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ViewContainerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_VIEW_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private ContainerType type;
        @Nullable
        private String viewId;

        private Builder() {
        }

        public final Builder from(ViewContainerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(Container instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Container instance;
            long bits = 0L;
            if (object instanceof ViewContainerIF) {
                instance = (ViewContainerIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                this.setViewId(instance.getViewId());
            }
            if (object instanceof Container) {
                instance = (Container)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
        }

        public final Builder setType(ContainerType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setViewId(String viewId) {
            this.viewId = Objects.requireNonNull(viewId, "viewId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ViewContainer build() {
            this.checkRequiredAttributes();
            return new ViewContainer(this.type, this.viewId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean viewIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.viewIdIsSet()) {
                attributes.add("viewId");
            }
            return "Cannot build ViewContainer, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ViewContainerIF", generator="Immutables")
    static final class Json
    implements ViewContainerIF {
        @Nullable
        ContainerType type;
        @Nullable
        String viewId;

        Json() {
        }

        @JsonProperty
        public void setType(ContainerType type) {
            this.type = type;
        }

        @JsonProperty
        public void setViewId(String viewId) {
            this.viewId = viewId;
        }

        @Override
        public ContainerType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getViewId() {
            throw new UnsupportedOperationException();
        }
    }
}

