/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.interaction.InteractiveCallbackType;
import com.hubspot.slack.client.models.interaction.ShortcutIF;
import com.hubspot.slack.client.models.interaction.SlackInteractiveCallback;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ShortcutIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Shortcut
implements ShortcutIF {
    private final InteractiveCallbackType type;
    private final String callbackId;
    private final String actionTs;
    private final String token;
    private final SlackTeam team;
    private final SlackUserLite user;
    private final String triggerId;

    private Shortcut(InteractiveCallbackType type, String callbackId, String actionTs, String token, SlackTeam team, SlackUserLite user, String triggerId) {
        this.type = type;
        this.callbackId = callbackId;
        this.actionTs = actionTs;
        this.token = token;
        this.team = team;
        this.user = user;
        this.triggerId = triggerId;
    }

    @Override
    @JsonProperty
    public InteractiveCallbackType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getCallbackId() {
        return this.callbackId;
    }

    @Override
    @JsonProperty
    public String getActionTs() {
        return this.actionTs;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public SlackTeam getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public SlackUserLite getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public String getTriggerId() {
        return this.triggerId;
    }

    public final Shortcut withType(InteractiveCallbackType value) {
        InteractiveCallbackType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new Shortcut(newValue, this.callbackId, this.actionTs, this.token, this.team, this.user, this.triggerId);
    }

    public final Shortcut withCallbackId(String value) {
        String newValue = Objects.requireNonNull(value, "callbackId");
        if (this.callbackId.equals(newValue)) {
            return this;
        }
        return new Shortcut(this.type, newValue, this.actionTs, this.token, this.team, this.user, this.triggerId);
    }

    public final Shortcut withActionTs(String value) {
        String newValue = Objects.requireNonNull(value, "actionTs");
        if (this.actionTs.equals(newValue)) {
            return this;
        }
        return new Shortcut(this.type, this.callbackId, newValue, this.token, this.team, this.user, this.triggerId);
    }

    public final Shortcut withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new Shortcut(this.type, this.callbackId, this.actionTs, newValue, this.team, this.user, this.triggerId);
    }

    public final Shortcut withTeam(SlackTeam value) {
        if (this.team == value) {
            return this;
        }
        SlackTeam newValue = Objects.requireNonNull(value, "team");
        return new Shortcut(this.type, this.callbackId, this.actionTs, this.token, newValue, this.user, this.triggerId);
    }

    public final Shortcut withUser(SlackUserLite value) {
        if (this.user == value) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(value, "user");
        return new Shortcut(this.type, this.callbackId, this.actionTs, this.token, this.team, newValue, this.triggerId);
    }

    public final Shortcut withTriggerId(String value) {
        String newValue = Objects.requireNonNull(value, "triggerId");
        if (this.triggerId.equals(newValue)) {
            return this;
        }
        return new Shortcut(this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Shortcut && this.equalTo(0, (Shortcut)another);
    }

    private boolean equalTo(int synthetic, Shortcut another) {
        return this.type.equals((Object)another.type) && this.callbackId.equals(another.callbackId) && this.actionTs.equals(another.actionTs) && this.token.equals(another.token) && this.team.equals(another.team) && this.user.equals(another.user) && this.triggerId.equals(another.triggerId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.callbackId.hashCode();
        h += (h << 5) + this.actionTs.hashCode();
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + this.triggerId.hashCode();
        return h;
    }

    public String toString() {
        return "Shortcut{type=" + this.type + ", callbackId=" + this.callbackId + ", actionTs=" + this.actionTs + ", token=" + this.token + ", team=" + this.team + ", user=" + this.user + ", triggerId=" + this.triggerId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Shortcut fromJson(Json json) {
        Builder builder = Shortcut.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.actionTs != null) {
            builder.setActionTs(json.actionTs);
        }
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.triggerId != null) {
            builder.setTriggerId(json.triggerId);
        }
        return builder.build();
    }

    public static Shortcut copyOf(ShortcutIF instance) {
        if (instance instanceof Shortcut) {
            return (Shortcut)instance;
        }
        return Shortcut.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ShortcutIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CALLBACK_ID = 2L;
        private static final long INIT_BIT_ACTION_TS = 4L;
        private static final long INIT_BIT_TOKEN = 8L;
        private static final long INIT_BIT_TEAM = 16L;
        private static final long INIT_BIT_USER = 32L;
        private static final long INIT_BIT_TRIGGER_ID = 64L;
        private long initBits = 127L;
        @Nullable
        private InteractiveCallbackType type;
        @Nullable
        private String callbackId;
        @Nullable
        private String actionTs;
        @Nullable
        private String token;
        @Nullable
        private SlackTeam team;
        @Nullable
        private SlackUserLite user;
        @Nullable
        private String triggerId;

        private Builder() {
        }

        public final Builder from(ShortcutIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackInteractiveCallback instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackInteractiveCallback instance;
            long bits = 0L;
            if (object instanceof ShortcutIF) {
                instance = (ShortcutIF)object;
                if ((bits & 8L) == 0L) {
                    this.setCallbackId(instance.getCallbackId());
                    bits |= 8L;
                }
                this.setTriggerId(instance.getTriggerId());
                if ((bits & 1L) == 0L) {
                    this.setTeam(instance.getTeam());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setActionTs(instance.getActionTs());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setUser(instance.getUser());
                    bits |= 0x20L;
                }
                if ((bits & 4L) == 0L) {
                    this.setToken(instance.getToken());
                    bits |= 4L;
                }
            }
            if (object instanceof SlackInteractiveCallback) {
                instance = (SlackInteractiveCallback)object;
                if ((bits & 1L) == 0L) {
                    this.setTeam(instance.getTeam());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.setCallbackId(instance.getCallbackId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setActionTs(instance.getActionTs());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setUser(instance.getUser());
                    bits |= 0x20L;
                }
                if ((bits & 4L) == 0L) {
                    this.setToken(instance.getToken());
                    bits |= 4L;
                }
            }
        }

        public final Builder setType(InteractiveCallbackType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCallbackId(String callbackId) {
            this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setActionTs(String actionTs) {
            this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setTeam(SlackTeam team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setUser(SlackUserLite user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setTriggerId(String triggerId) {
            this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public Shortcut build() {
            this.checkRequiredAttributes();
            return new Shortcut(this.type, this.callbackId, this.actionTs, this.token, this.team, this.user, this.triggerId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean callbackIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean actionTsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean tokenIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean triggerIdIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.callbackIdIsSet()) {
                attributes.add("callbackId");
            }
            if (!this.actionTsIsSet()) {
                attributes.add("actionTs");
            }
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.triggerIdIsSet()) {
                attributes.add("triggerId");
            }
            return "Cannot build Shortcut, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ShortcutIF", generator="Immutables")
    static final class Json
    implements ShortcutIF {
        @Nullable
        InteractiveCallbackType type;
        @Nullable
        String callbackId;
        @Nullable
        String actionTs;
        @Nullable
        String token;
        @Nullable
        SlackTeam team;
        @Nullable
        SlackUserLite user;
        @Nullable
        String triggerId;

        Json() {
        }

        @JsonProperty
        public void setType(InteractiveCallbackType type) {
            this.type = type;
        }

        @JsonProperty
        public void setCallbackId(String callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setActionTs(String actionTs) {
            this.actionTs = actionTs;
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setTeam(SlackTeam team) {
            this.team = team;
        }

        @JsonProperty
        public void setUser(SlackUserLite user) {
            this.user = user;
        }

        @JsonProperty
        public void setTriggerId(String triggerId) {
            this.triggerId = triggerId;
        }

        @Override
        public InteractiveCallbackType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeam getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTriggerId() {
            throw new UnsupportedOperationException();
        }
    }
}

