/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.files.SlackFile;
import com.hubspot.slack.client.models.files.SlackFileType;
import com.hubspot.slack.client.models.files.SlackGifFileIF;
import com.hubspot.slack.client.models.files.SlackImageFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackGifFileIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackGifFile
implements SlackGifFileIF {
    private final String id;
    private final long createdEpochSeconds;
    private final long timestampEpochSeconds;
    private final String name;
    private final String title;
    private final String mimetype;
    private final String prettyType;
    private final String userId;
    private final boolean editable;
    private final long size;
    private final String mode;
    private final boolean external;
    private final boolean isPublic;
    private final boolean publicUrlShared;
    private final boolean displayAsBot;
    private final String username;
    private final String urlPrivate;
    @Nullable
    private final String urlPrivateDownload;
    private final String permalink;
    @Nullable
    private final String permalinkPublic;
    private final int commentsCount;
    @Nullable
    private final Boolean starred;
    private final List<String> channelIds;
    private final List<String> groupIds;
    private final List<String> imIds;
    @Nullable
    private final String thumb64Url;
    @Nullable
    private final String thumb80Url;
    @Nullable
    private final String thumb160Url;
    @Nullable
    private final String thumb360Url;
    @Nullable
    private final Integer thumb360Width;
    @Nullable
    private final Integer thumb360Height;
    @Nullable
    private final String thumb480Url;
    @Nullable
    private final Integer thumb480Width;
    @Nullable
    private final Integer thumb480Height;
    @Nullable
    private final Integer imageExifRotation;
    @Nullable
    private final Integer originalWidth;
    @Nullable
    private final Integer originalHeight;
    private final boolean hasRichPreview;
    private final SlackFileType filetype;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackGifFile(Builder builder) {
        this.id = builder.id;
        this.createdEpochSeconds = builder.createdEpochSeconds;
        this.timestampEpochSeconds = builder.timestampEpochSeconds;
        this.name = builder.name;
        this.title = builder.title;
        this.mimetype = builder.mimetype;
        this.prettyType = builder.prettyType;
        this.userId = builder.userId;
        this.editable = builder.editable;
        this.size = builder.size;
        this.mode = builder.mode;
        this.external = builder.external;
        this.isPublic = builder.isPublic;
        this.publicUrlShared = builder.publicUrlShared;
        this.displayAsBot = builder.displayAsBot;
        this.username = builder.username;
        this.urlPrivate = builder.urlPrivate;
        this.urlPrivateDownload = builder.urlPrivateDownload;
        this.permalink = builder.permalink;
        this.permalinkPublic = builder.permalinkPublic;
        this.starred = builder.starred;
        this.channelIds = SlackGifFile.createUnmodifiableList(true, builder.channelIds);
        this.groupIds = SlackGifFile.createUnmodifiableList(true, builder.groupIds);
        this.imIds = SlackGifFile.createUnmodifiableList(true, builder.imIds);
        this.thumb64Url = builder.thumb64Url;
        this.thumb80Url = builder.thumb80Url;
        this.thumb160Url = builder.thumb160Url;
        this.thumb360Url = builder.thumb360Url;
        this.thumb360Width = builder.thumb360Width;
        this.thumb360Height = builder.thumb360Height;
        this.thumb480Url = builder.thumb480Url;
        this.thumb480Width = builder.thumb480Width;
        this.thumb480Height = builder.thumb480Height;
        this.imageExifRotation = builder.imageExifRotation;
        this.originalWidth = builder.originalWidth;
        this.originalHeight = builder.originalHeight;
        this.hasRichPreview = builder.hasRichPreview;
        if (builder.commentsCountIsSet()) {
            this.initShim.setCommentsCount(builder.commentsCount);
        }
        if (builder.filetype != null) {
            this.initShim.setFiletype(builder.filetype);
        }
        this.commentsCount = this.initShim.getCommentsCount();
        this.filetype = this.initShim.getFiletype();
        this.initShim = null;
    }

    private SlackGifFile(String id, long createdEpochSeconds, long timestampEpochSeconds, String name, String title, String mimetype, String prettyType, String userId, boolean editable, long size, String mode, boolean external, boolean isPublic, boolean publicUrlShared, boolean displayAsBot, String username, String urlPrivate, @Nullable String urlPrivateDownload, String permalink, @Nullable String permalinkPublic, int commentsCount, @Nullable Boolean starred, List<String> channelIds, List<String> groupIds, List<String> imIds, @Nullable String thumb64Url, @Nullable String thumb80Url, @Nullable String thumb160Url, @Nullable String thumb360Url, @Nullable Integer thumb360Width, @Nullable Integer thumb360Height, @Nullable String thumb480Url, @Nullable Integer thumb480Width, @Nullable Integer thumb480Height, @Nullable Integer imageExifRotation, @Nullable Integer originalWidth, @Nullable Integer originalHeight, boolean hasRichPreview, SlackFileType filetype) {
        this.id = id;
        this.createdEpochSeconds = createdEpochSeconds;
        this.timestampEpochSeconds = timestampEpochSeconds;
        this.name = name;
        this.title = title;
        this.mimetype = mimetype;
        this.prettyType = prettyType;
        this.userId = userId;
        this.editable = editable;
        this.size = size;
        this.mode = mode;
        this.external = external;
        this.isPublic = isPublic;
        this.publicUrlShared = publicUrlShared;
        this.displayAsBot = displayAsBot;
        this.username = username;
        this.urlPrivate = urlPrivate;
        this.urlPrivateDownload = urlPrivateDownload;
        this.permalink = permalink;
        this.permalinkPublic = permalinkPublic;
        this.commentsCount = commentsCount;
        this.starred = starred;
        this.channelIds = channelIds;
        this.groupIds = groupIds;
        this.imIds = imIds;
        this.thumb64Url = thumb64Url;
        this.thumb80Url = thumb80Url;
        this.thumb160Url = thumb160Url;
        this.thumb360Url = thumb360Url;
        this.thumb360Width = thumb360Width;
        this.thumb360Height = thumb360Height;
        this.thumb480Url = thumb480Url;
        this.thumb480Width = thumb480Width;
        this.thumb480Height = thumb480Height;
        this.imageExifRotation = imageExifRotation;
        this.originalWidth = originalWidth;
        this.originalHeight = originalHeight;
        this.hasRichPreview = hasRichPreview;
        this.filetype = filetype;
        this.initShim = null;
    }

    private int getCommentsCountInitialize() {
        return SlackGifFileIF.super.getCommentsCount();
    }

    private SlackFileType getFiletypeInitialize() {
        return SlackGifFileIF.super.getFiletype();
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="created")
    public long getCreatedEpochSeconds() {
        return this.createdEpochSeconds;
    }

    @Override
    @JsonProperty(value="timestamp")
    public long getTimestampEpochSeconds() {
        return this.timestampEpochSeconds;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public String getMimetype() {
        return this.mimetype;
    }

    @Override
    @JsonProperty
    public String getPrettyType() {
        return this.prettyType;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @Override
    @JsonProperty
    public String getMode() {
        return this.mode;
    }

    @Override
    @JsonProperty(value="is_external")
    public boolean isExternal() {
        return this.external;
    }

    @Override
    @JsonProperty(value="is_public")
    public boolean isPublic() {
        return this.isPublic;
    }

    @Override
    @JsonProperty
    public boolean isPublicUrlShared() {
        return this.publicUrlShared;
    }

    @Override
    @JsonProperty
    public boolean getDisplayAsBot() {
        return this.displayAsBot;
    }

    @Override
    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @Override
    @JsonProperty
    public String getUrlPrivate() {
        return this.urlPrivate;
    }

    @Override
    @JsonProperty
    public Optional<String> getUrlPrivateDownload() {
        return Optional.ofNullable(this.urlPrivateDownload);
    }

    @Override
    @JsonProperty
    public String getPermalink() {
        return this.permalink;
    }

    @Override
    @JsonProperty
    public Optional<String> getPermalinkPublic() {
        return Optional.ofNullable(this.permalinkPublic);
    }

    @Override
    @JsonProperty
    public int getCommentsCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCommentsCount() : this.commentsCount;
    }

    @Override
    @JsonProperty(value="is_starred")
    public Optional<Boolean> isStarred() {
        return Optional.ofNullable(this.starred);
    }

    @Override
    @JsonProperty(value="channels")
    public List<String> getChannelIds() {
        return this.channelIds;
    }

    @Override
    @JsonProperty(value="groups")
    public List<String> getGroupIds() {
        return this.groupIds;
    }

    @Override
    @JsonProperty(value="ims")
    public List<String> getImIds() {
        return this.imIds;
    }

    @Override
    @JsonProperty(value="thumb_64")
    public Optional<String> getThumb64Url() {
        return Optional.ofNullable(this.thumb64Url);
    }

    @Override
    @JsonProperty(value="thumb_80")
    public Optional<String> getThumb80Url() {
        return Optional.ofNullable(this.thumb80Url);
    }

    @Override
    @JsonProperty(value="thumb_160")
    public Optional<String> getThumb160Url() {
        return Optional.ofNullable(this.thumb160Url);
    }

    @Override
    @JsonProperty(value="thumb_360")
    public Optional<String> getThumb360Url() {
        return Optional.ofNullable(this.thumb360Url);
    }

    @Override
    @JsonProperty(value="thumb_360_w")
    public Optional<Integer> getThumb360Width() {
        return Optional.ofNullable(this.thumb360Width);
    }

    @Override
    @JsonProperty(value="thumb_360_h")
    public Optional<Integer> getThumb360Height() {
        return Optional.ofNullable(this.thumb360Height);
    }

    @Override
    @JsonProperty(value="thumb_480")
    public Optional<String> getThumb480Url() {
        return Optional.ofNullable(this.thumb480Url);
    }

    @Override
    @JsonProperty(value="thumb_480_w")
    public Optional<Integer> getThumb480Width() {
        return Optional.ofNullable(this.thumb480Width);
    }

    @Override
    @JsonProperty(value="thumb_480_h")
    public Optional<Integer> getThumb480Height() {
        return Optional.ofNullable(this.thumb480Height);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getImageExifRotation() {
        return Optional.ofNullable(this.imageExifRotation);
    }

    @Override
    @JsonProperty(value="original_w")
    public Optional<Integer> getOriginalWidth() {
        return Optional.ofNullable(this.originalWidth);
    }

    @Override
    @JsonProperty(value="original_h")
    public Optional<Integer> getOriginalHeight() {
        return Optional.ofNullable(this.originalHeight);
    }

    @Override
    @JsonProperty(value="has_rich_preview")
    public boolean hasRichPreview() {
        return this.hasRichPreview;
    }

    @Override
    @JsonProperty
    public SlackFileType getFiletype() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getFiletype() : this.filetype;
    }

    public final SlackGifFile withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(newValue, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withCreatedEpochSeconds(long value) {
        if (this.createdEpochSeconds == value) {
            return this;
        }
        return new SlackGifFile(this.id, value, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withTimestampEpochSeconds(long value) {
        if (this.timestampEpochSeconds == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, value, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, newValue, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, newValue, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withMimetype(String value) {
        String newValue = Objects.requireNonNull(value, "mimetype");
        if (this.mimetype.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, newValue, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withPrettyType(String value) {
        String newValue = Objects.requireNonNull(value, "prettyType");
        if (this.prettyType.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, newValue, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, newValue, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withEditable(boolean value) {
        if (this.editable == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, value, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withSize(long value) {
        if (this.size == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, value, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withMode(String value) {
        String newValue = Objects.requireNonNull(value, "mode");
        if (this.mode.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, newValue, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withExternal(boolean value) {
        if (this.external == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, value, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withPublic(boolean value) {
        if (this.isPublic == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, value, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withPublicUrlShared(boolean value) {
        if (this.publicUrlShared == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, value, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withDisplayAsBot(boolean value) {
        if (this.displayAsBot == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, value, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, newValue, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withUrlPrivate(String value) {
        String newValue = Objects.requireNonNull(value, "urlPrivate");
        if (this.urlPrivate.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, newValue, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withUrlPrivateDownload(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.urlPrivateDownload, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, newValue, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withUrlPrivateDownload(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.urlPrivateDownload, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, value, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withPermalink(String value) {
        String newValue = Objects.requireNonNull(value, "permalink");
        if (this.permalink.equals(newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, newValue, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withPermalinkPublic(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.permalinkPublic, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, newValue, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withPermalinkPublic(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.permalinkPublic, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, value, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withCommentsCount(int value) {
        if (this.commentsCount == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, value, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withStarred(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.starred, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, newValue, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withStarred(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.starred, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, value, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withChannelIds(String ... elements) {
        List<String> newValue = SlackGifFile.createUnmodifiableList(false, SlackGifFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withChannelIds(Iterable<String> elements) {
        if (this.channelIds == elements) {
            return this;
        }
        List<String> newValue = SlackGifFile.createUnmodifiableList(false, SlackGifFile.createSafeList(elements, true, false));
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, newValue, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withGroupIds(String ... elements) {
        List<String> newValue = SlackGifFile.createUnmodifiableList(false, SlackGifFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withGroupIds(Iterable<String> elements) {
        if (this.groupIds == elements) {
            return this;
        }
        List<String> newValue = SlackGifFile.createUnmodifiableList(false, SlackGifFile.createSafeList(elements, true, false));
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, newValue, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withImIds(String ... elements) {
        List<String> newValue = SlackGifFile.createUnmodifiableList(false, SlackGifFile.createSafeList(Arrays.asList(elements), true, false));
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withImIds(Iterable<String> elements) {
        if (this.imIds == elements) {
            return this;
        }
        List<String> newValue = SlackGifFile.createUnmodifiableList(false, SlackGifFile.createSafeList(elements, true, false));
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, newValue, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb64Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb64Url, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, newValue, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb64Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb64Url, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, value, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb80Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb80Url, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, newValue, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb80Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb80Url, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, value, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb160Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb160Url, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, newValue, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb160Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb160Url, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, value, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb360Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb360Url, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, newValue, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb360Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb360Url, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, value, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb360Width(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.thumb360Width, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, newValue, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb360Width(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.thumb360Width, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, value, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb360Height(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.thumb360Height, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, newValue, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb360Height(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.thumb360Height, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, value, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb480Url(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumb480Url, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, newValue, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb480Url(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumb480Url, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, value, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb480Width(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.thumb480Width, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, newValue, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb480Width(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.thumb480Width, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, value, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb480Height(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.thumb480Height, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, newValue, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withThumb480Height(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.thumb480Height, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, value, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withImageExifRotation(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.imageExifRotation, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, newValue, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withImageExifRotation(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.imageExifRotation, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, value, this.originalWidth, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withOriginalWidth(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.originalWidth, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, newValue, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withOriginalWidth(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.originalWidth, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, value, this.originalHeight, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withOriginalHeight(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.originalHeight, newValue)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, newValue, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withOriginalHeight(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.originalHeight, value)) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, value, this.hasRichPreview, this.filetype);
    }

    public final SlackGifFile withHasRichPreview(boolean value) {
        if (this.hasRichPreview == value) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, value, this.filetype);
    }

    public final SlackGifFile withFiletype(SlackFileType value) {
        SlackFileType newValue = Objects.requireNonNull(value, "filetype");
        if (this.filetype == newValue) {
            return this;
        }
        return new SlackGifFile(this.id, this.createdEpochSeconds, this.timestampEpochSeconds, this.name, this.title, this.mimetype, this.prettyType, this.userId, this.editable, this.size, this.mode, this.external, this.isPublic, this.publicUrlShared, this.displayAsBot, this.username, this.urlPrivate, this.urlPrivateDownload, this.permalink, this.permalinkPublic, this.commentsCount, this.starred, this.channelIds, this.groupIds, this.imIds, this.thumb64Url, this.thumb80Url, this.thumb160Url, this.thumb360Url, this.thumb360Width, this.thumb360Height, this.thumb480Url, this.thumb480Width, this.thumb480Height, this.imageExifRotation, this.originalWidth, this.originalHeight, this.hasRichPreview, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackGifFile && this.equalTo(0, (SlackGifFile)another);
    }

    private boolean equalTo(int synthetic, SlackGifFile another) {
        return this.id.equals(another.id) && this.createdEpochSeconds == another.createdEpochSeconds && this.timestampEpochSeconds == another.timestampEpochSeconds && this.name.equals(another.name) && this.title.equals(another.title) && this.mimetype.equals(another.mimetype) && this.prettyType.equals(another.prettyType) && this.userId.equals(another.userId) && this.editable == another.editable && this.size == another.size && this.mode.equals(another.mode) && this.external == another.external && this.isPublic == another.isPublic && this.publicUrlShared == another.publicUrlShared && this.displayAsBot == another.displayAsBot && this.username.equals(another.username) && this.urlPrivate.equals(another.urlPrivate) && Objects.equals(this.urlPrivateDownload, another.urlPrivateDownload) && this.permalink.equals(another.permalink) && Objects.equals(this.permalinkPublic, another.permalinkPublic) && this.commentsCount == another.commentsCount && Objects.equals(this.starred, another.starred) && this.channelIds.equals(another.channelIds) && this.groupIds.equals(another.groupIds) && this.imIds.equals(another.imIds) && Objects.equals(this.thumb64Url, another.thumb64Url) && Objects.equals(this.thumb80Url, another.thumb80Url) && Objects.equals(this.thumb160Url, another.thumb160Url) && Objects.equals(this.thumb360Url, another.thumb360Url) && Objects.equals(this.thumb360Width, another.thumb360Width) && Objects.equals(this.thumb360Height, another.thumb360Height) && Objects.equals(this.thumb480Url, another.thumb480Url) && Objects.equals(this.thumb480Width, another.thumb480Width) && Objects.equals(this.thumb480Height, another.thumb480Height) && Objects.equals(this.imageExifRotation, another.imageExifRotation) && Objects.equals(this.originalWidth, another.originalWidth) && Objects.equals(this.originalHeight, another.originalHeight) && this.hasRichPreview == another.hasRichPreview && this.filetype.equals((Object)another.filetype);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Long.hashCode(this.createdEpochSeconds);
        h += (h << 5) + Long.hashCode(this.timestampEpochSeconds);
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.mimetype.hashCode();
        h += (h << 5) + this.prettyType.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.editable);
        h += (h << 5) + Long.hashCode(this.size);
        h += (h << 5) + this.mode.hashCode();
        h += (h << 5) + Boolean.hashCode(this.external);
        h += (h << 5) + Boolean.hashCode(this.isPublic);
        h += (h << 5) + Boolean.hashCode(this.publicUrlShared);
        h += (h << 5) + Boolean.hashCode(this.displayAsBot);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + this.urlPrivate.hashCode();
        h += (h << 5) + Objects.hashCode(this.urlPrivateDownload);
        h += (h << 5) + this.permalink.hashCode();
        h += (h << 5) + Objects.hashCode(this.permalinkPublic);
        h += (h << 5) + this.commentsCount;
        h += (h << 5) + Objects.hashCode(this.starred);
        h += (h << 5) + this.channelIds.hashCode();
        h += (h << 5) + this.groupIds.hashCode();
        h += (h << 5) + this.imIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.thumb64Url);
        h += (h << 5) + Objects.hashCode(this.thumb80Url);
        h += (h << 5) + Objects.hashCode(this.thumb160Url);
        h += (h << 5) + Objects.hashCode(this.thumb360Url);
        h += (h << 5) + Objects.hashCode(this.thumb360Width);
        h += (h << 5) + Objects.hashCode(this.thumb360Height);
        h += (h << 5) + Objects.hashCode(this.thumb480Url);
        h += (h << 5) + Objects.hashCode(this.thumb480Width);
        h += (h << 5) + Objects.hashCode(this.thumb480Height);
        h += (h << 5) + Objects.hashCode(this.imageExifRotation);
        h += (h << 5) + Objects.hashCode(this.originalWidth);
        h += (h << 5) + Objects.hashCode(this.originalHeight);
        h += (h << 5) + Boolean.hashCode(this.hasRichPreview);
        h += (h << 5) + this.filetype.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackGifFile{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("createdEpochSeconds=").append(this.createdEpochSeconds);
        builder.append(", ");
        builder.append("timestampEpochSeconds=").append(this.timestampEpochSeconds);
        builder.append(", ");
        builder.append("name=").append(this.name);
        builder.append(", ");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("mimetype=").append(this.mimetype);
        builder.append(", ");
        builder.append("prettyType=").append(this.prettyType);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("editable=").append(this.editable);
        builder.append(", ");
        builder.append("size=").append(this.size);
        builder.append(", ");
        builder.append("mode=").append(this.mode);
        builder.append(", ");
        builder.append("external=").append(this.external);
        builder.append(", ");
        builder.append("public=").append(this.isPublic);
        builder.append(", ");
        builder.append("publicUrlShared=").append(this.publicUrlShared);
        builder.append(", ");
        builder.append("displayAsBot=").append(this.displayAsBot);
        builder.append(", ");
        builder.append("username=").append(this.username);
        builder.append(", ");
        builder.append("urlPrivate=").append(this.urlPrivate);
        if (this.urlPrivateDownload != null) {
            builder.append(", ");
            builder.append("urlPrivateDownload=").append(this.urlPrivateDownload);
        }
        builder.append(", ");
        builder.append("permalink=").append(this.permalink);
        if (this.permalinkPublic != null) {
            builder.append(", ");
            builder.append("permalinkPublic=").append(this.permalinkPublic);
        }
        builder.append(", ");
        builder.append("commentsCount=").append(this.commentsCount);
        if (this.starred != null) {
            builder.append(", ");
            builder.append("starred=").append(this.starred);
        }
        builder.append(", ");
        builder.append("channelIds=").append(this.channelIds);
        builder.append(", ");
        builder.append("groupIds=").append(this.groupIds);
        builder.append(", ");
        builder.append("imIds=").append(this.imIds);
        if (this.thumb64Url != null) {
            builder.append(", ");
            builder.append("thumb64Url=").append(this.thumb64Url);
        }
        if (this.thumb80Url != null) {
            builder.append(", ");
            builder.append("thumb80Url=").append(this.thumb80Url);
        }
        if (this.thumb160Url != null) {
            builder.append(", ");
            builder.append("thumb160Url=").append(this.thumb160Url);
        }
        if (this.thumb360Url != null) {
            builder.append(", ");
            builder.append("thumb360Url=").append(this.thumb360Url);
        }
        if (this.thumb360Width != null) {
            builder.append(", ");
            builder.append("thumb360Width=").append(this.thumb360Width);
        }
        if (this.thumb360Height != null) {
            builder.append(", ");
            builder.append("thumb360Height=").append(this.thumb360Height);
        }
        if (this.thumb480Url != null) {
            builder.append(", ");
            builder.append("thumb480Url=").append(this.thumb480Url);
        }
        if (this.thumb480Width != null) {
            builder.append(", ");
            builder.append("thumb480Width=").append(this.thumb480Width);
        }
        if (this.thumb480Height != null) {
            builder.append(", ");
            builder.append("thumb480Height=").append(this.thumb480Height);
        }
        if (this.imageExifRotation != null) {
            builder.append(", ");
            builder.append("imageExifRotation=").append(this.imageExifRotation);
        }
        if (this.originalWidth != null) {
            builder.append(", ");
            builder.append("originalWidth=").append(this.originalWidth);
        }
        if (this.originalHeight != null) {
            builder.append(", ");
            builder.append("originalHeight=").append(this.originalHeight);
        }
        builder.append(", ");
        builder.append("hasRichPreview=").append(this.hasRichPreview);
        builder.append(", ");
        builder.append("filetype=").append((Object)this.filetype);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackGifFile fromJson(Json json) {
        Builder builder = SlackGifFile.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.createdEpochSecondsIsSet) {
            builder.setCreatedEpochSeconds(json.createdEpochSeconds);
        }
        if (json.timestampEpochSecondsIsSet) {
            builder.setTimestampEpochSeconds(json.timestampEpochSeconds);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.mimetype != null) {
            builder.setMimetype(json.mimetype);
        }
        if (json.prettyType != null) {
            builder.setPrettyType(json.prettyType);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.editableIsSet) {
            builder.setEditable(json.editable);
        }
        if (json.sizeIsSet) {
            builder.setSize(json.size);
        }
        if (json.mode != null) {
            builder.setMode(json.mode);
        }
        if (json.externalIsSet) {
            builder.setExternal(json.external);
        }
        if (json.isPublicIsSet) {
            builder.setPublic(json.isPublic);
        }
        if (json.publicUrlSharedIsSet) {
            builder.setPublicUrlShared(json.publicUrlShared);
        }
        if (json.displayAsBotIsSet) {
            builder.setDisplayAsBot(json.displayAsBot);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.urlPrivate != null) {
            builder.setUrlPrivate(json.urlPrivate);
        }
        if (json.urlPrivateDownload != null) {
            builder.setUrlPrivateDownload(json.urlPrivateDownload);
        }
        if (json.permalink != null) {
            builder.setPermalink(json.permalink);
        }
        if (json.permalinkPublic != null) {
            builder.setPermalinkPublic(json.permalinkPublic);
        }
        if (json.commentsCountIsSet) {
            builder.setCommentsCount(json.commentsCount);
        }
        if (json.starred != null) {
            builder.setStarred(json.starred);
        }
        if (json.channelIds != null) {
            builder.addAllChannelIds(json.channelIds);
        }
        if (json.groupIds != null) {
            builder.addAllGroupIds(json.groupIds);
        }
        if (json.imIds != null) {
            builder.addAllImIds(json.imIds);
        }
        if (json.thumb64Url != null) {
            builder.setThumb64Url(json.thumb64Url);
        }
        if (json.thumb80Url != null) {
            builder.setThumb80Url(json.thumb80Url);
        }
        if (json.thumb160Url != null) {
            builder.setThumb160Url(json.thumb160Url);
        }
        if (json.thumb360Url != null) {
            builder.setThumb360Url(json.thumb360Url);
        }
        if (json.thumb360Width != null) {
            builder.setThumb360Width(json.thumb360Width);
        }
        if (json.thumb360Height != null) {
            builder.setThumb360Height(json.thumb360Height);
        }
        if (json.thumb480Url != null) {
            builder.setThumb480Url(json.thumb480Url);
        }
        if (json.thumb480Width != null) {
            builder.setThumb480Width(json.thumb480Width);
        }
        if (json.thumb480Height != null) {
            builder.setThumb480Height(json.thumb480Height);
        }
        if (json.imageExifRotation != null) {
            builder.setImageExifRotation(json.imageExifRotation);
        }
        if (json.originalWidth != null) {
            builder.setOriginalWidth(json.originalWidth);
        }
        if (json.originalHeight != null) {
            builder.setOriginalHeight(json.originalHeight);
        }
        if (json.hasRichPreviewIsSet) {
            builder.setHasRichPreview(json.hasRichPreview);
        }
        if (json.filetype != null) {
            builder.setFiletype(json.filetype);
        }
        return builder.build();
    }

    public static SlackGifFile copyOf(SlackGifFileIF instance) {
        if (instance instanceof SlackGifFile) {
            return (SlackGifFile)instance;
        }
        return SlackGifFile.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SlackGifFileIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CREATED_EPOCH_SECONDS = 2L;
        private static final long INIT_BIT_TIMESTAMP_EPOCH_SECONDS = 4L;
        private static final long INIT_BIT_NAME = 8L;
        private static final long INIT_BIT_TITLE = 16L;
        private static final long INIT_BIT_MIMETYPE = 32L;
        private static final long INIT_BIT_PRETTY_TYPE = 64L;
        private static final long INIT_BIT_USER_ID = 128L;
        private static final long INIT_BIT_EDITABLE = 256L;
        private static final long INIT_BIT_SIZE = 512L;
        private static final long INIT_BIT_MODE = 1024L;
        private static final long INIT_BIT_EXTERNAL = 2048L;
        private static final long INIT_BIT_IS_PUBLIC = 4096L;
        private static final long INIT_BIT_PUBLIC_URL_SHARED = 8192L;
        private static final long INIT_BIT_DISPLAY_AS_BOT = 16384L;
        private static final long INIT_BIT_USERNAME = 32768L;
        private static final long INIT_BIT_URL_PRIVATE = 65536L;
        private static final long INIT_BIT_PERMALINK = 131072L;
        private static final long INIT_BIT_HAS_RICH_PREVIEW = 262144L;
        private static final long OPT_BIT_COMMENTS_COUNT = 1L;
        private long initBits = 524287L;
        private long optBits;
        @Nullable
        private String id;
        private long createdEpochSeconds;
        private long timestampEpochSeconds;
        @Nullable
        private String name;
        @Nullable
        private String title;
        @Nullable
        private String mimetype;
        @Nullable
        private String prettyType;
        @Nullable
        private String userId;
        private boolean editable;
        private long size;
        @Nullable
        private String mode;
        private boolean external;
        private boolean isPublic;
        private boolean publicUrlShared;
        private boolean displayAsBot;
        @Nullable
        private String username;
        @Nullable
        private String urlPrivate;
        @Nullable
        private String urlPrivateDownload;
        @Nullable
        private String permalink;
        @Nullable
        private String permalinkPublic;
        private int commentsCount;
        @Nullable
        private Boolean starred;
        private List<String> channelIds = new ArrayList<String>();
        private List<String> groupIds = new ArrayList<String>();
        private List<String> imIds = new ArrayList<String>();
        @Nullable
        private String thumb64Url;
        @Nullable
        private String thumb80Url;
        @Nullable
        private String thumb160Url;
        @Nullable
        private String thumb360Url;
        @Nullable
        private Integer thumb360Width;
        @Nullable
        private Integer thumb360Height;
        @Nullable
        private String thumb480Url;
        @Nullable
        private Integer thumb480Width;
        @Nullable
        private Integer thumb480Height;
        @Nullable
        private Integer imageExifRotation;
        @Nullable
        private Integer originalWidth;
        @Nullable
        private Integer originalHeight;
        private boolean hasRichPreview;
        @Nullable
        private SlackFileType filetype;

        private Builder() {
        }

        public final Builder from(SlackGifFileIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackImageFile instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> permalinkPublicOptional;
            Optional<Integer> thumb360WidthOptional;
            Optional<String> thumb160UrlOptional;
            Optional<Integer> originalWidthOptional;
            Optional<Integer> imageExifRotationOptional;
            Optional<String> thumb80UrlOptional;
            Optional<String> thumb64UrlOptional;
            Optional<Integer> originalHeightOptional;
            Optional<Integer> thumb480WidthOptional;
            Optional<Boolean> starredOptional;
            Optional<String> thumb480UrlOptional;
            Optional<String> thumb360UrlOptional;
            Optional<String> urlPrivateDownloadOptional;
            Optional<Integer> thumb360HeightOptional;
            Optional<Integer> thumb480HeightOptional;
            SlackFile instance;
            long bits = 0L;
            if (object instanceof SlackGifFileIF) {
                instance = (SlackGifFileIF)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    thumb480HeightOptional = instance.getThumb480Height();
                    if (thumb480HeightOptional.isPresent()) {
                        this.setThumb480Height(thumb480HeightOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setDisplayAsBot(instance.getDisplayAsBot());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    thumb360HeightOptional = instance.getThumb360Height();
                    if (thumb360HeightOptional.isPresent()) {
                        this.setThumb360Height(thumb360HeightOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setHasRichPreview(instance.hasRichPreview());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllImIds(instance.getImIds());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                    if (urlPrivateDownloadOptional.isPresent()) {
                        this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    thumb360UrlOptional = instance.getThumb360Url();
                    if (thumb360UrlOptional.isPresent()) {
                        this.setThumb360Url(thumb360UrlOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.setMode(instance.getMode());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    thumb480UrlOptional = instance.getThumb480Url();
                    if (thumb480UrlOptional.isPresent()) {
                        this.setThumb480Url(thumb480UrlOptional);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    starredOptional = instance.isStarred();
                    if (starredOptional.isPresent()) {
                        this.setStarred(starredOptional);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    thumb480WidthOptional = instance.getThumb480Width();
                    if (thumb480WidthOptional.isPresent()) {
                        this.setThumb480Width(thumb480WidthOptional);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.setUrlPrivate(instance.getUrlPrivate());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.setPrettyType(instance.getPrettyType());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.addAllGroupIds(instance.getGroupIds());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.setPublicUrlShared(instance.isPublicUrlShared());
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    this.setPublic(instance.isPublic());
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    this.addAllChannelIds(instance.getChannelIds());
                    bits |= 0x100000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    originalHeightOptional = instance.getOriginalHeight();
                    if (originalHeightOptional.isPresent()) {
                        this.setOriginalHeight(originalHeightOptional);
                    }
                    bits |= 0x400000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    this.setEditable(instance.isEditable());
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    thumb64UrlOptional = instance.getThumb64Url();
                    if (thumb64UrlOptional.isPresent()) {
                        this.setThumb64Url(thumb64UrlOptional);
                    }
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 0x2000000L;
                }
                if ((bits & 0x4000000L) == 0L) {
                    thumb80UrlOptional = instance.getThumb80Url();
                    if (thumb80UrlOptional.isPresent()) {
                        this.setThumb80Url(thumb80UrlOptional);
                    }
                    bits |= 0x4000000L;
                }
                if ((bits & 0x8000000L) == 0L) {
                    imageExifRotationOptional = instance.getImageExifRotation();
                    if (imageExifRotationOptional.isPresent()) {
                        this.setImageExifRotation(imageExifRotationOptional);
                    }
                    bits |= 0x8000000L;
                }
                if ((bits & 0x10000000L) == 0L) {
                    originalWidthOptional = instance.getOriginalWidth();
                    if (originalWidthOptional.isPresent()) {
                        this.setOriginalWidth(originalWidthOptional);
                    }
                    bits |= 0x10000000L;
                }
                if ((bits & 0x20000000L) == 0L) {
                    this.setExternal(instance.isExternal());
                    bits |= 0x20000000L;
                }
                if ((bits & 0x40000000L) == 0L) {
                    this.setSize(instance.getSize());
                    bits |= 0x40000000L;
                }
                if ((bits & 0x80000000L) == 0L) {
                    thumb160UrlOptional = instance.getThumb160Url();
                    if (thumb160UrlOptional.isPresent()) {
                        this.setThumb160Url(thumb160UrlOptional);
                    }
                    bits |= 0x80000000L;
                }
                if ((bits & 0x100000000L) == 0L) {
                    this.setCommentsCount(instance.getCommentsCount());
                    bits |= 0x100000000L;
                }
                if ((bits & 0x200000000L) == 0L) {
                    this.setName(instance.getName());
                    bits |= 0x200000000L;
                }
                if ((bits & 0x400000000L) == 0L) {
                    thumb360WidthOptional = instance.getThumb360Width();
                    if (thumb360WidthOptional.isPresent()) {
                        this.setThumb360Width(thumb360WidthOptional);
                    }
                    bits |= 0x400000000L;
                }
                if ((bits & 0x800000000L) == 0L) {
                    this.setMimetype(instance.getMimetype());
                    bits |= 0x800000000L;
                }
                if ((bits & 0x1000000000L) == 0L) {
                    permalinkPublicOptional = instance.getPermalinkPublic();
                    if (permalinkPublicOptional.isPresent()) {
                        this.setPermalinkPublic(permalinkPublicOptional);
                    }
                    bits |= 0x1000000000L;
                }
                if ((bits & 0x2000000000L) == 0L) {
                    this.setPermalink(instance.getPermalink());
                    bits |= 0x2000000000L;
                }
                if ((bits & 0x4000000000L) == 0L) {
                    this.setUsername(instance.getUsername());
                    bits |= 0x4000000000L;
                }
            }
            if (object instanceof SlackFile) {
                instance = (SlackFile)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setDisplayAsBot(instance.getDisplayAsBot());
                    bits |= 8L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllImIds(instance.getImIds());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                    if (urlPrivateDownloadOptional.isPresent()) {
                        this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.setMode(instance.getMode());
                    bits |= 0x200L;
                }
                if ((bits & 0x800L) == 0L) {
                    starredOptional = instance.isStarred();
                    if (starredOptional.isPresent()) {
                        this.setStarred(starredOptional);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.setUrlPrivate(instance.getUrlPrivate());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.setPrettyType(instance.getPrettyType());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.addAllGroupIds(instance.getGroupIds());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.setPublicUrlShared(instance.isPublicUrlShared());
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    this.setPublic(instance.isPublic());
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    this.addAllChannelIds(instance.getChannelIds());
                    bits |= 0x100000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                    bits |= 0x200000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    this.setEditable(instance.isEditable());
                    bits |= 0x800000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 0x2000000L;
                }
                if ((bits & 0x20000000L) == 0L) {
                    this.setExternal(instance.isExternal());
                    bits |= 0x20000000L;
                }
                if ((bits & 0x40000000L) == 0L) {
                    this.setSize(instance.getSize());
                    bits |= 0x40000000L;
                }
                if ((bits & 0x100000000L) == 0L) {
                    this.setCommentsCount(instance.getCommentsCount());
                    bits |= 0x100000000L;
                }
                if ((bits & 0x200000000L) == 0L) {
                    this.setName(instance.getName());
                    bits |= 0x200000000L;
                }
                if ((bits & 0x800000000L) == 0L) {
                    this.setMimetype(instance.getMimetype());
                    bits |= 0x800000000L;
                }
                if ((bits & 0x1000000000L) == 0L) {
                    permalinkPublicOptional = instance.getPermalinkPublic();
                    if (permalinkPublicOptional.isPresent()) {
                        this.setPermalinkPublic(permalinkPublicOptional);
                    }
                    bits |= 0x1000000000L;
                }
                if ((bits & 0x2000000000L) == 0L) {
                    this.setPermalink(instance.getPermalink());
                    bits |= 0x2000000000L;
                }
                if ((bits & 0x4000000000L) == 0L) {
                    this.setUsername(instance.getUsername());
                    bits |= 0x4000000000L;
                }
            }
            if (object instanceof SlackImageFile) {
                instance = (SlackImageFile)object;
                if ((bits & 1L) == 0L) {
                    this.setFiletype(instance.getFiletype());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    thumb480HeightOptional = instance.getThumb480Height();
                    if (thumb480HeightOptional.isPresent()) {
                        this.setThumb480Height(thumb480HeightOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setTitle(instance.getTitle());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setDisplayAsBot(instance.getDisplayAsBot());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    thumb360HeightOptional = instance.getThumb360Height();
                    if (thumb360HeightOptional.isPresent()) {
                        this.setThumb360Height(thumb360HeightOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.setHasRichPreview(instance.hasRichPreview());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllImIds(instance.getImIds());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
                    if (urlPrivateDownloadOptional.isPresent()) {
                        this.setUrlPrivateDownload(urlPrivateDownloadOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    thumb360UrlOptional = instance.getThumb360Url();
                    if (thumb360UrlOptional.isPresent()) {
                        this.setThumb360Url(thumb360UrlOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.setMode(instance.getMode());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    thumb480UrlOptional = instance.getThumb480Url();
                    if (thumb480UrlOptional.isPresent()) {
                        this.setThumb480Url(thumb480UrlOptional);
                    }
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    starredOptional = instance.isStarred();
                    if (starredOptional.isPresent()) {
                        this.setStarred(starredOptional);
                    }
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    thumb480WidthOptional = instance.getThumb480Width();
                    if (thumb480WidthOptional.isPresent()) {
                        this.setThumb480Width(thumb480WidthOptional);
                    }
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.setUrlPrivate(instance.getUrlPrivate());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.setPrettyType(instance.getPrettyType());
                    bits |= 0x4000L;
                }
                if ((bits & 0x8000L) == 0L) {
                    this.addAllGroupIds(instance.getGroupIds());
                    bits |= 0x8000L;
                }
                if ((bits & 0x10000L) == 0L) {
                    this.setPublicUrlShared(instance.isPublicUrlShared());
                    bits |= 0x10000L;
                }
                if ((bits & 0x20000L) == 0L) {
                    this.setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
                    bits |= 0x20000L;
                }
                if ((bits & 0x40000L) == 0L) {
                    this.setPublic(instance.isPublic());
                    bits |= 0x40000L;
                }
                if ((bits & 0x80000L) == 0L) {
                    this.setId(instance.getId());
                    bits |= 0x80000L;
                }
                if ((bits & 0x100000L) == 0L) {
                    this.addAllChannelIds(instance.getChannelIds());
                    bits |= 0x100000L;
                }
                if ((bits & 0x200000L) == 0L) {
                    this.setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
                    bits |= 0x200000L;
                }
                if ((bits & 0x400000L) == 0L) {
                    originalHeightOptional = instance.getOriginalHeight();
                    if (originalHeightOptional.isPresent()) {
                        this.setOriginalHeight(originalHeightOptional);
                    }
                    bits |= 0x400000L;
                }
                if ((bits & 0x800000L) == 0L) {
                    this.setEditable(instance.isEditable());
                    bits |= 0x800000L;
                }
                if ((bits & 0x1000000L) == 0L) {
                    thumb64UrlOptional = instance.getThumb64Url();
                    if (thumb64UrlOptional.isPresent()) {
                        this.setThumb64Url(thumb64UrlOptional);
                    }
                    bits |= 0x1000000L;
                }
                if ((bits & 0x2000000L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 0x2000000L;
                }
                if ((bits & 0x4000000L) == 0L) {
                    thumb80UrlOptional = instance.getThumb80Url();
                    if (thumb80UrlOptional.isPresent()) {
                        this.setThumb80Url(thumb80UrlOptional);
                    }
                    bits |= 0x4000000L;
                }
                if ((bits & 0x8000000L) == 0L) {
                    imageExifRotationOptional = instance.getImageExifRotation();
                    if (imageExifRotationOptional.isPresent()) {
                        this.setImageExifRotation(imageExifRotationOptional);
                    }
                    bits |= 0x8000000L;
                }
                if ((bits & 0x10000000L) == 0L) {
                    originalWidthOptional = instance.getOriginalWidth();
                    if (originalWidthOptional.isPresent()) {
                        this.setOriginalWidth(originalWidthOptional);
                    }
                    bits |= 0x10000000L;
                }
                if ((bits & 0x20000000L) == 0L) {
                    this.setExternal(instance.isExternal());
                    bits |= 0x20000000L;
                }
                if ((bits & 0x40000000L) == 0L) {
                    this.setSize(instance.getSize());
                    bits |= 0x40000000L;
                }
                if ((bits & 0x80000000L) == 0L) {
                    thumb160UrlOptional = instance.getThumb160Url();
                    if (thumb160UrlOptional.isPresent()) {
                        this.setThumb160Url(thumb160UrlOptional);
                    }
                    bits |= 0x80000000L;
                }
                if ((bits & 0x100000000L) == 0L) {
                    this.setCommentsCount(instance.getCommentsCount());
                    bits |= 0x100000000L;
                }
                if ((bits & 0x200000000L) == 0L) {
                    this.setName(instance.getName());
                    bits |= 0x200000000L;
                }
                if ((bits & 0x400000000L) == 0L) {
                    thumb360WidthOptional = instance.getThumb360Width();
                    if (thumb360WidthOptional.isPresent()) {
                        this.setThumb360Width(thumb360WidthOptional);
                    }
                    bits |= 0x400000000L;
                }
                if ((bits & 0x800000000L) == 0L) {
                    this.setMimetype(instance.getMimetype());
                    bits |= 0x800000000L;
                }
                if ((bits & 0x1000000000L) == 0L) {
                    permalinkPublicOptional = instance.getPermalinkPublic();
                    if (permalinkPublicOptional.isPresent()) {
                        this.setPermalinkPublic(permalinkPublicOptional);
                    }
                    bits |= 0x1000000000L;
                }
                if ((bits & 0x2000000000L) == 0L) {
                    this.setPermalink(instance.getPermalink());
                    bits |= 0x2000000000L;
                }
                if ((bits & 0x4000000000L) == 0L) {
                    this.setUsername(instance.getUsername());
                    bits |= 0x4000000000L;
                }
            }
        }

        @JsonProperty
        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="created")
        public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="timestamp")
        public final Builder setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @JsonProperty
        public final Builder setMimetype(String mimetype) {
            this.mimetype = Objects.requireNonNull(mimetype, "mimetype");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @JsonProperty
        public final Builder setPrettyType(String prettyType) {
            this.prettyType = Objects.requireNonNull(prettyType, "prettyType");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @JsonProperty
        public final Builder setEditable(boolean editable) {
            this.editable = editable;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        @JsonProperty
        public final Builder setSize(long size) {
            this.size = size;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        @JsonProperty
        public final Builder setMode(String mode) {
            this.mode = Objects.requireNonNull(mode, "mode");
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        @JsonProperty(value="is_external")
        public final Builder setExternal(boolean external) {
            this.external = external;
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        @JsonProperty(value="is_public")
        public final Builder setPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        @JsonProperty
        public final Builder setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        @JsonProperty
        public final Builder setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        @JsonProperty
        public final Builder setUsername(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        @JsonProperty
        public final Builder setUrlPrivate(String urlPrivate) {
            this.urlPrivate = Objects.requireNonNull(urlPrivate, "urlPrivate");
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        public final Builder setUrlPrivateDownload(@Nullable String urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
            return this;
        }

        @JsonProperty
        public final Builder setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload.orElse(null);
            return this;
        }

        @JsonProperty
        public final Builder setPermalink(String permalink) {
            this.permalink = Objects.requireNonNull(permalink, "permalink");
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        public final Builder setPermalinkPublic(@Nullable String permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
            return this;
        }

        @JsonProperty
        public final Builder setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic.orElse(null);
            return this;
        }

        @JsonProperty
        public final Builder setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setStarred(@Nullable Boolean starred) {
            this.starred = starred;
            return this;
        }

        @JsonProperty(value="is_starred")
        public final Builder setStarred(Optional<Boolean> starred) {
            this.starred = starred.orElse(null);
            return this;
        }

        public final Builder addChannelIds(String element) {
            this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            return this;
        }

        public final Builder addChannelIds(String ... elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        @JsonProperty(value="channels")
        public final Builder setChannelIds(Iterable<String> elements) {
            this.channelIds.clear();
            return this.addAllChannelIds(elements);
        }

        public final Builder addAllChannelIds(Iterable<String> elements) {
            for (String element : elements) {
                this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
            }
            return this;
        }

        public final Builder addGroupIds(String element) {
            this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            return this;
        }

        public final Builder addGroupIds(String ... elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        @JsonProperty(value="groups")
        public final Builder setGroupIds(Iterable<String> elements) {
            this.groupIds.clear();
            return this.addAllGroupIds(elements);
        }

        public final Builder addAllGroupIds(Iterable<String> elements) {
            for (String element : elements) {
                this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
            }
            return this;
        }

        public final Builder addImIds(String element) {
            this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            return this;
        }

        public final Builder addImIds(String ... elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        @JsonProperty(value="ims")
        public final Builder setImIds(Iterable<String> elements) {
            this.imIds.clear();
            return this.addAllImIds(elements);
        }

        public final Builder addAllImIds(Iterable<String> elements) {
            for (String element : elements) {
                this.imIds.add(Objects.requireNonNull(element, "imIds element"));
            }
            return this;
        }

        public final Builder setThumb64Url(@Nullable String thumb64Url) {
            this.thumb64Url = thumb64Url;
            return this;
        }

        @JsonProperty(value="thumb_64")
        public final Builder setThumb64Url(Optional<String> thumb64Url) {
            this.thumb64Url = thumb64Url.orElse(null);
            return this;
        }

        public final Builder setThumb80Url(@Nullable String thumb80Url) {
            this.thumb80Url = thumb80Url;
            return this;
        }

        @JsonProperty(value="thumb_80")
        public final Builder setThumb80Url(Optional<String> thumb80Url) {
            this.thumb80Url = thumb80Url.orElse(null);
            return this;
        }

        public final Builder setThumb160Url(@Nullable String thumb160Url) {
            this.thumb160Url = thumb160Url;
            return this;
        }

        @JsonProperty(value="thumb_160")
        public final Builder setThumb160Url(Optional<String> thumb160Url) {
            this.thumb160Url = thumb160Url.orElse(null);
            return this;
        }

        public final Builder setThumb360Url(@Nullable String thumb360Url) {
            this.thumb360Url = thumb360Url;
            return this;
        }

        @JsonProperty(value="thumb_360")
        public final Builder setThumb360Url(Optional<String> thumb360Url) {
            this.thumb360Url = thumb360Url.orElse(null);
            return this;
        }

        public final Builder setThumb360Width(@Nullable Integer thumb360Width) {
            this.thumb360Width = thumb360Width;
            return this;
        }

        @JsonProperty(value="thumb_360_w")
        public final Builder setThumb360Width(Optional<Integer> thumb360Width) {
            this.thumb360Width = thumb360Width.orElse(null);
            return this;
        }

        public final Builder setThumb360Height(@Nullable Integer thumb360Height) {
            this.thumb360Height = thumb360Height;
            return this;
        }

        @JsonProperty(value="thumb_360_h")
        public final Builder setThumb360Height(Optional<Integer> thumb360Height) {
            this.thumb360Height = thumb360Height.orElse(null);
            return this;
        }

        public final Builder setThumb480Url(@Nullable String thumb480Url) {
            this.thumb480Url = thumb480Url;
            return this;
        }

        @JsonProperty(value="thumb_480")
        public final Builder setThumb480Url(Optional<String> thumb480Url) {
            this.thumb480Url = thumb480Url.orElse(null);
            return this;
        }

        public final Builder setThumb480Width(@Nullable Integer thumb480Width) {
            this.thumb480Width = thumb480Width;
            return this;
        }

        @JsonProperty(value="thumb_480_w")
        public final Builder setThumb480Width(Optional<Integer> thumb480Width) {
            this.thumb480Width = thumb480Width.orElse(null);
            return this;
        }

        public final Builder setThumb480Height(@Nullable Integer thumb480Height) {
            this.thumb480Height = thumb480Height;
            return this;
        }

        @JsonProperty(value="thumb_480_h")
        public final Builder setThumb480Height(Optional<Integer> thumb480Height) {
            this.thumb480Height = thumb480Height.orElse(null);
            return this;
        }

        public final Builder setImageExifRotation(@Nullable Integer imageExifRotation) {
            this.imageExifRotation = imageExifRotation;
            return this;
        }

        @JsonProperty
        public final Builder setImageExifRotation(Optional<Integer> imageExifRotation) {
            this.imageExifRotation = imageExifRotation.orElse(null);
            return this;
        }

        public final Builder setOriginalWidth(@Nullable Integer originalWidth) {
            this.originalWidth = originalWidth;
            return this;
        }

        @JsonProperty(value="original_w")
        public final Builder setOriginalWidth(Optional<Integer> originalWidth) {
            this.originalWidth = originalWidth.orElse(null);
            return this;
        }

        public final Builder setOriginalHeight(@Nullable Integer originalHeight) {
            this.originalHeight = originalHeight;
            return this;
        }

        @JsonProperty(value="original_h")
        public final Builder setOriginalHeight(Optional<Integer> originalHeight) {
            this.originalHeight = originalHeight.orElse(null);
            return this;
        }

        @JsonProperty(value="has_rich_preview")
        public final Builder setHasRichPreview(boolean hasRichPreview) {
            this.hasRichPreview = hasRichPreview;
            this.initBits &= 0xFFFFFFFFFFFBFFFFL;
            return this;
        }

        @JsonProperty
        public final Builder setFiletype(SlackFileType filetype) {
            this.filetype = Objects.requireNonNull(filetype, "filetype");
            return this;
        }

        public SlackGifFile build() {
            this.checkRequiredAttributes();
            return new SlackGifFile(this);
        }

        private boolean commentsCountIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean createdEpochSecondsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean timestampEpochSecondsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean titleIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean mimetypeIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private boolean prettyTypeIsSet() {
            return (this.initBits & 0x40L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 0x80L) == 0L;
        }

        private boolean editableIsSet() {
            return (this.initBits & 0x100L) == 0L;
        }

        private boolean sizeIsSet() {
            return (this.initBits & 0x200L) == 0L;
        }

        private boolean modeIsSet() {
            return (this.initBits & 0x400L) == 0L;
        }

        private boolean externalIsSet() {
            return (this.initBits & 0x800L) == 0L;
        }

        private boolean publicIsSet() {
            return (this.initBits & 0x1000L) == 0L;
        }

        private boolean publicUrlSharedIsSet() {
            return (this.initBits & 0x2000L) == 0L;
        }

        private boolean displayAsBotIsSet() {
            return (this.initBits & 0x4000L) == 0L;
        }

        private boolean usernameIsSet() {
            return (this.initBits & 0x8000L) == 0L;
        }

        private boolean urlPrivateIsSet() {
            return (this.initBits & 0x10000L) == 0L;
        }

        private boolean permalinkIsSet() {
            return (this.initBits & 0x20000L) == 0L;
        }

        private boolean hasRichPreviewIsSet() {
            return (this.initBits & 0x40000L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.createdEpochSecondsIsSet()) {
                attributes.add("createdEpochSeconds");
            }
            if (!this.timestampEpochSecondsIsSet()) {
                attributes.add("timestampEpochSeconds");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.mimetypeIsSet()) {
                attributes.add("mimetype");
            }
            if (!this.prettyTypeIsSet()) {
                attributes.add("prettyType");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.editableIsSet()) {
                attributes.add("editable");
            }
            if (!this.sizeIsSet()) {
                attributes.add("size");
            }
            if (!this.modeIsSet()) {
                attributes.add("mode");
            }
            if (!this.externalIsSet()) {
                attributes.add("external");
            }
            if (!this.publicIsSet()) {
                attributes.add("public");
            }
            if (!this.publicUrlSharedIsSet()) {
                attributes.add("publicUrlShared");
            }
            if (!this.displayAsBotIsSet()) {
                attributes.add("displayAsBot");
            }
            if (!this.usernameIsSet()) {
                attributes.add("username");
            }
            if (!this.urlPrivateIsSet()) {
                attributes.add("urlPrivate");
            }
            if (!this.permalinkIsSet()) {
                attributes.add("permalink");
            }
            if (!this.hasRichPreviewIsSet()) {
                attributes.add("hasRichPreview");
            }
            return "Cannot build SlackGifFile, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackGifFileIF", generator="Immutables")
    static final class Json
    implements SlackGifFileIF {
        @Nullable
        String id;
        long createdEpochSeconds;
        boolean createdEpochSecondsIsSet;
        long timestampEpochSeconds;
        boolean timestampEpochSecondsIsSet;
        @Nullable
        String name;
        @Nullable
        String title;
        @Nullable
        String mimetype;
        @Nullable
        String prettyType;
        @Nullable
        String userId;
        boolean editable;
        boolean editableIsSet;
        long size;
        boolean sizeIsSet;
        @Nullable
        String mode;
        boolean external;
        boolean externalIsSet;
        boolean isPublic;
        boolean isPublicIsSet;
        boolean publicUrlShared;
        boolean publicUrlSharedIsSet;
        boolean displayAsBot;
        boolean displayAsBotIsSet;
        @Nullable
        String username;
        @Nullable
        String urlPrivate;
        @Nullable
        Optional<String> urlPrivateDownload = Optional.empty();
        @Nullable
        String permalink;
        @Nullable
        Optional<String> permalinkPublic = Optional.empty();
        int commentsCount;
        boolean commentsCountIsSet;
        @Nullable
        Optional<Boolean> starred = Optional.empty();
        @Nullable
        List<String> channelIds = Collections.emptyList();
        @Nullable
        List<String> groupIds = Collections.emptyList();
        @Nullable
        List<String> imIds = Collections.emptyList();
        @Nullable
        Optional<String> thumb64Url = Optional.empty();
        @Nullable
        Optional<String> thumb80Url = Optional.empty();
        @Nullable
        Optional<String> thumb160Url = Optional.empty();
        @Nullable
        Optional<String> thumb360Url = Optional.empty();
        @Nullable
        Optional<Integer> thumb360Width = Optional.empty();
        @Nullable
        Optional<Integer> thumb360Height = Optional.empty();
        @Nullable
        Optional<String> thumb480Url = Optional.empty();
        @Nullable
        Optional<Integer> thumb480Width = Optional.empty();
        @Nullable
        Optional<Integer> thumb480Height = Optional.empty();
        @Nullable
        Optional<Integer> imageExifRotation = Optional.empty();
        @Nullable
        Optional<Integer> originalWidth = Optional.empty();
        @Nullable
        Optional<Integer> originalHeight = Optional.empty();
        boolean hasRichPreview;
        boolean hasRichPreviewIsSet;
        @Nullable
        SlackFileType filetype;

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="created")
        public void setCreatedEpochSeconds(long createdEpochSeconds) {
            this.createdEpochSeconds = createdEpochSeconds;
            this.createdEpochSecondsIsSet = true;
        }

        @JsonProperty(value="timestamp")
        public void setTimestampEpochSeconds(long timestampEpochSeconds) {
            this.timestampEpochSeconds = timestampEpochSeconds;
            this.timestampEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setMimetype(String mimetype) {
            this.mimetype = mimetype;
        }

        @JsonProperty
        public void setPrettyType(String prettyType) {
            this.prettyType = prettyType;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setEditable(boolean editable) {
            this.editable = editable;
            this.editableIsSet = true;
        }

        @JsonProperty
        public void setSize(long size) {
            this.size = size;
            this.sizeIsSet = true;
        }

        @JsonProperty
        public void setMode(String mode) {
            this.mode = mode;
        }

        @JsonProperty(value="is_external")
        public void setExternal(boolean external) {
            this.external = external;
            this.externalIsSet = true;
        }

        @JsonProperty(value="is_public")
        public void setPublic(boolean isPublic) {
            this.isPublic = isPublic;
            this.isPublicIsSet = true;
        }

        @JsonProperty
        public void setPublicUrlShared(boolean publicUrlShared) {
            this.publicUrlShared = publicUrlShared;
            this.publicUrlSharedIsSet = true;
        }

        @JsonProperty
        public void setDisplayAsBot(boolean displayAsBot) {
            this.displayAsBot = displayAsBot;
            this.displayAsBotIsSet = true;
        }

        @JsonProperty
        public void setUsername(String username) {
            this.username = username;
        }

        @JsonProperty
        public void setUrlPrivate(String urlPrivate) {
            this.urlPrivate = urlPrivate;
        }

        @JsonProperty
        public void setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
            this.urlPrivateDownload = urlPrivateDownload;
        }

        @JsonProperty
        public void setPermalink(String permalink) {
            this.permalink = permalink;
        }

        @JsonProperty
        public void setPermalinkPublic(Optional<String> permalinkPublic) {
            this.permalinkPublic = permalinkPublic;
        }

        @JsonProperty
        public void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountIsSet = true;
        }

        @JsonProperty(value="is_starred")
        public void setStarred(Optional<Boolean> starred) {
            this.starred = starred;
        }

        @JsonProperty(value="channels")
        public void setChannelIds(List<String> channelIds) {
            this.channelIds = channelIds;
        }

        @JsonProperty(value="groups")
        public void setGroupIds(List<String> groupIds) {
            this.groupIds = groupIds;
        }

        @JsonProperty(value="ims")
        public void setImIds(List<String> imIds) {
            this.imIds = imIds;
        }

        @JsonProperty(value="thumb_64")
        public void setThumb64Url(Optional<String> thumb64Url) {
            this.thumb64Url = thumb64Url;
        }

        @JsonProperty(value="thumb_80")
        public void setThumb80Url(Optional<String> thumb80Url) {
            this.thumb80Url = thumb80Url;
        }

        @JsonProperty(value="thumb_160")
        public void setThumb160Url(Optional<String> thumb160Url) {
            this.thumb160Url = thumb160Url;
        }

        @JsonProperty(value="thumb_360")
        public void setThumb360Url(Optional<String> thumb360Url) {
            this.thumb360Url = thumb360Url;
        }

        @JsonProperty(value="thumb_360_w")
        public void setThumb360Width(Optional<Integer> thumb360Width) {
            this.thumb360Width = thumb360Width;
        }

        @JsonProperty(value="thumb_360_h")
        public void setThumb360Height(Optional<Integer> thumb360Height) {
            this.thumb360Height = thumb360Height;
        }

        @JsonProperty(value="thumb_480")
        public void setThumb480Url(Optional<String> thumb480Url) {
            this.thumb480Url = thumb480Url;
        }

        @JsonProperty(value="thumb_480_w")
        public void setThumb480Width(Optional<Integer> thumb480Width) {
            this.thumb480Width = thumb480Width;
        }

        @JsonProperty(value="thumb_480_h")
        public void setThumb480Height(Optional<Integer> thumb480Height) {
            this.thumb480Height = thumb480Height;
        }

        @JsonProperty
        public void setImageExifRotation(Optional<Integer> imageExifRotation) {
            this.imageExifRotation = imageExifRotation;
        }

        @JsonProperty(value="original_w")
        public void setOriginalWidth(Optional<Integer> originalWidth) {
            this.originalWidth = originalWidth;
        }

        @JsonProperty(value="original_h")
        public void setOriginalHeight(Optional<Integer> originalHeight) {
            this.originalHeight = originalHeight;
        }

        @JsonProperty(value="has_rich_preview")
        public void setHasRichPreview(boolean hasRichPreview) {
            this.hasRichPreview = hasRichPreview;
            this.hasRichPreviewIsSet = true;
        }

        @JsonProperty
        public void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getCreatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getTimestampEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMimetype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPrettyType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEditable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getSize() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isExternal() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isPublicUrlShared() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getDisplayAsBot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUrlPrivate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrlPrivateDownload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getPermalink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPermalinkPublic() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCommentsCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isStarred() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getChannelIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getGroupIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getImIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb64Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb80Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb160Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb360Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getThumb360Width() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getThumb360Height() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumb480Url() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getThumb480Width() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getThumb480Height() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getImageExifRotation() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getOriginalWidth() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getOriginalHeight() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasRichPreview() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackFileType getFiletype() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="SlackGifFileIF", generator="Immutables")
    private final class InitShim {
        private byte commentsCountBuildStage = 0;
        private int commentsCount;
        private byte filetypeBuildStage = 0;
        private SlackFileType filetype;

        private InitShim() {
        }

        int getCommentsCount() {
            if (this.commentsCountBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.commentsCountBuildStage == 0) {
                this.commentsCountBuildStage = (byte)-1;
                this.commentsCount = SlackGifFile.this.getCommentsCountInitialize();
                this.commentsCountBuildStage = 1;
            }
            return this.commentsCount;
        }

        void setCommentsCount(int commentsCount) {
            this.commentsCount = commentsCount;
            this.commentsCountBuildStage = 1;
        }

        SlackFileType getFiletype() {
            if (this.filetypeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.filetypeBuildStage == 0) {
                this.filetypeBuildStage = (byte)-1;
                this.filetype = Objects.requireNonNull(SlackGifFile.this.getFiletypeInitialize(), "filetype");
                this.filetypeBuildStage = 1;
            }
            return this.filetype;
        }

        void setFiletype(SlackFileType filetype) {
            this.filetype = filetype;
            this.filetypeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.commentsCountBuildStage == -1) {
                attributes.add("commentsCount");
            }
            if (this.filetypeBuildStage == -1) {
                attributes.add("filetype");
            }
            return "Cannot build SlackGifFile, attribute initializers form cycle " + attributes;
        }
    }
}

