/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.links;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.links.Link;
import com.hubspot.slack.client.models.events.links.SlackLinkSharedEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackLinkSharedEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackLinkSharedEvent
implements SlackLinkSharedEventIF {
    private final SlackEventType type;
    private final String channelId;
    private final String userId;
    private final String messageTs;
    @Nullable
    private final String threadTs;
    private final List<Link> links;

    private SlackLinkSharedEvent(SlackEventType type, String channelId, String userId, String messageTs, @Nullable String threadTs, List<Link> links) {
        this.type = type;
        this.channelId = channelId;
        this.userId = userId;
        this.messageTs = messageTs;
        this.threadTs = threadTs;
        this.links = links;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public String getMessageTs() {
        return this.messageTs;
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty
    public List<Link> getLinks() {
        return this.links;
    }

    public final SlackLinkSharedEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackLinkSharedEvent(newValue, this.channelId, this.userId, this.messageTs, this.threadTs, this.links);
    }

    public final SlackLinkSharedEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackLinkSharedEvent(this.type, newValue, this.userId, this.messageTs, this.threadTs, this.links);
    }

    public final SlackLinkSharedEvent withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackLinkSharedEvent(this.type, this.channelId, newValue, this.messageTs, this.threadTs, this.links);
    }

    public final SlackLinkSharedEvent withMessageTs(String value) {
        String newValue = Objects.requireNonNull(value, "messageTs");
        if (this.messageTs.equals(newValue)) {
            return this;
        }
        return new SlackLinkSharedEvent(this.type, this.channelId, this.userId, newValue, this.threadTs, this.links);
    }

    public final SlackLinkSharedEvent withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return new SlackLinkSharedEvent(this.type, this.channelId, this.userId, this.messageTs, newValue, this.links);
    }

    public final SlackLinkSharedEvent withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return new SlackLinkSharedEvent(this.type, this.channelId, this.userId, this.messageTs, value, this.links);
    }

    public final SlackLinkSharedEvent withLinks(Link ... elements) {
        List<Link> newValue = SlackLinkSharedEvent.createUnmodifiableList(false, SlackLinkSharedEvent.createSafeList(Arrays.asList(elements), true, false));
        return new SlackLinkSharedEvent(this.type, this.channelId, this.userId, this.messageTs, this.threadTs, newValue);
    }

    public final SlackLinkSharedEvent withLinks(Iterable<? extends Link> elements) {
        if (this.links == elements) {
            return this;
        }
        List<Link> newValue = SlackLinkSharedEvent.createUnmodifiableList(false, SlackLinkSharedEvent.createSafeList(elements, true, false));
        return new SlackLinkSharedEvent(this.type, this.channelId, this.userId, this.messageTs, this.threadTs, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackLinkSharedEvent && this.equalTo(0, (SlackLinkSharedEvent)another);
    }

    private boolean equalTo(int synthetic, SlackLinkSharedEvent another) {
        return this.type.equals((Object)another.type) && this.channelId.equals(another.channelId) && this.userId.equals(another.userId) && this.messageTs.equals(another.messageTs) && Objects.equals(this.threadTs, another.threadTs) && this.links.equals(another.links);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.messageTs.hashCode();
        h += (h << 5) + Objects.hashCode(this.threadTs);
        h += (h << 5) + this.links.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackLinkSharedEvent{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("messageTs=").append(this.messageTs);
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        builder.append(", ");
        builder.append("links=").append(this.links);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackLinkSharedEvent fromJson(Json json) {
        Builder builder = SlackLinkSharedEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.messageTs != null) {
            builder.setMessageTs(json.messageTs);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.links != null) {
            builder.addAllLinks(json.links);
        }
        return builder.build();
    }

    public static SlackLinkSharedEvent copyOf(SlackLinkSharedEventIF instance) {
        if (instance instanceof SlackLinkSharedEvent) {
            return (SlackLinkSharedEvent)instance;
        }
        return SlackLinkSharedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SlackLinkSharedEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long INIT_BIT_MESSAGE_TS = 8L;
        private long initBits = 15L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String channelId;
        @Nullable
        private String userId;
        @Nullable
        private String messageTs;
        @Nullable
        private String threadTs;
        private List<Link> links = new ArrayList<Link>();

        private Builder() {
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackLinkSharedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackLinkSharedEventIF) {
                Optional<String> threadTsOptional;
                instance = (SlackLinkSharedEventIF)object;
                this.addAllLinks(instance.getLinks());
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((threadTsOptional = instance.getThreadTs()).isPresent()) {
                    this.setThreadTs(threadTsOptional);
                }
                this.setUserId(instance.getUserId());
                this.setMessageTs(instance.getMessageTs());
                this.setChannelId(instance.getChannelId());
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        public final Builder setMessageTs(String messageTs) {
            this.messageTs = Objects.requireNonNull(messageTs, "messageTs");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        @JsonProperty
        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder addLinks(Link element) {
            this.links.add(Objects.requireNonNull(element, "links element"));
            return this;
        }

        public final Builder addLinks(Link ... elements) {
            for (Link element : elements) {
                this.links.add(Objects.requireNonNull(element, "links element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setLinks(Iterable<? extends Link> elements) {
            this.links.clear();
            return this.addAllLinks(elements);
        }

        public final Builder addAllLinks(Iterable<? extends Link> elements) {
            for (Link link : elements) {
                this.links.add(Objects.requireNonNull(link, "links element"));
            }
            return this;
        }

        public SlackLinkSharedEvent build() {
            this.checkRequiredAttributes();
            return new SlackLinkSharedEvent(this.type, this.channelId, this.userId, this.messageTs, this.threadTs, SlackLinkSharedEvent.createUnmodifiableList(true, this.links));
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean messageTsIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.messageTsIsSet()) {
                attributes.add("messageTs");
            }
            return "Cannot build SlackLinkSharedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackLinkSharedEventIF", generator="Immutables")
    static final class Json
    implements SlackLinkSharedEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String channelId;
        @Nullable
        String userId;
        @Nullable
        String messageTs;
        @Nullable
        Optional<String> threadTs = Optional.empty();
        @Nullable
        List<Link> links = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setMessageTs(String messageTs) {
            this.messageTs = messageTs;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setLinks(List<Link> links) {
            this.links = links;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getMessageTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Link> getLinks() {
            throw new UnsupportedOperationException();
        }
    }
}

