/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.channel.SlackChannelUnarchiveEventIF;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventCore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackChannelUnarchiveEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackChannelUnarchiveEvent
implements SlackChannelUnarchiveEventIF {
    private final SlackEventType type;
    private final String channelId;
    private final String unarchivedByUserId;

    private SlackChannelUnarchiveEvent(SlackEventType type, String channelId, String unarchivedByUserId) {
        this.type = type;
        this.channelId = channelId;
        this.unarchivedByUserId = unarchivedByUserId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="user")
    public String getUnarchivedByUserId() {
        return this.unarchivedByUserId;
    }

    public final SlackChannelUnarchiveEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackChannelUnarchiveEvent(newValue, this.channelId, this.unarchivedByUserId);
    }

    public final SlackChannelUnarchiveEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackChannelUnarchiveEvent(this.type, newValue, this.unarchivedByUserId);
    }

    public final SlackChannelUnarchiveEvent withUnarchivedByUserId(String value) {
        String newValue = Objects.requireNonNull(value, "unarchivedByUserId");
        if (this.unarchivedByUserId.equals(newValue)) {
            return this;
        }
        return new SlackChannelUnarchiveEvent(this.type, this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannelUnarchiveEvent && this.equalTo(0, (SlackChannelUnarchiveEvent)another);
    }

    private boolean equalTo(int synthetic, SlackChannelUnarchiveEvent another) {
        return this.type.equals((Object)another.type) && this.channelId.equals(another.channelId) && this.unarchivedByUserId.equals(another.unarchivedByUserId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.unarchivedByUserId.hashCode();
        return h;
    }

    public String toString() {
        return "SlackChannelUnarchiveEvent{type=" + this.type + ", channelId=" + this.channelId + ", unarchivedByUserId=" + this.unarchivedByUserId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackChannelUnarchiveEvent fromJson(Json json) {
        Builder builder = SlackChannelUnarchiveEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.unarchivedByUserId != null) {
            builder.setUnarchivedByUserId(json.unarchivedByUserId);
        }
        return builder.build();
    }

    public static SlackChannelUnarchiveEvent copyOf(SlackChannelUnarchiveEventIF instance) {
        if (instance instanceof SlackChannelUnarchiveEvent) {
            return (SlackChannelUnarchiveEvent)instance;
        }
        return SlackChannelUnarchiveEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackChannelUnarchiveEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_UNARCHIVED_BY_USER_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String channelId;
        @Nullable
        private String unarchivedByUserId;

        private Builder() {
        }

        public final Builder from(SlackConversationEventCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackChannelUnarchiveEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackConversationEventCore) {
                instance = (SlackConversationEventCore)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackChannelUnarchiveEventIF) {
                instance = (SlackChannelUnarchiveEventIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
                this.setUnarchivedByUserId(instance.getUnarchivedByUserId());
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUnarchivedByUserId(String unarchivedByUserId) {
            this.unarchivedByUserId = Objects.requireNonNull(unarchivedByUserId, "unarchivedByUserId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SlackChannelUnarchiveEvent build() {
            this.checkRequiredAttributes();
            return new SlackChannelUnarchiveEvent(this.type, this.channelId, this.unarchivedByUserId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean unarchivedByUserIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.unarchivedByUserIdIsSet()) {
                attributes.add("unarchivedByUserId");
            }
            return "Cannot build SlackChannelUnarchiveEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackChannelUnarchiveEventIF", generator="Immutables")
    static final class Json
    implements SlackChannelUnarchiveEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String channelId;
        @Nullable
        String unarchivedByUserId;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="user")
        public void setUnarchivedByUserId(String unarchivedByUserId) {
            this.unarchivedByUserId = unarchivedByUserId;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUnarchivedByUserId() {
            throw new UnsupportedOperationException();
        }
    }
}

