/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.channel.SlackChannelRenameEventIF;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventCore;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventWithChannel;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackChannelRenameEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackChannelRenameEvent
implements SlackChannelRenameEventIF {
    private final SlackEventType type;
    private final SlackChannel channel;
    private final transient String channelId;

    private SlackChannelRenameEvent(SlackEventType type, SlackChannel channel) {
        this.type = type;
        this.channel = channel;
        this.channelId = Objects.requireNonNull(SlackChannelRenameEventIF.super.getChannelId(), "channelId");
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public SlackChannel getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public String getChannelId() {
        return this.channelId;
    }

    public final SlackChannelRenameEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackChannelRenameEvent(newValue, this.channel);
    }

    public final SlackChannelRenameEvent withChannel(SlackChannel value) {
        if (this.channel == value) {
            return this;
        }
        SlackChannel newValue = Objects.requireNonNull(value, "channel");
        return new SlackChannelRenameEvent(this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannelRenameEvent && this.equalTo(0, (SlackChannelRenameEvent)another);
    }

    private boolean equalTo(int synthetic, SlackChannelRenameEvent another) {
        return this.type.equals((Object)another.type) && this.channel.equals(another.channel) && this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        return "SlackChannelRenameEvent{type=" + this.type + ", channel=" + this.channel + ", channelId=" + this.channelId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackChannelRenameEvent fromJson(Json json) {
        Builder builder = SlackChannelRenameEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        return builder.build();
    }

    public static SlackChannelRenameEvent copyOf(SlackChannelRenameEventIF instance) {
        if (instance instanceof SlackChannelRenameEvent) {
            return (SlackChannelRenameEvent)instance;
        }
        return SlackChannelRenameEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackChannelRenameEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private long initBits = 3L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private SlackChannel channel;

        private Builder() {
        }

        public final Builder from(SlackConversationEventCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackConversationEventWithChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackChannelRenameEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackConversationEventCore) {
                instance = (SlackConversationEventCore)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackConversationEventWithChannel) {
                instance = (SlackConversationEventWithChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannel(instance.getChannel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackChannelRenameEventIF) {
                instance = (SlackChannelRenameEventIF)object;
                if ((bits & 1L) == 0L) {
                    this.setChannel(instance.getChannel());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        public final Builder setChannel(SlackChannel channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackChannelRenameEvent build() {
            this.checkRequiredAttributes();
            return new SlackChannelRenameEvent(this.type, this.channel);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            return "Cannot build SlackChannelRenameEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackChannelRenameEventIF", generator="Immutables")
    static final class Json
    implements SlackChannelRenameEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        SlackChannel channel;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setChannel(SlackChannel channel) {
            this.channel = channel;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

