/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.channel.SlackChannelArchiveEventIF;
import com.hubspot.slack.client.models.events.conversation.SlackConversationEventCore;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackChannelArchiveEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackChannelArchiveEvent
implements SlackChannelArchiveEventIF {
    private final SlackEventType type;
    private final String channelId;
    private final String userId;

    private SlackChannelArchiveEvent(SlackEventType type, String channelId, String userId) {
        this.type = type;
        this.channelId = channelId;
        this.userId = userId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    public final SlackChannelArchiveEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackChannelArchiveEvent(newValue, this.channelId, this.userId);
    }

    public final SlackChannelArchiveEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackChannelArchiveEvent(this.type, newValue, this.userId);
    }

    public final SlackChannelArchiveEvent withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackChannelArchiveEvent(this.type, this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannelArchiveEvent && this.equalTo(0, (SlackChannelArchiveEvent)another);
    }

    private boolean equalTo(int synthetic, SlackChannelArchiveEvent another) {
        return this.type.equals((Object)another.type) && this.channelId.equals(another.channelId) && this.userId.equals(another.userId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.userId.hashCode();
        return h;
    }

    public String toString() {
        return "SlackChannelArchiveEvent{type=" + this.type + ", channelId=" + this.channelId + ", userId=" + this.userId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackChannelArchiveEvent fromJson(Json json) {
        Builder builder = SlackChannelArchiveEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        return builder.build();
    }

    public static SlackChannelArchiveEvent copyOf(SlackChannelArchiveEventIF instance) {
        if (instance instanceof SlackChannelArchiveEvent) {
            return (SlackChannelArchiveEvent)instance;
        }
        return SlackChannelArchiveEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackChannelArchiveEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_CHANNEL_ID = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String channelId;
        @Nullable
        private String userId;

        private Builder() {
        }

        public final Builder from(SlackConversationEventCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackChannelArchiveEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            SlackEvent instance;
            long bits = 0L;
            if (object instanceof SlackConversationEventCore) {
                instance = (SlackConversationEventCore)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackChannelArchiveEventIF) {
                instance = (SlackChannelArchiveEventIF)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                this.setUserId(instance.getUserId());
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SlackChannelArchiveEvent build() {
            this.checkRequiredAttributes();
            return new SlackChannelArchiveEvent(this.type, this.channelId, this.userId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            return "Cannot build SlackChannelArchiveEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackChannelArchiveEventIF", generator="Immutables")
    static final class Json
    implements SlackChannelArchiveEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String channelId;
        @Nullable
        String userId;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }
    }
}

