/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.bot;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.bot.SlackAppHomeOpenedEventIF;
import com.hubspot.slack.client.models.response.views.HomeTabViewResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackAppHomeOpenedEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackAppHomeOpenedEvent
implements SlackAppHomeOpenedEventIF {
    private final SlackEventType type;
    @Nullable
    private final String tab;
    @Nullable
    private final HomeTabViewResponse view;
    private final String userId;
    private final String channelId;

    private SlackAppHomeOpenedEvent(SlackEventType type, @Nullable String tab, @Nullable HomeTabViewResponse view, String userId, String channelId) {
        this.type = type;
        this.tab = tab;
        this.view = view;
        this.userId = userId;
        this.channelId = channelId;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getTab() {
        return Optional.ofNullable(this.tab);
    }

    @Override
    @JsonProperty
    public Optional<HomeTabViewResponse> getView() {
        return Optional.ofNullable(this.view);
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    public final SlackAppHomeOpenedEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(newValue, this.tab, this.view, this.userId, this.channelId);
    }

    public final SlackAppHomeOpenedEvent withTab(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.tab, newValue)) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(this.type, newValue, this.view, this.userId, this.channelId);
    }

    public final SlackAppHomeOpenedEvent withTab(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tab, value)) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(this.type, value, this.view, this.userId, this.channelId);
    }

    public final SlackAppHomeOpenedEvent withView(@Nullable HomeTabViewResponse value) {
        HomeTabViewResponse newValue = value;
        if (this.view == newValue) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(this.type, this.tab, newValue, this.userId, this.channelId);
    }

    public final SlackAppHomeOpenedEvent withView(Optional<? extends HomeTabViewResponse> optional) {
        HomeTabViewResponse value = optional.orElse(null);
        if (this.view == value) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(this.type, this.tab, value, this.userId, this.channelId);
    }

    public final SlackAppHomeOpenedEvent withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(this.type, this.tab, this.view, newValue, this.channelId);
    }

    public final SlackAppHomeOpenedEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackAppHomeOpenedEvent(this.type, this.tab, this.view, this.userId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackAppHomeOpenedEvent && this.equalTo(0, (SlackAppHomeOpenedEvent)another);
    }

    private boolean equalTo(int synthetic, SlackAppHomeOpenedEvent another) {
        return this.type.equals((Object)another.type) && Objects.equals(this.tab, another.tab) && Objects.equals(this.view, another.view) && this.userId.equals(another.userId) && this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.tab);
        h += (h << 5) + Objects.hashCode(this.view);
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackAppHomeOpenedEvent{");
        builder.append("type=").append((Object)this.type);
        if (this.tab != null) {
            builder.append(", ");
            builder.append("tab=").append(this.tab);
        }
        if (this.view != null) {
            builder.append(", ");
            builder.append("view=").append(this.view);
        }
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackAppHomeOpenedEvent fromJson(Json json) {
        Builder builder = SlackAppHomeOpenedEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.tab != null) {
            builder.setTab(json.tab);
        }
        if (json.view != null) {
            builder.setView(json.view);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        return builder.build();
    }

    public static SlackAppHomeOpenedEvent copyOf(SlackAppHomeOpenedEventIF instance) {
        if (instance instanceof SlackAppHomeOpenedEvent) {
            return (SlackAppHomeOpenedEvent)instance;
        }
        return SlackAppHomeOpenedEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackAppHomeOpenedEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String tab;
        @Nullable
        private HomeTabViewResponse view;
        @Nullable
        private String userId;
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackAppHomeOpenedEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackAppHomeOpenedEventIF) {
                Optional<String> tabOptional;
                instance = (SlackAppHomeOpenedEventIF)object;
                Optional<HomeTabViewResponse> viewOptional = instance.getView();
                if (viewOptional.isPresent()) {
                    this.setView(viewOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                if ((tabOptional = instance.getTab()).isPresent()) {
                    this.setTab(tabOptional);
                }
                if ((bits & 2L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 2L;
                }
                this.setChannelId(instance.getChannelId());
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 2L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTab(@Nullable String tab) {
            this.tab = tab;
            return this;
        }

        @JsonProperty
        public final Builder setTab(Optional<String> tab) {
            this.tab = tab.orElse(null);
            return this;
        }

        public final Builder setView(@Nullable HomeTabViewResponse view) {
            this.view = view;
            return this;
        }

        @JsonProperty
        public final Builder setView(Optional<? extends HomeTabViewResponse> view) {
            this.view = view.orElse(null);
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public SlackAppHomeOpenedEvent build() {
            this.checkRequiredAttributes();
            return new SlackAppHomeOpenedEvent(this.type, this.tab, this.view, this.userId, this.channelId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build SlackAppHomeOpenedEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackAppHomeOpenedEventIF", generator="Immutables")
    static final class Json
    implements SlackAppHomeOpenedEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        Optional<String> tab = Optional.empty();
        @Nullable
        Optional<HomeTabViewResponse> view = Optional.empty();
        @Nullable
        String userId;
        @Nullable
        String channelId;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTab(Optional<String> tab) {
            this.tab = tab;
        }

        @JsonProperty
        public void setView(Optional<HomeTabViewResponse> view) {
            this.view = view;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTab() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<HomeTabViewResponse> getView() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

