/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.hubspot.slack.client.enums.EnumIndex;
import com.hubspot.slack.client.models.events.SlackEventBotMessage;
import com.hubspot.slack.client.models.events.SlackEventMessage;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventMessageChanged;
import com.hubspot.slack.client.models.events.SlackEventMessageDeleted;
import com.hubspot.slack.client.models.events.SlackEventMessageReplied;

public enum SlackMessageSubtype {
    CHANNEL_JOIN,
    BOT_MESSAGE(SlackEventBotMessage.class),
    FILE_SHARE,
    ME_MESSAGE,
    MESSAGE_CHANGED(SlackEventMessageChanged.class),
    MESSAGE_DELETED(SlackEventMessageDeleted.class),
    MESSAGE_REPLIED(SlackEventMessageReplied.class),
    THREAD_BROADCAST,
    REPLY_BROADCAST,
    UNKNOWN(SlackEventMessage.class);

    private final Class<? extends SlackEventMessageBase> messageClass;
    private static final EnumIndex<String, SlackMessageSubtype> INDEX;

    private SlackMessageSubtype(Class<? extends SlackEventMessageBase> messageClass) {
        this.messageClass = messageClass;
    }

    private SlackMessageSubtype() {
        this(SlackEventMessage.class);
    }

    @JsonCreator
    public static SlackMessageSubtype get(String key) {
        return INDEX.find(key).orElse(UNKNOWN);
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    public Class<? extends SlackEventMessageBase> getMessageClass() {
        return this.messageClass;
    }

    static {
        INDEX = new EnumIndex<String, SlackMessageSubtype>(SlackMessageSubtype.class, SlackMessageSubtype::toString);
    }
}

