/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.events.AbstractSlackEventMessageChanged;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractSlackEventMessageChanged", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackEventMessageChanged
extends AbstractSlackEventMessageChanged {
    private final SlackEventType type;
    private final String ts;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final List<Attachment> attachments;
    private final String channelId;
    private final boolean hidden;
    private final LiteMessage message;
    @Nullable
    private final LiteMessage previousMessage;
    private final String eventTs;

    private SlackEventMessageChanged(SlackEventType type, String ts, @Nullable SlackMessageSubtype subtype, List<Attachment> attachments, String channelId, boolean hidden, LiteMessage message, @Nullable LiteMessage previousMessage, String eventTs) {
        this.type = type;
        this.ts = ts;
        this.subtype = subtype;
        this.attachments = attachments;
        this.channelId = channelId;
        this.hidden = hidden;
        this.message = message;
        this.previousMessage = previousMessage;
        this.eventTs = eventTs;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    @JsonProperty
    public LiteMessage getMessage() {
        return this.message;
    }

    @Override
    @JsonProperty
    public Optional<LiteMessage> getPreviousMessage() {
        return Optional.ofNullable(this.previousMessage);
    }

    @Override
    @JsonProperty
    public String getEventTs() {
        return this.eventTs;
    }

    public final SlackEventMessageChanged withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackEventMessageChanged(newValue, this.ts, this.subtype, this.attachments, this.channelId, this.hidden, this.message, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withTs(String value) {
        String newValue = Objects.requireNonNull(value, "ts");
        if (this.ts.equals(newValue)) {
            return this;
        }
        return new SlackEventMessageChanged(this.type, newValue, this.subtype, this.attachments, this.channelId, this.hidden, this.message, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (this.subtype == newValue) {
            return this;
        }
        return new SlackEventMessageChanged(this.type, this.ts, newValue, this.attachments, this.channelId, this.hidden, this.message, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withSubtype(Optional<? extends SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (this.subtype == value) {
            return this;
        }
        return new SlackEventMessageChanged(this.type, this.ts, value, this.attachments, this.channelId, this.hidden, this.message, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withAttachments(Attachment ... elements) {
        List<Attachment> newValue = SlackEventMessageChanged.createUnmodifiableList(false, SlackEventMessageChanged.createSafeList(Arrays.asList(elements), true, false));
        return new SlackEventMessageChanged(this.type, this.ts, this.subtype, newValue, this.channelId, this.hidden, this.message, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = SlackEventMessageChanged.createUnmodifiableList(false, SlackEventMessageChanged.createSafeList(elements, true, false));
        return new SlackEventMessageChanged(this.type, this.ts, this.subtype, newValue, this.channelId, this.hidden, this.message, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackEventMessageChanged(this.type, this.ts, this.subtype, this.attachments, newValue, this.hidden, this.message, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withHidden(boolean value) {
        if (this.hidden == value) {
            return this;
        }
        return new SlackEventMessageChanged(this.type, this.ts, this.subtype, this.attachments, this.channelId, value, this.message, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withMessage(LiteMessage value) {
        if (this.message == value) {
            return this;
        }
        LiteMessage newValue = Objects.requireNonNull(value, "message");
        return new SlackEventMessageChanged(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.hidden, newValue, this.previousMessage, this.eventTs);
    }

    public final SlackEventMessageChanged withPreviousMessage(@Nullable LiteMessage value) {
        LiteMessage newValue = value;
        if (this.previousMessage == newValue) {
            return this;
        }
        return new SlackEventMessageChanged(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.hidden, this.message, newValue, this.eventTs);
    }

    public final SlackEventMessageChanged withPreviousMessage(Optional<? extends LiteMessage> optional) {
        LiteMessage value = optional.orElse(null);
        if (this.previousMessage == value) {
            return this;
        }
        return new SlackEventMessageChanged(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.hidden, this.message, value, this.eventTs);
    }

    public final SlackEventMessageChanged withEventTs(String value) {
        String newValue = Objects.requireNonNull(value, "eventTs");
        if (this.eventTs.equals(newValue)) {
            return this;
        }
        return new SlackEventMessageChanged(this.type, this.ts, this.subtype, this.attachments, this.channelId, this.hidden, this.message, this.previousMessage, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventMessageChanged && this.equalTo(0, (SlackEventMessageChanged)another);
    }

    private boolean equalTo(int synthetic, SlackEventMessageChanged another) {
        return this.type.equals((Object)another.type) && this.ts.equals(another.ts) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.attachments.equals(another.attachments) && this.channelId.equals(another.channelId) && this.hidden == another.hidden && this.message.equals(another.message) && Objects.equals(this.previousMessage, another.previousMessage) && this.eventTs.equals(another.eventTs);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.ts.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.subtype);
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.hidden);
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Objects.hashCode(this.previousMessage);
        h += (h << 5) + this.eventTs.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventMessageChanged{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("hidden=").append(this.hidden);
        builder.append(", ");
        builder.append("message=").append(this.message);
        if (this.previousMessage != null) {
            builder.append(", ");
            builder.append("previousMessage=").append(this.previousMessage);
        }
        builder.append(", ");
        builder.append("eventTs=").append(this.eventTs);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackEventMessageChanged fromJson(Json json) {
        Builder builder = SlackEventMessageChanged.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.hiddenIsSet) {
            builder.setHidden(json.hidden);
        }
        if (json.message != null) {
            builder.setMessage(json.message);
        }
        if (json.previousMessage != null) {
            builder.setPreviousMessage(json.previousMessage);
        }
        if (json.eventTs != null) {
            builder.setEventTs(json.eventTs);
        }
        return builder.build();
    }

    public static SlackEventMessageChanged copyOf(AbstractSlackEventMessageChanged instance) {
        if (instance instanceof SlackEventMessageChanged) {
            return (SlackEventMessageChanged)instance;
        }
        return SlackEventMessageChanged.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractSlackEventMessageChanged", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TS = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_HIDDEN = 8L;
        private static final long INIT_BIT_MESSAGE = 16L;
        private static final long INIT_BIT_EVENT_TS = 32L;
        private long initBits = 63L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;
        @Nullable
        private SlackMessageSubtype subtype;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        @Nullable
        private String channelId;
        private boolean hidden;
        @Nullable
        private LiteMessage message;
        @Nullable
        private LiteMessage previousMessage;
        @Nullable
        private String eventTs;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractSlackEventMessageChanged instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
            if (object instanceof AbstractSlackEventMessageChanged) {
                instance = (AbstractSlackEventMessageChanged)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                this.setHidden(((AbstractSlackEventMessageChanged)instance).isHidden());
                if ((bits & 4L) == 0L) {
                    subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                this.setMessage(((AbstractSlackEventMessageChanged)instance).getMessage());
                Optional<LiteMessage> previousMessageOptional = ((AbstractSlackEventMessageChanged)instance).getPreviousMessage();
                if (previousMessageOptional.isPresent()) {
                    this.setPreviousMessage(previousMessageOptional);
                }
                this.setEventTs(((AbstractSlackEventMessageChanged)instance).getEventTs());
                if ((bits & 8L) == 0L) {
                    this.setChannelId(((AbstractSlackEventMessageChanged)instance).getChannelId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
            if (object instanceof SlackEventMessageBase) {
                instance = (SlackEventMessageBase)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty
        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        @JsonProperty
        public final Builder setSubtype(Optional<? extends SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        @JsonProperty
        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        public final Builder setHidden(boolean hidden) {
            this.hidden = hidden;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        public final Builder setMessage(LiteMessage message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setPreviousMessage(@Nullable LiteMessage previousMessage) {
            this.previousMessage = previousMessage;
            return this;
        }

        @JsonProperty
        public final Builder setPreviousMessage(Optional<? extends LiteMessage> previousMessage) {
            this.previousMessage = previousMessage.orElse(null);
            return this;
        }

        @JsonProperty
        public final Builder setEventTs(String eventTs) {
            this.eventTs = Objects.requireNonNull(eventTs, "eventTs");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public SlackEventMessageChanged build() {
            this.checkRequiredAttributes();
            return new SlackEventMessageChanged(this.type, this.ts, this.subtype, SlackEventMessageChanged.createUnmodifiableList(true, this.attachments), this.channelId, this.hidden, this.message, this.previousMessage, this.eventTs);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean hiddenIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean messageIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean eventTsIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.hiddenIsSet()) {
                attributes.add("hidden");
            }
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            if (!this.eventTsIsSet()) {
                attributes.add("eventTs");
            }
            return "Cannot build SlackEventMessageChanged, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractSlackEventMessageChanged", generator="Immutables")
    static final class Json
    extends AbstractSlackEventMessageChanged {
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;
        @Nullable
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        String channelId;
        boolean hidden;
        boolean hiddenIsSet;
        @Nullable
        LiteMessage message;
        @Nullable
        Optional<LiteMessage> previousMessage = Optional.empty();
        @Nullable
        String eventTs;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setHidden(boolean hidden) {
            this.hidden = hidden;
            this.hiddenIsSet = true;
        }

        @JsonProperty
        public void setMessage(LiteMessage message) {
            this.message = message;
        }

        @JsonProperty
        public void setPreviousMessage(Optional<LiteMessage> previousMessage) {
            this.previousMessage = previousMessage;
        }

        @JsonProperty
        public void setEventTs(String eventTs) {
            this.eventTs = eventTs;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isHidden() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LiteMessage getMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LiteMessage> getPreviousMessage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getEventTs() {
            throw new UnsupportedOperationException();
        }
    }
}

