/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.ChallengeEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChallengeEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChallengeEvent
implements ChallengeEventIF {
    private final String token;
    private final String challenge;
    private final String type;

    private ChallengeEvent(String token, String challenge, String type) {
        this.token = token;
        this.challenge = challenge;
        this.type = type;
    }

    @Override
    @JsonProperty
    public String getToken() {
        return this.token;
    }

    @Override
    @JsonProperty
    public String getChallenge() {
        return this.challenge;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    public final ChallengeEvent withToken(String value) {
        String newValue = Objects.requireNonNull(value, "token");
        if (this.token.equals(newValue)) {
            return this;
        }
        return new ChallengeEvent(newValue, this.challenge, this.type);
    }

    public final ChallengeEvent withChallenge(String value) {
        String newValue = Objects.requireNonNull(value, "challenge");
        if (this.challenge.equals(newValue)) {
            return this;
        }
        return new ChallengeEvent(this.token, newValue, this.type);
    }

    public final ChallengeEvent withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new ChallengeEvent(this.token, this.challenge, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChallengeEvent && this.equalTo(0, (ChallengeEvent)another);
    }

    private boolean equalTo(int synthetic, ChallengeEvent another) {
        return this.token.equals(another.token) && this.challenge.equals(another.challenge) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        h += (h << 5) + this.challenge.hashCode();
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        return "ChallengeEvent{token=" + this.token + ", challenge=" + this.challenge + ", type=" + this.type + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChallengeEvent fromJson(Json json) {
        Builder builder = ChallengeEvent.builder();
        if (json.token != null) {
            builder.setToken(json.token);
        }
        if (json.challenge != null) {
            builder.setChallenge(json.challenge);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    public static ChallengeEvent copyOf(ChallengeEventIF instance) {
        if (instance instanceof ChallengeEvent) {
            return (ChallengeEvent)instance;
        }
        return ChallengeEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChallengeEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private static final long INIT_BIT_CHALLENGE = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private String token;
        @Nullable
        private String challenge;
        @Nullable
        private String type;

        private Builder() {
        }

        public final Builder from(ChallengeEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setToken(instance.getToken());
            this.setChallenge(instance.getChallenge());
            this.setType(instance.getType());
            return this;
        }

        public final Builder setToken(String token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChallenge(String challenge) {
            this.challenge = Objects.requireNonNull(challenge, "challenge");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setType(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ChallengeEvent build() {
            this.checkRequiredAttributes();
            return new ChallengeEvent(this.token, this.challenge, this.type);
        }

        private boolean tokenIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean challengeIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.tokenIsSet()) {
                attributes.add("token");
            }
            if (!this.challengeIsSet()) {
                attributes.add("challenge");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build ChallengeEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChallengeEventIF", generator="Immutables")
    static final class Json
    implements ChallengeEventIF {
        @Nullable
        String token;
        @Nullable
        String challenge;
        @Nullable
        String type;

        Json() {
        }

        @JsonProperty
        public void setToken(String token) {
            this.token = token;
        }

        @JsonProperty
        public void setChallenge(String challenge) {
            this.challenge = challenge;
        }

        @JsonProperty
        public void setType(String type) {
            this.type = type;
        }

        @Override
        public String getToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChallenge() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }
    }
}

