/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementSubtypes;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackDialogFormTextElement;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormTextElement;
import com.hubspot.slack.client.models.dialog.form.elements.HasLabel;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractSlackFormTextElement", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackFormTextElement
extends AbstractSlackFormTextElement {
    private final String label;
    private final String name;
    @Nullable
    private final String placeholder;
    @Nullable
    private final Boolean optional;
    @Nullable
    private final SlackFormElementSubtypes subtype;
    @Nullable
    private final String hint;
    private final int minLength;
    private final int maxLength;
    @Nullable
    private final String value;
    private final SlackFormElementTypes type;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private SlackFormTextElement(Builder builder) {
        this.label = builder.label;
        this.name = builder.name;
        this.placeholder = builder.placeholder;
        this.optional = builder.optional;
        this.subtype = builder.subtype;
        this.hint = builder.hint;
        this.value = builder.value;
        if (builder.minLengthIsSet()) {
            this.initShim.setMinLength(builder.minLength);
        }
        if (builder.maxLengthIsSet()) {
            this.initShim.setMaxLength(builder.maxLength);
        }
        if (builder.type != null) {
            this.initShim.setType(builder.type);
        }
        this.minLength = this.initShim.getMinLength();
        this.maxLength = this.initShim.getMaxLength();
        this.type = this.initShim.getType();
        this.initShim = null;
    }

    private SlackFormTextElement(String label, String name, @Nullable String placeholder, @Nullable Boolean optional, @Nullable SlackFormElementSubtypes subtype, @Nullable String hint, int minLength, int maxLength, @Nullable String value, SlackFormElementTypes type) {
        this.label = label;
        this.name = name;
        this.placeholder = placeholder;
        this.optional = optional;
        this.subtype = subtype;
        this.hint = hint;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.value = value;
        this.type = type;
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public String getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<String> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty(value="optional")
    public Optional<Boolean> isOptional() {
        return Optional.ofNullable(this.optional);
    }

    @Override
    @JsonProperty
    public Optional<SlackFormElementSubtypes> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public Optional<String> getHint() {
        return Optional.ofNullable(this.hint);
    }

    @Override
    @JsonProperty
    public int getMinLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinLength() : this.minLength;
    }

    @Override
    @JsonProperty
    public int getMaxLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMaxLength() : this.maxLength;
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty
    public SlackFormElementTypes getType() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getType() : this.type;
    }

    public final SlackFormTextElement withLabel(String value) {
        String newValue = Objects.requireNonNull(value, "label");
        if (this.label.equals(newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(newValue, this.name, this.placeholder, this.optional, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, newValue, this.placeholder, this.optional, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withPlaceholder(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.placeholder, newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, newValue, this.optional, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withPlaceholder(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.placeholder, value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, value, this.optional, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withOptional(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.optional, newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, newValue, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withOptional(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.optional, value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, value, this.subtype, this.hint, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withSubtype(@Nullable SlackFormElementSubtypes value) {
        SlackFormElementSubtypes newValue = value;
        if (this.subtype == newValue) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, newValue, this.hint, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withSubtype(Optional<? extends SlackFormElementSubtypes> optional) {
        SlackFormElementSubtypes value = optional.orElse(null);
        if (this.subtype == value) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, value, this.hint, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withHint(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.hint, newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, this.subtype, newValue, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withHint(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.hint, value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, this.subtype, value, this.minLength, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withMinLength(int value) {
        if (this.minLength == value) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, this.subtype, this.hint, value, this.maxLength, this.value, this.type));
    }

    public final SlackFormTextElement withMaxLength(int value) {
        if (this.maxLength == value) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, this.subtype, this.hint, this.minLength, value, this.value, this.type));
    }

    public final SlackFormTextElement withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, this.subtype, this.hint, this.minLength, this.maxLength, newValue, this.type));
    }

    public final SlackFormTextElement withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, this.subtype, this.hint, this.minLength, this.maxLength, value, this.type));
    }

    public final SlackFormTextElement withType(SlackFormElementTypes value) {
        SlackFormElementTypes newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return SlackFormTextElement.validate(new SlackFormTextElement(this.label, this.name, this.placeholder, this.optional, this.subtype, this.hint, this.minLength, this.maxLength, this.value, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackFormTextElement && this.equalTo(0, (SlackFormTextElement)another);
    }

    private boolean equalTo(int synthetic, SlackFormTextElement another) {
        return this.label.equals(another.label) && this.name.equals(another.name) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.optional, another.optional) && Objects.equals((Object)this.subtype, (Object)another.subtype) && Objects.equals(this.hint, another.hint) && this.minLength == another.minLength && this.maxLength == another.maxLength && Objects.equals(this.value, another.value) && this.type.equals((Object)another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholder);
        h += (h << 5) + Objects.hashCode(this.optional);
        h += (h << 5) + Objects.hashCode((Object)this.subtype);
        h += (h << 5) + Objects.hashCode(this.hint);
        h += (h << 5) + this.minLength;
        h += (h << 5) + this.maxLength;
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackFormTextElement{");
        builder.append("label=").append(this.label);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.optional != null) {
            builder.append(", ");
            builder.append("optional=").append(this.optional);
        }
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        if (this.hint != null) {
            builder.append(", ");
            builder.append("hint=").append(this.hint);
        }
        builder.append(", ");
        builder.append("minLength=").append(this.minLength);
        builder.append(", ");
        builder.append("maxLength=").append(this.maxLength);
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackFormTextElement fromJson(Json json) {
        Builder builder = SlackFormTextElement.builder();
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.optional != null) {
            builder.setOptional(json.optional);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.hint != null) {
            builder.setHint(json.hint);
        }
        if (json.minLengthIsSet) {
            builder.setMinLength(json.minLength);
        }
        if (json.maxLengthIsSet) {
            builder.setMaxLength(json.maxLength);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        return builder.build();
    }

    private static SlackFormTextElement validate(SlackFormTextElement instance) {
        instance = (SlackFormTextElement)instance.validate();
        return instance;
    }

    public static SlackFormTextElement copyOf(AbstractSlackFormTextElement instance) {
        if (instance instanceof SlackFormTextElement) {
            return (SlackFormTextElement)instance;
        }
        return SlackFormTextElement.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractSlackFormTextElement", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long OPT_BIT_MIN_LENGTH = 1L;
        private static final long OPT_BIT_MAX_LENGTH = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String label;
        @Nullable
        private String name;
        @Nullable
        private String placeholder;
        @Nullable
        private Boolean optional;
        @Nullable
        private SlackFormElementSubtypes subtype;
        @Nullable
        private String hint;
        private int minLength;
        private int maxLength;
        @Nullable
        private String value;
        @Nullable
        private SlackFormElementTypes type;

        private Builder() {
        }

        public final Builder from(HasLabel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackDialogFormElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractSlackFormTextElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractSlackDialogFormTextElement instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> valueOptional;
            Optional<String> hintOptional;
            Optional<SlackFormElementSubtypes> subtypeOptional;
            Optional<String> placeholderOptional;
            Optional<Boolean> optionalOptional;
            HasLabel instance;
            long bits = 0L;
            if (object instanceof HasLabel) {
                instance = (HasLabel)object;
                if ((bits & 4L) == 0L) {
                    this.setLabel(instance.getLabel());
                    bits |= 4L;
                }
            }
            if (object instanceof SlackDialogFormElement) {
                instance = (SlackDialogFormElement)object;
                if ((bits & 0x40L) == 0L) {
                    this.setName(((SlackDialogFormElement)instance).getName());
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    optionalOptional = ((SlackDialogFormElement)instance).isOptional();
                    if (optionalOptional.isPresent()) {
                        this.setOptional(optionalOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setLabel(instance.getLabel());
                    bits |= 4L;
                }
                if ((bits & 0x80L) == 0L) {
                    placeholderOptional = ((SlackDialogFormElement)instance).getPlaceholder();
                    if (placeholderOptional.isPresent()) {
                        this.setPlaceholder(placeholderOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 8L) == 0L) {
                    this.setType(((SlackDialogFormElement)instance).getType());
                    bits |= 8L;
                }
            }
            if (object instanceof AbstractSlackFormTextElement) {
                instance = (AbstractSlackFormTextElement)object;
                if ((bits & 0x10L) == 0L) {
                    subtypeOptional = ((AbstractSlackDialogFormTextElement)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.setMinLength(((AbstractSlackDialogFormTextElement)instance).getMinLength());
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    hintOptional = ((AbstractSlackDialogFormTextElement)instance).getHint();
                    if (hintOptional.isPresent()) {
                        this.setHint(hintOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.setName(((SlackDialogFormElement)instance).getName());
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    optionalOptional = ((SlackDialogFormElement)instance).isOptional();
                    if (optionalOptional.isPresent()) {
                        this.setOptional(optionalOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 0x80L) == 0L) {
                    placeholderOptional = ((SlackDialogFormElement)instance).getPlaceholder();
                    if (placeholderOptional.isPresent()) {
                        this.setPlaceholder(placeholderOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 8L) == 0L) {
                    this.setType(((AbstractSlackFormTextElement)instance).getType());
                    bits |= 8L;
                }
                if ((bits & 0x100L) == 0L) {
                    valueOptional = ((AbstractSlackDialogFormTextElement)instance).getValue();
                    if (valueOptional.isPresent()) {
                        this.setValue(valueOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.setMaxLength(((AbstractSlackDialogFormTextElement)instance).getMaxLength());
                    bits |= 0x200L;
                }
            }
            if (object instanceof AbstractSlackDialogFormTextElement) {
                instance = (AbstractSlackDialogFormTextElement)object;
                if ((bits & 0x10L) == 0L) {
                    subtypeOptional = ((AbstractSlackDialogFormTextElement)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 1L) == 0L) {
                    this.setMinLength(((AbstractSlackDialogFormTextElement)instance).getMinLength());
                    bits |= 1L;
                }
                if ((bits & 0x20L) == 0L) {
                    hintOptional = ((AbstractSlackDialogFormTextElement)instance).getHint();
                    if (hintOptional.isPresent()) {
                        this.setHint(hintOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.setName(((SlackDialogFormElement)instance).getName());
                    bits |= 0x40L;
                }
                if ((bits & 2L) == 0L) {
                    optionalOptional = ((SlackDialogFormElement)instance).isOptional();
                    if (optionalOptional.isPresent()) {
                        this.setOptional(optionalOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.setLabel(instance.getLabel());
                    bits |= 4L;
                }
                if ((bits & 0x80L) == 0L) {
                    placeholderOptional = ((SlackDialogFormElement)instance).getPlaceholder();
                    if (placeholderOptional.isPresent()) {
                        this.setPlaceholder(placeholderOptional);
                    }
                    bits |= 0x80L;
                }
                if ((bits & 8L) == 0L) {
                    this.setType(((SlackDialogFormElement)instance).getType());
                    bits |= 8L;
                }
                if ((bits & 0x100L) == 0L) {
                    valueOptional = ((AbstractSlackDialogFormTextElement)instance).getValue();
                    if (valueOptional.isPresent()) {
                        this.setValue(valueOptional);
                    }
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.setMaxLength(((AbstractSlackDialogFormTextElement)instance).getMaxLength());
                    bits |= 0x200L;
                }
            }
        }

        public final Builder setLabel(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable String placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<String> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setOptional(@Nullable Boolean optional) {
            this.optional = optional;
            return this;
        }

        public final Builder setOptional(Optional<Boolean> optional) {
            this.optional = optional.orElse(null);
            return this;
        }

        public final Builder setSubtype(@Nullable SlackFormElementSubtypes subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<? extends SlackFormElementSubtypes> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setHint(@Nullable String hint) {
            this.hint = hint;
            return this;
        }

        public final Builder setHint(Optional<String> hint) {
            this.hint = hint.orElse(null);
            return this;
        }

        public final Builder setMinLength(int minLength) {
            this.minLength = minLength;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder setType(SlackFormElementTypes type) {
            this.type = Objects.requireNonNull(type, "type");
            return this;
        }

        public SlackFormTextElement build() {
            this.checkRequiredAttributes();
            return SlackFormTextElement.validate(new SlackFormTextElement(this));
        }

        private boolean minLengthIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean maxLengthIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean labelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build SlackFormTextElement, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractSlackFormTextElement", generator="Immutables")
    static final class Json
    extends AbstractSlackFormTextElement {
        @Nullable
        String label;
        @Nullable
        String name;
        @Nullable
        Optional<String> placeholder = Optional.empty();
        @Nullable
        Optional<Boolean> optional = Optional.empty();
        @Nullable
        Optional<SlackFormElementSubtypes> subtype = Optional.empty();
        @Nullable
        Optional<String> hint = Optional.empty();
        int minLength;
        boolean minLengthIsSet;
        int maxLength;
        boolean maxLengthIsSet;
        @Nullable
        Optional<String> value = Optional.empty();
        @Nullable
        SlackFormElementTypes type;

        Json() {
        }

        @JsonProperty
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setPlaceholder(Optional<String> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty(value="optional")
        public void setOptional(Optional<Boolean> optional) {
            this.optional = optional;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackFormElementSubtypes> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setHint(Optional<String> hint) {
            this.hint = hint;
        }

        @JsonProperty
        public void setMinLength(int minLength) {
            this.minLength = minLength;
            this.minLengthIsSet = true;
        }

        @JsonProperty
        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            this.maxLengthIsSet = true;
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty
        public void setType(SlackFormElementTypes type) {
            this.type = type;
        }

        @Override
        public String getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isOptional() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackFormElementSubtypes> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHint() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMinLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMaxLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackFormElementTypes getType() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AbstractSlackFormTextElement", generator="Immutables")
    private final class InitShim {
        private byte minLengthBuildStage = 0;
        private int minLength;
        private byte maxLengthBuildStage = 0;
        private int maxLength;
        private byte typeBuildStage = 0;
        private SlackFormElementTypes type;

        private InitShim() {
        }

        int getMinLength() {
            if (this.minLengthBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.minLengthBuildStage == 0) {
                this.minLengthBuildStage = (byte)-1;
                this.minLength = SlackFormTextElement.super.getMinLength();
                this.minLengthBuildStage = 1;
            }
            return this.minLength;
        }

        void setMinLength(int minLength) {
            this.minLength = minLength;
            this.minLengthBuildStage = 1;
        }

        int getMaxLength() {
            if (this.maxLengthBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.maxLengthBuildStage == 0) {
                this.maxLengthBuildStage = (byte)-1;
                this.maxLength = SlackFormTextElement.super.getMaxLength();
                this.maxLengthBuildStage = 1;
            }
            return this.maxLength;
        }

        void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
            this.maxLengthBuildStage = 1;
        }

        SlackFormElementTypes getType() {
            if (this.typeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.typeBuildStage == 0) {
                this.typeBuildStage = (byte)-1;
                this.type = Objects.requireNonNull(SlackFormTextElement.super.getType(), "type");
                this.typeBuildStage = 1;
            }
            return this.type;
        }

        void setType(SlackFormElementTypes type) {
            this.type = type;
            this.typeBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.minLengthBuildStage == -1) {
                attributes.add("minLength");
            }
            if (this.maxLengthBuildStage == -1) {
                attributes.add("maxLength");
            }
            if (this.typeBuildStage == -1) {
                attributes.add("type");
            }
            return "Cannot build SlackFormTextElement, attribute initializers form cycle " + attributes;
        }
    }
}

