/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.actions.SlackDataSource;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import com.hubspot.slack.client.models.dialog.form.elements.HasOptions;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElementLengthLimits;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOption;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionGroup;
import com.hubspot.slack.client.models.dialog.form.elements.helpers.SlackDialogElementNormalizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@HubSpotStyle
public abstract class AbstractSlackFormSelectElement
extends SlackDialogFormElement
implements HasOptions {
    @Override
    @Value.Default
    public SlackFormElementTypes getType() {
        return SlackFormElementTypes.SELECT;
    }

    @Value.Default
    public SlackDataSource getDataSource() {
        return SlackDataSource.STATIC;
    }

    public abstract List<SlackFormOptionGroup> getOptionGroups();

    public abstract Optional<String> getValue();

    public abstract List<SlackFormOption> getSelectedOptions();

    public abstract Optional<Integer> getMinQueryLength();

    @Value.Check
    public AbstractSlackFormSelectElement validate() {
        List<SlackFormOption> normalizedSelectedOptions;
        boolean valueIsSomeOptionValue;
        Optional<String> normalizedValue;
        int maxOptionGroupsNumber;
        AbstractSlackFormSelectElement normalized = SlackDialogElementNormalizer.normalize(this);
        super.validateBaseElementProperties(normalized);
        ArrayList<String> errors = new ArrayList<String>();
        List<SlackFormOption> normalizedOptions = normalized.getOptions();
        int numOptions = normalizedOptions.size();
        List<SlackFormOptionGroup> normalizedOptionGroups = normalized.getOptionGroups();
        int numOptionGroups = normalizedOptionGroups.size();
        int maxOptionsNumber = SlackDialogFormElementLengthLimits.MAX_OPTIONS_NUMBER.getLimit();
        if (numOptions > maxOptionsNumber) {
            errors.add(String.format("Cannot have more than %s options", maxOptionsNumber));
        }
        if (numOptionGroups > (maxOptionGroupsNumber = SlackDialogFormElementLengthLimits.MAX_OPTION_GROUPS_NUMBER.getLimit())) {
            errors.add(String.format("Cannot have more than %s option groups", maxOptionGroupsNumber));
        }
        if (normalized.getDataSource().equals((Object)SlackDataSource.STATIC) && numOptions == 0 && numOptionGroups == 0) {
            errors.add("Either options or option groups are required for static data source types");
        }
        if ((normalizedValue = normalized.getValue()).isPresent() && normalized.getDataSource().equals((Object)SlackDataSource.EXTERNAL)) {
            errors.add("Cannot use value for external data source, must use selected options");
        }
        if (normalizedValue.isPresent() && !(valueIsSomeOptionValue = this.getOptions().stream().anyMatch(option -> option.getValue().equalsIgnoreCase((String)normalizedValue.get())))) {
            errors.add("Value must exactly match the value field for one provided option");
        }
        if (!(normalizedSelectedOptions = normalized.getSelectedOptions()).isEmpty()) {
            boolean selectedOptionIsInOptions;
            if (normalizedSelectedOptions.size() != 1) {
                errors.add("Selected options must be a single element array");
            }
            if (!normalizedOptionGroups.isEmpty()) {
                boolean selectedOptionIsInOptionsGroup = normalizedOptionGroups.stream().map(SlackFormOptionGroup::getOptions).collect(Collectors.toList()).stream().flatMap(Collection::stream).anyMatch(option -> option.equals(normalizedSelectedOptions.get(0)));
                if (!selectedOptionIsInOptionsGroup) {
                    errors.add("Selected option must exactly match an option in the provided options groups");
                }
            } else if (!normalizedOptions.isEmpty() && !(selectedOptionIsInOptions = normalizedOptions.stream().anyMatch(option -> option.equals(normalizedSelectedOptions.get(0))))) {
                errors.add("Selected option must exactly match an option in the provided options");
            }
        }
        if (!errors.isEmpty()) {
            throw new IllegalStateException(((Object)errors).toString());
        }
        return normalized;
    }
}

