/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.channel.ImChannelIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ImChannelIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ImChannel
implements ImChannelIF {
    private final String id;
    private final int created;
    private final boolean isIm;
    private final boolean isOrgShared;
    private final String user;
    private final boolean isOpen;

    private ImChannel(String id, int created, boolean isIm, boolean isOrgShared, String user, boolean isOpen) {
        this.id = id;
        this.created = created;
        this.isIm = isIm;
        this.isOrgShared = isOrgShared;
        this.user = user;
        this.isOpen = isOpen;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public int getCreated() {
        return this.created;
    }

    @Override
    @JsonProperty
    public boolean getIsIm() {
        return this.isIm;
    }

    @Override
    @JsonProperty
    public boolean getIsOrgShared() {
        return this.isOrgShared;
    }

    @Override
    @JsonProperty
    public String getUser() {
        return this.user;
    }

    @Override
    @JsonProperty
    public boolean getIsOpen() {
        return this.isOpen;
    }

    public final ImChannel withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImChannel(newValue, this.created, this.isIm, this.isOrgShared, this.user, this.isOpen);
    }

    public final ImChannel withCreated(int value) {
        if (this.created == value) {
            return this;
        }
        return new ImChannel(this.id, value, this.isIm, this.isOrgShared, this.user, this.isOpen);
    }

    public final ImChannel withIsIm(boolean value) {
        if (this.isIm == value) {
            return this;
        }
        return new ImChannel(this.id, this.created, value, this.isOrgShared, this.user, this.isOpen);
    }

    public final ImChannel withIsOrgShared(boolean value) {
        if (this.isOrgShared == value) {
            return this;
        }
        return new ImChannel(this.id, this.created, this.isIm, value, this.user, this.isOpen);
    }

    public final ImChannel withUser(String value) {
        String newValue = Objects.requireNonNull(value, "user");
        if (this.user.equals(newValue)) {
            return this;
        }
        return new ImChannel(this.id, this.created, this.isIm, this.isOrgShared, newValue, this.isOpen);
    }

    public final ImChannel withIsOpen(boolean value) {
        if (this.isOpen == value) {
            return this;
        }
        return new ImChannel(this.id, this.created, this.isIm, this.isOrgShared, this.user, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImChannel && this.equalTo(0, (ImChannel)another);
    }

    private boolean equalTo(int synthetic, ImChannel another) {
        return this.id.equals(another.id) && this.created == another.created && this.isIm == another.isIm && this.isOrgShared == another.isOrgShared && this.user.equals(another.user) && this.isOpen == another.isOpen;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.created;
        h += (h << 5) + Boolean.hashCode(this.isIm);
        h += (h << 5) + Boolean.hashCode(this.isOrgShared);
        h += (h << 5) + this.user.hashCode();
        h += (h << 5) + Boolean.hashCode(this.isOpen);
        return h;
    }

    public String toString() {
        return "ImChannel{id=" + this.id + ", created=" + this.created + ", isIm=" + this.isIm + ", isOrgShared=" + this.isOrgShared + ", user=" + this.user + ", isOpen=" + this.isOpen + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImChannel fromJson(Json json) {
        Builder builder = ImChannel.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.createdIsSet) {
            builder.setCreated(json.created);
        }
        if (json.isImIsSet) {
            builder.setIsIm(json.isIm);
        }
        if (json.isOrgSharedIsSet) {
            builder.setIsOrgShared(json.isOrgShared);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.isOpenIsSet) {
            builder.setIsOpen(json.isOpen);
        }
        return builder.build();
    }

    public static ImChannel copyOf(ImChannelIF instance) {
        if (instance instanceof ImChannel) {
            return (ImChannel)instance;
        }
        return ImChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ImChannelIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_CREATED = 2L;
        private static final long INIT_BIT_IS_IM = 4L;
        private static final long INIT_BIT_IS_ORG_SHARED = 8L;
        private static final long INIT_BIT_USER = 16L;
        private static final long INIT_BIT_IS_OPEN = 32L;
        private long initBits = 63L;
        @Nullable
        private String id;
        private int created;
        private boolean isIm;
        private boolean isOrgShared;
        @Nullable
        private String user;
        private boolean isOpen;

        private Builder() {
        }

        public final Builder from(ImChannelIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setCreated(instance.getCreated());
            this.setIsIm(instance.getIsIm());
            this.setIsOrgShared(instance.getIsOrgShared());
            this.setUser(instance.getUser());
            this.setIsOpen(instance.getIsOpen());
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCreated(int created) {
            this.created = created;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setIsIm(boolean isIm) {
            this.isIm = isIm;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setIsOrgShared(boolean isOrgShared) {
            this.isOrgShared = isOrgShared;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setUser(String user) {
            this.user = Objects.requireNonNull(user, "user");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setIsOpen(boolean isOpen) {
            this.isOpen = isOpen;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public ImChannel build() {
            this.checkRequiredAttributes();
            return new ImChannel(this.id, this.created, this.isIm, this.isOrgShared, this.user, this.isOpen);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean createdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean isImIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean isOrgSharedIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean userIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean isOpenIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.createdIsSet()) {
                attributes.add("created");
            }
            if (!this.isImIsSet()) {
                attributes.add("isIm");
            }
            if (!this.isOrgSharedIsSet()) {
                attributes.add("isOrgShared");
            }
            if (!this.userIsSet()) {
                attributes.add("user");
            }
            if (!this.isOpenIsSet()) {
                attributes.add("isOpen");
            }
            return "Cannot build ImChannel, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ImChannelIF", generator="Immutables")
    static final class Json
    implements ImChannelIF {
        @Nullable
        String id;
        int created;
        boolean createdIsSet;
        boolean isIm;
        boolean isImIsSet;
        boolean isOrgShared;
        boolean isOrgSharedIsSet;
        @Nullable
        String user;
        boolean isOpen;
        boolean isOpenIsSet;

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setCreated(int created) {
            this.created = created;
            this.createdIsSet = true;
        }

        @JsonProperty
        public void setIsIm(boolean isIm) {
            this.isIm = isIm;
            this.isImIsSet = true;
        }

        @JsonProperty
        public void setIsOrgShared(boolean isOrgShared) {
            this.isOrgShared = isOrgShared;
            this.isOrgSharedIsSet = true;
        }

        @JsonProperty
        public void setUser(String user) {
            this.user = user;
        }

        @JsonProperty
        public void setIsOpen(boolean isOpen) {
            this.isOpen = isOpen;
            this.isOpenIsSet = true;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCreated() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getIsIm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getIsOrgShared() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getIsOpen() {
            throw new UnsupportedOperationException();
        }
    }
}

