/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.calls;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.calls.ExternalCallsUserIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ExternalCallsUserIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ExternalCallsUser
implements ExternalCallsUserIF {
    private final String externalId;
    private final String displayName;
    private final String avatarUrl;

    private ExternalCallsUser(String externalId, String displayName, String avatarUrl) {
        this.externalId = externalId;
        this.displayName = displayName;
        this.avatarUrl = avatarUrl;
    }

    @Override
    @JsonProperty
    public String getExternalId() {
        return this.externalId;
    }

    @Override
    @JsonProperty
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @JsonProperty
    public String getAvatarUrl() {
        return this.avatarUrl;
    }

    public final ExternalCallsUser withExternalId(String value) {
        String newValue = Objects.requireNonNull(value, "externalId");
        if (this.externalId.equals(newValue)) {
            return this;
        }
        return new ExternalCallsUser(newValue, this.displayName, this.avatarUrl);
    }

    public final ExternalCallsUser withDisplayName(String value) {
        String newValue = Objects.requireNonNull(value, "displayName");
        if (this.displayName.equals(newValue)) {
            return this;
        }
        return new ExternalCallsUser(this.externalId, newValue, this.avatarUrl);
    }

    public final ExternalCallsUser withAvatarUrl(String value) {
        String newValue = Objects.requireNonNull(value, "avatarUrl");
        if (this.avatarUrl.equals(newValue)) {
            return this;
        }
        return new ExternalCallsUser(this.externalId, this.displayName, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ExternalCallsUser && this.equalTo(0, (ExternalCallsUser)another);
    }

    private boolean equalTo(int synthetic, ExternalCallsUser another) {
        return this.externalId.equals(another.externalId) && this.displayName.equals(another.displayName) && this.avatarUrl.equals(another.avatarUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.externalId.hashCode();
        h += (h << 5) + this.displayName.hashCode();
        h += (h << 5) + this.avatarUrl.hashCode();
        return h;
    }

    public String toString() {
        return "ExternalCallsUser{externalId=" + this.externalId + ", displayName=" + this.displayName + ", avatarUrl=" + this.avatarUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ExternalCallsUser fromJson(Json json) {
        Builder builder = ExternalCallsUser.builder();
        if (json.externalId != null) {
            builder.setExternalId(json.externalId);
        }
        if (json.displayName != null) {
            builder.setDisplayName(json.displayName);
        }
        if (json.avatarUrl != null) {
            builder.setAvatarUrl(json.avatarUrl);
        }
        return builder.build();
    }

    public static ExternalCallsUser copyOf(ExternalCallsUserIF instance) {
        if (instance instanceof ExternalCallsUser) {
            return (ExternalCallsUser)instance;
        }
        return ExternalCallsUser.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExternalCallsUserIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXTERNAL_ID = 1L;
        private static final long INIT_BIT_DISPLAY_NAME = 2L;
        private static final long INIT_BIT_AVATAR_URL = 4L;
        private long initBits = 7L;
        @Nullable
        private String externalId;
        @Nullable
        private String displayName;
        @Nullable
        private String avatarUrl;

        private Builder() {
        }

        public final Builder from(ExternalCallsUserIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setExternalId(instance.getExternalId());
            this.setDisplayName(instance.getDisplayName());
            this.setAvatarUrl(instance.getAvatarUrl());
            return this;
        }

        public final Builder setExternalId(String externalId) {
            this.externalId = Objects.requireNonNull(externalId, "externalId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDisplayName(String displayName) {
            this.displayName = Objects.requireNonNull(displayName, "displayName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setAvatarUrl(String avatarUrl) {
            this.avatarUrl = Objects.requireNonNull(avatarUrl, "avatarUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ExternalCallsUser build() {
            this.checkRequiredAttributes();
            return new ExternalCallsUser(this.externalId, this.displayName, this.avatarUrl);
        }

        private boolean externalIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean displayNameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean avatarUrlIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.externalIdIsSet()) {
                attributes.add("externalId");
            }
            if (!this.displayNameIsSet()) {
                attributes.add("displayName");
            }
            if (!this.avatarUrlIsSet()) {
                attributes.add("avatarUrl");
            }
            return "Cannot build ExternalCallsUser, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ExternalCallsUserIF", generator="Immutables")
    static final class Json
    implements ExternalCallsUserIF {
        @Nullable
        String externalId;
        @Nullable
        String displayName;
        @Nullable
        String avatarUrl;

        Json() {
        }

        @JsonProperty
        public void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @JsonProperty
        public void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @JsonProperty
        public void setAvatarUrl(String avatarUrl) {
            this.avatarUrl = avatarUrl;
        }

        @Override
        public String getExternalId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDisplayName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAvatarUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

