/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.bookmarks;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.bookmarks.BookmarkType;
import java.time.Instant;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@HubSpotStyle
@Value.Immutable
public interface BookmarkIF {
    public BookmarkType getType();

    public String getId();

    public String getChannelId();

    public String getTitle();

    public Optional<String> getLink();

    public Optional<String> getEmoji();

    public Optional<String> getIconUrl();

    public Optional<String> getEntityId();

    @JsonProperty(value="date_created")
    public long getDateCreatedEpochSeconds();

    @JsonIgnore
    @Value.Derived
    default public Instant getCreatedAt() {
        return Instant.ofEpochSecond(this.getDateCreatedEpochSeconds());
    }

    @JsonProperty(value="date_updated")
    public long getDateUpdatedEpochSeconds();

    @JsonIgnore
    @Value.Derived
    default public Instant getUpdatedAt() {
        return Instant.ofEpochSecond(this.getDateUpdatedEpochSeconds());
    }

    public Optional<String> getRank();

    public Optional<String> getLastUpdatedByUserId();

    public Optional<String> getLastUpdatedByTeamId();

    public Optional<String> getShortcutId();

    public Optional<String> getAppId();
}

