/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.bookmarks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.bookmarks.BookmarkIF;
import com.hubspot.slack.client.models.bookmarks.BookmarkType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="BookmarkIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Bookmark
implements BookmarkIF {
    private final BookmarkType type;
    private final String id;
    private final String channelId;
    private final String title;
    @Nullable
    private final String link;
    @Nullable
    private final String emoji;
    @Nullable
    private final String iconUrl;
    @Nullable
    private final String entityId;
    private final long dateCreatedEpochSeconds;
    private final transient Instant createdAt;
    private final long dateUpdatedEpochSeconds;
    private final transient Instant updatedAt;
    @Nullable
    private final String rank;
    @Nullable
    private final String lastUpdatedByUserId;
    @Nullable
    private final String lastUpdatedByTeamId;
    @Nullable
    private final String shortcutId;
    @Nullable
    private final String appId;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private Bookmark(BookmarkType type, String id, String channelId, String title, @Nullable String link, @Nullable String emoji, @Nullable String iconUrl, @Nullable String entityId, long dateCreatedEpochSeconds, long dateUpdatedEpochSeconds, @Nullable String rank, @Nullable String lastUpdatedByUserId, @Nullable String lastUpdatedByTeamId, @Nullable String shortcutId, @Nullable String appId) {
        this.type = type;
        this.id = id;
        this.channelId = channelId;
        this.title = title;
        this.link = link;
        this.emoji = emoji;
        this.iconUrl = iconUrl;
        this.entityId = entityId;
        this.dateCreatedEpochSeconds = dateCreatedEpochSeconds;
        this.dateUpdatedEpochSeconds = dateUpdatedEpochSeconds;
        this.rank = rank;
        this.lastUpdatedByUserId = lastUpdatedByUserId;
        this.lastUpdatedByTeamId = lastUpdatedByTeamId;
        this.shortcutId = shortcutId;
        this.appId = appId;
        this.createdAt = this.initShim.getCreatedAt();
        this.updatedAt = this.initShim.getUpdatedAt();
        this.initShim = null;
    }

    private Instant getCreatedAtInitialize() {
        return BookmarkIF.super.getCreatedAt();
    }

    private Instant getUpdatedAtInitialize() {
        return BookmarkIF.super.getUpdatedAt();
    }

    @Override
    @JsonProperty
    public BookmarkType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Optional<String> getLink() {
        return Optional.ofNullable(this.link);
    }

    @Override
    @JsonProperty
    public Optional<String> getEmoji() {
        return Optional.ofNullable(this.emoji);
    }

    @Override
    @JsonProperty
    public Optional<String> getIconUrl() {
        return Optional.ofNullable(this.iconUrl);
    }

    @Override
    @JsonProperty
    public Optional<String> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    @Override
    @JsonProperty(value="date_created")
    public long getDateCreatedEpochSeconds() {
        return this.dateCreatedEpochSeconds;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Instant getCreatedAt() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getCreatedAt() : this.createdAt;
    }

    @Override
    @JsonProperty(value="date_updated")
    public long getDateUpdatedEpochSeconds() {
        return this.dateUpdatedEpochSeconds;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Instant getUpdatedAt() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getUpdatedAt() : this.updatedAt;
    }

    @Override
    @JsonProperty
    public Optional<String> getRank() {
        return Optional.ofNullable(this.rank);
    }

    @Override
    @JsonProperty
    public Optional<String> getLastUpdatedByUserId() {
        return Optional.ofNullable(this.lastUpdatedByUserId);
    }

    @Override
    @JsonProperty
    public Optional<String> getLastUpdatedByTeamId() {
        return Optional.ofNullable(this.lastUpdatedByTeamId);
    }

    @Override
    @JsonProperty
    public Optional<String> getShortcutId() {
        return Optional.ofNullable(this.shortcutId);
    }

    @Override
    @JsonProperty
    public Optional<String> getAppId() {
        return Optional.ofNullable(this.appId);
    }

    public final Bookmark withType(BookmarkType value) {
        BookmarkType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new Bookmark(newValue, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new Bookmark(this.type, newValue, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, newValue, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, newValue, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withLink(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.link, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, newValue, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withLink(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.link, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, value, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withEmoji(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.emoji, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, newValue, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withEmoji(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.emoji, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, value, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withIconUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.iconUrl, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, newValue, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withIconUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.iconUrl, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, value, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withEntityId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.entityId, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, newValue, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withEntityId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.entityId, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, value, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withDateCreatedEpochSeconds(long value) {
        if (this.dateCreatedEpochSeconds == value) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, value, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withDateUpdatedEpochSeconds(long value) {
        if (this.dateUpdatedEpochSeconds == value) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, value, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withRank(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.rank, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, newValue, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withRank(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rank, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, value, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withLastUpdatedByUserId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.lastUpdatedByUserId, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, newValue, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withLastUpdatedByUserId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lastUpdatedByUserId, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, value, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
    }

    public final Bookmark withLastUpdatedByTeamId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.lastUpdatedByTeamId, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, newValue, this.shortcutId, this.appId);
    }

    public final Bookmark withLastUpdatedByTeamId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.lastUpdatedByTeamId, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, value, this.shortcutId, this.appId);
    }

    public final Bookmark withShortcutId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.shortcutId, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, newValue, this.appId);
    }

    public final Bookmark withShortcutId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.shortcutId, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, value, this.appId);
    }

    public final Bookmark withAppId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.appId, newValue)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, newValue);
    }

    public final Bookmark withAppId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.appId, value)) {
            return this;
        }
        return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Bookmark && this.equalTo(0, (Bookmark)another);
    }

    private boolean equalTo(int synthetic, Bookmark another) {
        return this.type.equals((Object)another.type) && this.id.equals(another.id) && this.channelId.equals(another.channelId) && this.title.equals(another.title) && Objects.equals(this.link, another.link) && Objects.equals(this.emoji, another.emoji) && Objects.equals(this.iconUrl, another.iconUrl) && Objects.equals(this.entityId, another.entityId) && this.dateCreatedEpochSeconds == another.dateCreatedEpochSeconds && this.createdAt.equals(another.createdAt) && this.dateUpdatedEpochSeconds == another.dateUpdatedEpochSeconds && this.updatedAt.equals(another.updatedAt) && Objects.equals(this.rank, another.rank) && Objects.equals(this.lastUpdatedByUserId, another.lastUpdatedByUserId) && Objects.equals(this.lastUpdatedByTeamId, another.lastUpdatedByTeamId) && Objects.equals(this.shortcutId, another.shortcutId) && Objects.equals(this.appId, another.appId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.link);
        h += (h << 5) + Objects.hashCode(this.emoji);
        h += (h << 5) + Objects.hashCode(this.iconUrl);
        h += (h << 5) + Objects.hashCode(this.entityId);
        h += (h << 5) + Long.hashCode(this.dateCreatedEpochSeconds);
        h += (h << 5) + this.createdAt.hashCode();
        h += (h << 5) + Long.hashCode(this.dateUpdatedEpochSeconds);
        h += (h << 5) + this.updatedAt.hashCode();
        h += (h << 5) + Objects.hashCode(this.rank);
        h += (h << 5) + Objects.hashCode(this.lastUpdatedByUserId);
        h += (h << 5) + Objects.hashCode(this.lastUpdatedByTeamId);
        h += (h << 5) + Objects.hashCode(this.shortcutId);
        h += (h << 5) + Objects.hashCode(this.appId);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Bookmark{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("title=").append(this.title);
        if (this.link != null) {
            builder.append(", ");
            builder.append("link=").append(this.link);
        }
        if (this.emoji != null) {
            builder.append(", ");
            builder.append("emoji=").append(this.emoji);
        }
        if (this.iconUrl != null) {
            builder.append(", ");
            builder.append("iconUrl=").append(this.iconUrl);
        }
        if (this.entityId != null) {
            builder.append(", ");
            builder.append("entityId=").append(this.entityId);
        }
        builder.append(", ");
        builder.append("dateCreatedEpochSeconds=").append(this.dateCreatedEpochSeconds);
        builder.append(", ");
        builder.append("createdAt=").append(this.createdAt);
        builder.append(", ");
        builder.append("dateUpdatedEpochSeconds=").append(this.dateUpdatedEpochSeconds);
        builder.append(", ");
        builder.append("updatedAt=").append(this.updatedAt);
        if (this.rank != null) {
            builder.append(", ");
            builder.append("rank=").append(this.rank);
        }
        if (this.lastUpdatedByUserId != null) {
            builder.append(", ");
            builder.append("lastUpdatedByUserId=").append(this.lastUpdatedByUserId);
        }
        if (this.lastUpdatedByTeamId != null) {
            builder.append(", ");
            builder.append("lastUpdatedByTeamId=").append(this.lastUpdatedByTeamId);
        }
        if (this.shortcutId != null) {
            builder.append(", ");
            builder.append("shortcutId=").append(this.shortcutId);
        }
        if (this.appId != null) {
            builder.append(", ");
            builder.append("appId=").append(this.appId);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Bookmark fromJson(Json json) {
        Builder builder = Bookmark.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.link != null) {
            builder.setLink(json.link);
        }
        if (json.emoji != null) {
            builder.setEmoji(json.emoji);
        }
        if (json.iconUrl != null) {
            builder.setIconUrl(json.iconUrl);
        }
        if (json.entityId != null) {
            builder.setEntityId(json.entityId);
        }
        if (json.dateCreatedEpochSecondsIsSet) {
            builder.setDateCreatedEpochSeconds(json.dateCreatedEpochSeconds);
        }
        if (json.dateUpdatedEpochSecondsIsSet) {
            builder.setDateUpdatedEpochSeconds(json.dateUpdatedEpochSeconds);
        }
        if (json.rank != null) {
            builder.setRank(json.rank);
        }
        if (json.lastUpdatedByUserId != null) {
            builder.setLastUpdatedByUserId(json.lastUpdatedByUserId);
        }
        if (json.lastUpdatedByTeamId != null) {
            builder.setLastUpdatedByTeamId(json.lastUpdatedByTeamId);
        }
        if (json.shortcutId != null) {
            builder.setShortcutId(json.shortcutId);
        }
        if (json.appId != null) {
            builder.setAppId(json.appId);
        }
        return builder.build();
    }

    public static Bookmark copyOf(BookmarkIF instance) {
        if (instance instanceof Bookmark) {
            return (Bookmark)instance;
        }
        return Bookmark.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BookmarkIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_ID = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_TITLE = 8L;
        private static final long INIT_BIT_DATE_CREATED_EPOCH_SECONDS = 16L;
        private static final long INIT_BIT_DATE_UPDATED_EPOCH_SECONDS = 32L;
        private long initBits = 63L;
        @Nullable
        private BookmarkType type;
        @Nullable
        private String id;
        @Nullable
        private String channelId;
        @Nullable
        private String title;
        @Nullable
        private String link;
        @Nullable
        private String emoji;
        @Nullable
        private String iconUrl;
        @Nullable
        private String entityId;
        private long dateCreatedEpochSeconds;
        private long dateUpdatedEpochSeconds;
        @Nullable
        private String rank;
        @Nullable
        private String lastUpdatedByUserId;
        @Nullable
        private String lastUpdatedByTeamId;
        @Nullable
        private String shortcutId;
        @Nullable
        private String appId;

        private Builder() {
        }

        public final Builder from(BookmarkIF instance) {
            Optional<String> appIdOptional;
            Optional<String> shortcutIdOptional;
            Optional<String> lastUpdatedByTeamIdOptional;
            Optional<String> lastUpdatedByUserIdOptional;
            Optional<String> entityIdOptional;
            Optional<String> iconUrlOptional;
            Optional<String> emojiOptional;
            Objects.requireNonNull(instance, "instance");
            this.setType(instance.getType());
            this.setId(instance.getId());
            this.setChannelId(instance.getChannelId());
            this.setTitle(instance.getTitle());
            Optional<String> linkOptional = instance.getLink();
            if (linkOptional.isPresent()) {
                this.setLink(linkOptional);
            }
            if ((emojiOptional = instance.getEmoji()).isPresent()) {
                this.setEmoji(emojiOptional);
            }
            if ((iconUrlOptional = instance.getIconUrl()).isPresent()) {
                this.setIconUrl(iconUrlOptional);
            }
            if ((entityIdOptional = instance.getEntityId()).isPresent()) {
                this.setEntityId(entityIdOptional);
            }
            this.setDateCreatedEpochSeconds(instance.getDateCreatedEpochSeconds());
            this.setDateUpdatedEpochSeconds(instance.getDateUpdatedEpochSeconds());
            Optional<String> rankOptional = instance.getRank();
            if (rankOptional.isPresent()) {
                this.setRank(rankOptional);
            }
            if ((lastUpdatedByUserIdOptional = instance.getLastUpdatedByUserId()).isPresent()) {
                this.setLastUpdatedByUserId(lastUpdatedByUserIdOptional);
            }
            if ((lastUpdatedByTeamIdOptional = instance.getLastUpdatedByTeamId()).isPresent()) {
                this.setLastUpdatedByTeamId(lastUpdatedByTeamIdOptional);
            }
            if ((shortcutIdOptional = instance.getShortcutId()).isPresent()) {
                this.setShortcutId(shortcutIdOptional);
            }
            if ((appIdOptional = instance.getAppId()).isPresent()) {
                this.setAppId(appIdOptional);
            }
            return this;
        }

        public final Builder setType(BookmarkType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setLink(@Nullable String link) {
            this.link = link;
            return this;
        }

        public final Builder setLink(Optional<String> link) {
            this.link = link.orElse(null);
            return this;
        }

        public final Builder setEmoji(@Nullable String emoji) {
            this.emoji = emoji;
            return this;
        }

        public final Builder setEmoji(Optional<String> emoji) {
            this.emoji = emoji.orElse(null);
            return this;
        }

        public final Builder setIconUrl(@Nullable String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public final Builder setIconUrl(Optional<String> iconUrl) {
            this.iconUrl = iconUrl.orElse(null);
            return this;
        }

        public final Builder setEntityId(@Nullable String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final Builder setEntityId(Optional<String> entityId) {
            this.entityId = entityId.orElse(null);
            return this;
        }

        public final Builder setDateCreatedEpochSeconds(long dateCreatedEpochSeconds) {
            this.dateCreatedEpochSeconds = dateCreatedEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder setDateUpdatedEpochSeconds(long dateUpdatedEpochSeconds) {
            this.dateUpdatedEpochSeconds = dateUpdatedEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder setRank(@Nullable String rank) {
            this.rank = rank;
            return this;
        }

        public final Builder setRank(Optional<String> rank) {
            this.rank = rank.orElse(null);
            return this;
        }

        public final Builder setLastUpdatedByUserId(@Nullable String lastUpdatedByUserId) {
            this.lastUpdatedByUserId = lastUpdatedByUserId;
            return this;
        }

        public final Builder setLastUpdatedByUserId(Optional<String> lastUpdatedByUserId) {
            this.lastUpdatedByUserId = lastUpdatedByUserId.orElse(null);
            return this;
        }

        public final Builder setLastUpdatedByTeamId(@Nullable String lastUpdatedByTeamId) {
            this.lastUpdatedByTeamId = lastUpdatedByTeamId;
            return this;
        }

        public final Builder setLastUpdatedByTeamId(Optional<String> lastUpdatedByTeamId) {
            this.lastUpdatedByTeamId = lastUpdatedByTeamId.orElse(null);
            return this;
        }

        public final Builder setShortcutId(@Nullable String shortcutId) {
            this.shortcutId = shortcutId;
            return this;
        }

        public final Builder setShortcutId(Optional<String> shortcutId) {
            this.shortcutId = shortcutId.orElse(null);
            return this;
        }

        public final Builder setAppId(@Nullable String appId) {
            this.appId = appId;
            return this;
        }

        public final Builder setAppId(Optional<String> appId) {
            this.appId = appId.orElse(null);
            return this;
        }

        public Bookmark build() {
            this.checkRequiredAttributes();
            return new Bookmark(this.type, this.id, this.channelId, this.title, this.link, this.emoji, this.iconUrl, this.entityId, this.dateCreatedEpochSeconds, this.dateUpdatedEpochSeconds, this.rank, this.lastUpdatedByUserId, this.lastUpdatedByTeamId, this.shortcutId, this.appId);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean titleIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean dateCreatedEpochSecondsIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private boolean dateUpdatedEpochSecondsIsSet() {
            return (this.initBits & 0x20L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.dateCreatedEpochSecondsIsSet()) {
                attributes.add("dateCreatedEpochSeconds");
            }
            if (!this.dateUpdatedEpochSecondsIsSet()) {
                attributes.add("dateUpdatedEpochSeconds");
            }
            return "Cannot build Bookmark, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="BookmarkIF", generator="Immutables")
    static final class Json
    implements BookmarkIF {
        @Nullable
        BookmarkType type;
        @Nullable
        String id;
        @Nullable
        String channelId;
        @Nullable
        String title;
        @Nullable
        Optional<String> link = Optional.empty();
        @Nullable
        Optional<String> emoji = Optional.empty();
        @Nullable
        Optional<String> iconUrl = Optional.empty();
        @Nullable
        Optional<String> entityId = Optional.empty();
        long dateCreatedEpochSeconds;
        boolean dateCreatedEpochSecondsIsSet;
        long dateUpdatedEpochSeconds;
        boolean dateUpdatedEpochSecondsIsSet;
        @Nullable
        Optional<String> rank = Optional.empty();
        @Nullable
        Optional<String> lastUpdatedByUserId = Optional.empty();
        @Nullable
        Optional<String> lastUpdatedByTeamId = Optional.empty();
        @Nullable
        Optional<String> shortcutId = Optional.empty();
        @Nullable
        Optional<String> appId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(BookmarkType type) {
            this.type = type;
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setLink(Optional<String> link) {
            this.link = link;
        }

        @JsonProperty
        public void setEmoji(Optional<String> emoji) {
            this.emoji = emoji;
        }

        @JsonProperty
        public void setIconUrl(Optional<String> iconUrl) {
            this.iconUrl = iconUrl;
        }

        @JsonProperty
        public void setEntityId(Optional<String> entityId) {
            this.entityId = entityId;
        }

        @JsonProperty(value="date_created")
        public void setDateCreatedEpochSeconds(long dateCreatedEpochSeconds) {
            this.dateCreatedEpochSeconds = dateCreatedEpochSeconds;
            this.dateCreatedEpochSecondsIsSet = true;
        }

        @JsonProperty(value="date_updated")
        public void setDateUpdatedEpochSeconds(long dateUpdatedEpochSeconds) {
            this.dateUpdatedEpochSeconds = dateUpdatedEpochSeconds;
            this.dateUpdatedEpochSecondsIsSet = true;
        }

        @JsonProperty
        public void setRank(Optional<String> rank) {
            this.rank = rank;
        }

        @JsonProperty
        public void setLastUpdatedByUserId(Optional<String> lastUpdatedByUserId) {
            this.lastUpdatedByUserId = lastUpdatedByUserId;
        }

        @JsonProperty
        public void setLastUpdatedByTeamId(Optional<String> lastUpdatedByTeamId) {
            this.lastUpdatedByTeamId = lastUpdatedByTeamId;
        }

        @JsonProperty
        public void setShortcutId(Optional<String> shortcutId) {
            this.shortcutId = shortcutId;
        }

        @JsonProperty
        public void setAppId(Optional<String> appId) {
            this.appId = appId;
        }

        @Override
        public BookmarkType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getIconUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEntityId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getDateCreatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Instant getCreatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getDateUpdatedEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Instant getUpdatedAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRank() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLastUpdatedByUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLastUpdatedByTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getShortcutId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAppId() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="BookmarkIF", generator="Immutables")
    private final class InitShim {
        private byte createdAtBuildStage = 0;
        private Instant createdAt;
        private byte updatedAtBuildStage = 0;
        private Instant updatedAt;

        private InitShim() {
        }

        Instant getCreatedAt() {
            if (this.createdAtBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.createdAtBuildStage == 0) {
                this.createdAtBuildStage = (byte)-1;
                this.createdAt = Objects.requireNonNull(Bookmark.this.getCreatedAtInitialize(), "createdAt");
                this.createdAtBuildStage = 1;
            }
            return this.createdAt;
        }

        Instant getUpdatedAt() {
            if (this.updatedAtBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.updatedAtBuildStage == 0) {
                this.updatedAtBuildStage = (byte)-1;
                this.updatedAt = Objects.requireNonNull(Bookmark.this.getUpdatedAtInitialize(), "updatedAt");
                this.updatedAtBuildStage = 1;
            }
            return this.updatedAt;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.createdAtBuildStage == -1) {
                attributes.add("createdAt");
            }
            if (this.updatedAtBuildStage == -1) {
                attributes.add("updatedAt");
            }
            return "Cannot build Bookmark, attribute initializers form cycle " + attributes;
        }
    }
}

