/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.OptionIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OptionIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Option
implements OptionIF {
    private final Text text;
    private final String value;
    @Nullable
    private final Text description;
    @Nullable
    private final String url;

    private Option(Text text, String value) {
        this.text = Objects.requireNonNull(text, "text");
        this.value = Objects.requireNonNull(value, "value");
        this.description = null;
        this.url = null;
    }

    private Option(Text text, String value, @Nullable Text description, @Nullable String url) {
        this.text = text;
        this.value = value;
        this.description = description;
        this.url = url;
    }

    @Override
    @JsonProperty
    public Text getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty
    public Optional<Text> getDescription() {
        return Optional.ofNullable(this.description);
    }

    @Override
    @JsonProperty
    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    public final Option withText(Text value) {
        if (this.text == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "text");
        return Option.validate(new Option(newValue, this.value, this.description, this.url));
    }

    public final Option withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return Option.validate(new Option(this.text, newValue, this.description, this.url));
    }

    public final Option withDescription(@Nullable Text value) {
        Text newValue = value;
        if (this.description == newValue) {
            return this;
        }
        return Option.validate(new Option(this.text, this.value, newValue, this.url));
    }

    public final Option withDescription(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.description == value) {
            return this;
        }
        return Option.validate(new Option(this.text, this.value, value, this.url));
    }

    public final Option withUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.url, newValue)) {
            return this;
        }
        return Option.validate(new Option(this.text, this.value, this.description, newValue));
    }

    public final Option withUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return Option.validate(new Option(this.text, this.value, this.description, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Option && this.equalTo(0, (Option)another);
    }

    private boolean equalTo(int synthetic, Option another) {
        return this.text.equals(another.text) && this.value.equals(another.value) && Objects.equals(this.description, another.description) && Objects.equals(this.url, another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.url);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Option{");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("value=").append(this.value);
        if (this.description != null) {
            builder.append(", ");
            builder.append("description=").append(this.description);
        }
        if (this.url != null) {
            builder.append(", ");
            builder.append("url=").append(this.url);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Option fromJson(Json json) {
        Builder builder = Option.builder();
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.description != null) {
            builder.setDescription(json.description);
        }
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        return builder.build();
    }

    public static Option of(Text text, String value) {
        return Option.validate(new Option(text, value));
    }

    private static Option validate(Option instance) {
        instance = (Option)instance.validate();
        return instance;
    }

    public static Option copyOf(OptionIF instance) {
        if (instance instanceof Option) {
            return (Option)instance;
        }
        return Option.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OptionIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private Text text;
        @Nullable
        private String value;
        @Nullable
        private Text description;
        @Nullable
        private String url;

        private Builder() {
        }

        public final Builder from(OptionIF instance) {
            Optional<String> urlOptional;
            Objects.requireNonNull(instance, "instance");
            this.setText(instance.getText());
            this.setValue(instance.getValue());
            Optional<Text> descriptionOptional = instance.getDescription();
            if (descriptionOptional.isPresent()) {
                this.setDescription(descriptionOptional);
            }
            if ((urlOptional = instance.getUrl()).isPresent()) {
                this.setUrl(urlOptional);
            }
            return this;
        }

        public final Builder setText(Text text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setDescription(@Nullable Text description) {
            this.description = description;
            return this;
        }

        public final Builder setDescription(Optional<? extends Text> description) {
            this.description = description.orElse(null);
            return this;
        }

        public final Builder setUrl(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder setUrl(Optional<String> url) {
            this.url = url.orElse(null);
            return this;
        }

        public Option build() {
            this.checkRequiredAttributes();
            return Option.validate(new Option(this.text, this.value, this.description, this.url));
        }

        private boolean textIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean valueIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build Option, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OptionIF", generator="Immutables")
    static final class Json
    implements OptionIF {
        @Nullable
        Text text;
        @Nullable
        String value;
        @Nullable
        Optional<Text> description = Optional.empty();
        @Nullable
        Optional<String> url = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setText(Text text) {
            this.text = text;
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty
        public void setDescription(Optional<Text> description) {
            this.description = description;
        }

        @JsonProperty
        public void setUrl(Optional<String> url) {
            this.url = url;
        }

        @Override
        public Text getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getDescription() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

