/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.elements.StaticSelectMenuIF;
import com.hubspot.slack.client.models.blocks.json.OptionOrOptionGroupDeserializer;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.blocks.objects.OptionGroup;
import com.hubspot.slack.client.models.blocks.objects.OptionOrOptionGroup;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="StaticSelectMenuIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class StaticSelectMenu
implements StaticSelectMenuIF {
    private final transient String type;
    private final Text placeholder;
    private final String actionId;
    private final List<Option> options;
    private final List<OptionGroup> optionGroups;
    @Nullable
    private final OptionOrOptionGroup initialOption;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private StaticSelectMenu(Text placeholder, String actionId, Iterable<? extends Option> options) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.options = StaticSelectMenu.createUnmodifiableList(false, StaticSelectMenu.createSafeList(options, true, false));
        this.optionGroups = Collections.emptyList();
        this.initialOption = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(StaticSelectMenuIF.super.getType(), "type");
    }

    private StaticSelectMenu(Text placeholder, String actionId, List<Option> options, List<OptionGroup> optionGroups, @Nullable OptionOrOptionGroup initialOption, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.options = options;
        this.optionGroups = optionGroups;
        this.initialOption = initialOption;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(StaticSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty
    public List<OptionGroup> getOptionGroups() {
        return this.optionGroups;
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
    public Optional<OptionOrOptionGroup> getInitialOption() {
        return Optional.ofNullable(this.initialOption);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final StaticSelectMenu withPlaceholder(Text value) {
        if (this.placeholder == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "placeholder");
        return StaticSelectMenu.validate(new StaticSelectMenu(newValue, this.actionId, this.options, this.optionGroups, this.initialOption, this.confirmationDialog));
    }

    public final StaticSelectMenu withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, newValue, this.options, this.optionGroups, this.initialOption, this.confirmationDialog));
    }

    public final StaticSelectMenu withOptions(Option ... elements) {
        List<Option> newValue = StaticSelectMenu.createUnmodifiableList(false, StaticSelectMenu.createSafeList(Arrays.asList(elements), true, false));
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, newValue, this.optionGroups, this.initialOption, this.confirmationDialog));
    }

    public final StaticSelectMenu withOptions(Iterable<? extends Option> elements) {
        if (this.options == elements) {
            return this;
        }
        List<Option> newValue = StaticSelectMenu.createUnmodifiableList(false, StaticSelectMenu.createSafeList(elements, true, false));
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, newValue, this.optionGroups, this.initialOption, this.confirmationDialog));
    }

    public final StaticSelectMenu withOptionGroups(OptionGroup ... elements) {
        List<OptionGroup> newValue = StaticSelectMenu.createUnmodifiableList(false, StaticSelectMenu.createSafeList(Arrays.asList(elements), true, false));
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, this.options, newValue, this.initialOption, this.confirmationDialog));
    }

    public final StaticSelectMenu withOptionGroups(Iterable<? extends OptionGroup> elements) {
        if (this.optionGroups == elements) {
            return this;
        }
        List<OptionGroup> newValue = StaticSelectMenu.createUnmodifiableList(false, StaticSelectMenu.createSafeList(elements, true, false));
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, this.options, newValue, this.initialOption, this.confirmationDialog));
    }

    public final StaticSelectMenu withInitialOption(@Nullable OptionOrOptionGroup value) {
        OptionOrOptionGroup newValue = value;
        if (this.initialOption == newValue) {
            return this;
        }
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, this.options, this.optionGroups, newValue, this.confirmationDialog));
    }

    public final StaticSelectMenu withInitialOption(Optional<? extends OptionOrOptionGroup> optional) {
        OptionOrOptionGroup value = optional.orElse(null);
        if (this.initialOption == value) {
            return this;
        }
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, this.options, this.optionGroups, value, this.confirmationDialog));
    }

    public final StaticSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, this.options, this.optionGroups, this.initialOption, newValue));
    }

    public final StaticSelectMenu withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, this.options, this.optionGroups, this.initialOption, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StaticSelectMenu && this.equalTo(0, (StaticSelectMenu)another);
    }

    private boolean equalTo(int synthetic, StaticSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && this.options.equals(another.options) && this.optionGroups.equals(another.optionGroups) && Objects.equals(this.initialOption, another.initialOption) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.placeholder.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.optionGroups.hashCode();
        h += (h << 5) + Objects.hashCode(this.initialOption);
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("StaticSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("options=").append(this.options);
        builder.append(", ");
        builder.append("optionGroups=").append(this.optionGroups);
        if (this.initialOption != null) {
            builder.append(", ");
            builder.append("initialOption=").append(this.initialOption);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static StaticSelectMenu fromJson(Json json) {
        Builder builder = StaticSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        if (json.optionGroups != null) {
            builder.addAllOptionGroups(json.optionGroups);
        }
        if (json.initialOption != null) {
            builder.setInitialOption(json.initialOption);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static StaticSelectMenu of(Text placeholder, String actionId, List<Option> options) {
        return StaticSelectMenu.of(placeholder, actionId, options);
    }

    public static StaticSelectMenu of(Text placeholder, String actionId, Iterable<? extends Option> options) {
        return StaticSelectMenu.validate(new StaticSelectMenu(placeholder, actionId, options));
    }

    private static StaticSelectMenu validate(StaticSelectMenu instance) {
        instance = (StaticSelectMenu)instance.validate();
        return instance;
    }

    public static StaticSelectMenu copyOf(StaticSelectMenuIF instance) {
        if (instance instanceof StaticSelectMenu) {
            return (StaticSelectMenu)instance;
        }
        return StaticSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="StaticSelectMenuIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        private List<Option> options = new ArrayList<Option>();
        private List<OptionGroup> optionGroups = new ArrayList<OptionGroup>();
        @Nullable
        private OptionOrOptionGroup initialOption;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(StaticSelectMenuIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof StaticSelectMenuIF) {
                Optional<ConfirmationDialog> confirmationDialogOptional;
                Optional<OptionOrOptionGroup> initialOptionOptional;
                instance = (StaticSelectMenuIF)object;
                this.addAllOptions(instance.getOptions());
                this.addAllOptionGroups(instance.getOptionGroups());
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((initialOptionOptional = instance.getInitialOption()).isPresent()) {
                    this.setInitialOption(initialOptionOptional);
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                this.setPlaceholder(instance.getPlaceholder());
            }
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addOptions(Option element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(Option ... elements) {
            for (Option element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends Option> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.options.add(Objects.requireNonNull(option, "options element"));
            }
            return this;
        }

        public final Builder addOptionGroups(OptionGroup element) {
            this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
            return this;
        }

        public final Builder addOptionGroups(OptionGroup ... elements) {
            for (OptionGroup element : elements) {
                this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
            }
            return this;
        }

        public final Builder setOptionGroups(Iterable<? extends OptionGroup> elements) {
            this.optionGroups.clear();
            return this.addAllOptionGroups(elements);
        }

        public final Builder addAllOptionGroups(Iterable<? extends OptionGroup> elements) {
            for (OptionGroup optionGroup : elements) {
                this.optionGroups.add(Objects.requireNonNull(optionGroup, "optionGroups element"));
            }
            return this;
        }

        public final Builder setInitialOption(@Nullable OptionOrOptionGroup initialOption) {
            this.initialOption = initialOption;
            return this;
        }

        public final Builder setInitialOption(Optional<? extends OptionOrOptionGroup> initialOption) {
            this.initialOption = initialOption.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public StaticSelectMenu build() {
            this.checkRequiredAttributes();
            return StaticSelectMenu.validate(new StaticSelectMenu(this.placeholder, this.actionId, StaticSelectMenu.createUnmodifiableList(true, this.options), StaticSelectMenu.createUnmodifiableList(true, this.optionGroups), this.initialOption, this.confirmationDialog));
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build StaticSelectMenu, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="StaticSelectMenuIF", generator="Immutables")
    static final class Json
    implements StaticSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        @Nullable
        List<Option> options = Collections.emptyList();
        @Nullable
        List<OptionGroup> optionGroups = Collections.emptyList();
        @Nullable
        Optional<OptionOrOptionGroup> initialOption = Optional.empty();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setOptions(List<Option> options) {
            this.options = options;
        }

        @JsonProperty
        public void setOptionGroups(List<OptionGroup> optionGroups) {
            this.optionGroups = optionGroups;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
        public void setInitialOption(Optional<OptionOrOptionGroup> initialOption) {
            this.initialOption = initialOption;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Option> getOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<OptionGroup> getOptionGroups() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<OptionOrOptionGroup> getInitialOption() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

