/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.ImageIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ImageIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Image
implements ImageIF {
    private final transient String type;
    private final String imageUrl;
    private final String altText;

    private Image(String imageUrl, String altText) {
        this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
        this.altText = Objects.requireNonNull(altText, "altText");
        this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
    }

    private Image(Image original, String imageUrl, String altText) {
        this.imageUrl = imageUrl;
        this.altText = altText;
        this.type = Objects.requireNonNull(ImageIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getImageUrl() {
        return this.imageUrl;
    }

    @Override
    @JsonProperty
    public String getAltText() {
        return this.altText;
    }

    public final Image withImageUrl(String value) {
        String newValue = Objects.requireNonNull(value, "imageUrl");
        if (this.imageUrl.equals(newValue)) {
            return this;
        }
        return new Image(this, newValue, this.altText);
    }

    public final Image withAltText(String value) {
        String newValue = Objects.requireNonNull(value, "altText");
        if (this.altText.equals(newValue)) {
            return this;
        }
        return new Image(this, this.imageUrl, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Image && this.equalTo(0, (Image)another);
    }

    private boolean equalTo(int synthetic, Image another) {
        return this.type.equals(another.type) && this.imageUrl.equals(another.imageUrl) && this.altText.equals(another.altText);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.imageUrl.hashCode();
        h += (h << 5) + this.altText.hashCode();
        return h;
    }

    public String toString() {
        return "Image{type=" + this.type + ", imageUrl=" + this.imageUrl + ", altText=" + this.altText + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Image fromJson(Json json) {
        Builder builder = Image.builder();
        if (json.imageUrl != null) {
            builder.setImageUrl(json.imageUrl);
        }
        if (json.altText != null) {
            builder.setAltText(json.altText);
        }
        return builder.build();
    }

    public static Image of(String imageUrl, String altText) {
        return new Image(imageUrl, altText);
    }

    public static Image copyOf(ImageIF instance) {
        if (instance instanceof Image) {
            return (Image)instance;
        }
        return Image.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ImageIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_IMAGE_URL = 1L;
        private static final long INIT_BIT_ALT_TEXT = 2L;
        private long initBits = 3L;
        @Nullable
        private String imageUrl;
        @Nullable
        private String altText;

        private Builder() {
        }

        public final Builder from(ImageIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setImageUrl(instance.getImageUrl());
            this.setAltText(instance.getAltText());
            return this;
        }

        public final Builder setImageUrl(String imageUrl) {
            this.imageUrl = Objects.requireNonNull(imageUrl, "imageUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setAltText(String altText) {
            this.altText = Objects.requireNonNull(altText, "altText");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public Image build() {
            this.checkRequiredAttributes();
            return new Image(null, this.imageUrl, this.altText);
        }

        private boolean imageUrlIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean altTextIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.imageUrlIsSet()) {
                attributes.add("imageUrl");
            }
            if (!this.altTextIsSet()) {
                attributes.add("altText");
            }
            return "Cannot build Image, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ImageIF", generator="Immutables")
    static final class Json
    implements ImageIF {
        @Nullable
        String imageUrl;
        @Nullable
        String altText;

        Json() {
        }

        @JsonProperty
        public void setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
        }

        @JsonProperty
        public void setAltText(String altText) {
            this.altText = altText;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getImageUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getAltText() {
            throw new UnsupportedOperationException();
        }
    }
}

