/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.DateTimePickerIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DateTimePickerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class DateTimePicker
implements DateTimePickerIF {
    private final transient String type;
    private final String actionId;
    @Nullable
    private final Text placeholder;
    @Nullable
    private final Integer initialDateTime;
    @Nullable
    private final ConfirmationDialog confirmationDialog;
    @Nullable
    private final Boolean focusOnLoad;

    private DateTimePicker(String actionId) {
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.placeholder = null;
        this.initialDateTime = null;
        this.confirmationDialog = null;
        this.focusOnLoad = null;
        this.type = Objects.requireNonNull(DateTimePickerIF.super.getType(), "type");
    }

    private DateTimePicker(String actionId, @Nullable Text placeholder, @Nullable Integer initialDateTime, @Nullable ConfirmationDialog confirmationDialog, @Nullable Boolean focusOnLoad) {
        this.actionId = actionId;
        this.placeholder = placeholder;
        this.initialDateTime = initialDateTime;
        this.confirmationDialog = confirmationDialog;
        this.focusOnLoad = focusOnLoad;
        this.type = Objects.requireNonNull(DateTimePickerIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<Text> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getInitialDateTime() {
        return Optional.ofNullable(this.initialDateTime);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isFocusOnLoad() {
        return Optional.ofNullable(this.focusOnLoad);
    }

    public final DateTimePicker withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new DateTimePicker(newValue, this.placeholder, this.initialDateTime, this.confirmationDialog, this.focusOnLoad);
    }

    public final DateTimePicker withPlaceholder(@Nullable Text value) {
        Text newValue = value;
        if (this.placeholder == newValue) {
            return this;
        }
        return new DateTimePicker(this.actionId, newValue, this.initialDateTime, this.confirmationDialog, this.focusOnLoad);
    }

    public final DateTimePicker withPlaceholder(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.placeholder == value) {
            return this;
        }
        return new DateTimePicker(this.actionId, value, this.initialDateTime, this.confirmationDialog, this.focusOnLoad);
    }

    public final DateTimePicker withInitialDateTime(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.initialDateTime, newValue)) {
            return this;
        }
        return new DateTimePicker(this.actionId, this.placeholder, newValue, this.confirmationDialog, this.focusOnLoad);
    }

    public final DateTimePicker withInitialDateTime(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.initialDateTime, value)) {
            return this;
        }
        return new DateTimePicker(this.actionId, this.placeholder, value, this.confirmationDialog, this.focusOnLoad);
    }

    public final DateTimePicker withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new DateTimePicker(this.actionId, this.placeholder, this.initialDateTime, newValue, this.focusOnLoad);
    }

    public final DateTimePicker withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new DateTimePicker(this.actionId, this.placeholder, this.initialDateTime, value, this.focusOnLoad);
    }

    public final DateTimePicker withFocusOnLoad(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.focusOnLoad, newValue)) {
            return this;
        }
        return new DateTimePicker(this.actionId, this.placeholder, this.initialDateTime, this.confirmationDialog, newValue);
    }

    public final DateTimePicker withFocusOnLoad(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.focusOnLoad, value)) {
            return this;
        }
        return new DateTimePicker(this.actionId, this.placeholder, this.initialDateTime, this.confirmationDialog, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof DateTimePicker && this.equalTo(0, (DateTimePicker)another);
    }

    private boolean equalTo(int synthetic, DateTimePicker another) {
        return this.type.equals(another.type) && this.actionId.equals(another.actionId) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.initialDateTime, another.initialDateTime) && Objects.equals(this.confirmationDialog, another.confirmationDialog) && Objects.equals(this.focusOnLoad, another.focusOnLoad);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholder);
        h += (h << 5) + Objects.hashCode(this.initialDateTime);
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        h += (h << 5) + Objects.hashCode(this.focusOnLoad);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("DateTimePicker{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.initialDateTime != null) {
            builder.append(", ");
            builder.append("initialDateTime=").append(this.initialDateTime);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        if (this.focusOnLoad != null) {
            builder.append(", ");
            builder.append("focusOnLoad=").append(this.focusOnLoad);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static DateTimePicker fromJson(Json json) {
        Builder builder = DateTimePicker.builder();
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.initialDateTime != null) {
            builder.setInitialDateTime(json.initialDateTime);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        if (json.focusOnLoad != null) {
            builder.setFocusOnLoad(json.focusOnLoad);
        }
        return builder.build();
    }

    public static DateTimePicker of(String actionId) {
        return new DateTimePicker(actionId);
    }

    public static DateTimePicker copyOf(DateTimePickerIF instance) {
        if (instance instanceof DateTimePicker) {
            return (DateTimePicker)instance;
        }
        return DateTimePicker.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DateTimePickerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String actionId;
        @Nullable
        private Text placeholder;
        @Nullable
        private Integer initialDateTime;
        @Nullable
        private ConfirmationDialog confirmationDialog;
        @Nullable
        private Boolean focusOnLoad;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(DateTimePickerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof DateTimePickerIF) {
                Optional<Text> placeholderOptional;
                Optional<ConfirmationDialog> confirmationDialogOptional;
                Optional<Integer> initialDateTimeOptional;
                instance = (DateTimePickerIF)object;
                Optional<Boolean> focusOnLoadOptional = instance.isFocusOnLoad();
                if (focusOnLoadOptional.isPresent()) {
                    this.setFocusOnLoad(focusOnLoadOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((initialDateTimeOptional = instance.getInitialDateTime()).isPresent()) {
                    this.setInitialDateTime(initialDateTimeOptional);
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                if ((placeholderOptional = instance.getPlaceholder()).isPresent()) {
                    this.setPlaceholder(placeholderOptional);
                }
            }
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable Text placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<? extends Text> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setInitialDateTime(@Nullable Integer initialDateTime) {
            this.initialDateTime = initialDateTime;
            return this;
        }

        public final Builder setInitialDateTime(Optional<Integer> initialDateTime) {
            this.initialDateTime = initialDateTime.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public final Builder setFocusOnLoad(@Nullable Boolean focusOnLoad) {
            this.focusOnLoad = focusOnLoad;
            return this;
        }

        public final Builder setFocusOnLoad(Optional<Boolean> focusOnLoad) {
            this.focusOnLoad = focusOnLoad.orElse(null);
            return this;
        }

        public DateTimePicker build() {
            this.checkRequiredAttributes();
            return new DateTimePicker(this.actionId, this.placeholder, this.initialDateTime, this.confirmationDialog, this.focusOnLoad);
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build DateTimePicker, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DateTimePickerIF", generator="Immutables")
    static final class Json
    implements DateTimePickerIF {
        @Nullable
        String actionId;
        @Nullable
        Optional<Text> placeholder = Optional.empty();
        @Nullable
        Optional<Integer> initialDateTime = Optional.empty();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();
        @Nullable
        Optional<Boolean> focusOnLoad = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setPlaceholder(Optional<Text> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setInitialDateTime(Optional<Integer> initialDateTime) {
            this.initialDateTime = initialDateTime;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @JsonProperty
        public void setFocusOnLoad(Optional<Boolean> focusOnLoad) {
            this.focusOnLoad = focusOnLoad;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getInitialDateTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isFocusOnLoad() {
            throw new UnsupportedOperationException();
        }
    }
}

