/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.ChannelSelectMenuIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChannelSelectMenuIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChannelSelectMenu
implements ChannelSelectMenuIF {
    private final transient String type;
    private final Text placeholder;
    private final String actionId;
    @Nullable
    private final String initialChannelId;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private ChannelSelectMenu(Text placeholder, String actionId) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.initialChannelId = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(ChannelSelectMenuIF.super.getType(), "type");
    }

    private ChannelSelectMenu(Text placeholder, String actionId, @Nullable String initialChannelId, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.initialChannelId = initialChannelId;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(ChannelSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty(value="initial_channel")
    public Optional<String> getInitialChannelId() {
        return Optional.ofNullable(this.initialChannelId);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final ChannelSelectMenu withPlaceholder(Text value) {
        if (this.placeholder == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "placeholder");
        return new ChannelSelectMenu(newValue, this.actionId, this.initialChannelId, this.confirmationDialog);
    }

    public final ChannelSelectMenu withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new ChannelSelectMenu(this.placeholder, newValue, this.initialChannelId, this.confirmationDialog);
    }

    public final ChannelSelectMenu withInitialChannelId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.initialChannelId, newValue)) {
            return this;
        }
        return new ChannelSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final ChannelSelectMenu withInitialChannelId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialChannelId, value)) {
            return this;
        }
        return new ChannelSelectMenu(this.placeholder, this.actionId, value, this.confirmationDialog);
    }

    public final ChannelSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new ChannelSelectMenu(this.placeholder, this.actionId, this.initialChannelId, newValue);
    }

    public final ChannelSelectMenu withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new ChannelSelectMenu(this.placeholder, this.actionId, this.initialChannelId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelSelectMenu && this.equalTo(0, (ChannelSelectMenu)another);
    }

    private boolean equalTo(int synthetic, ChannelSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && Objects.equals(this.initialChannelId, another.initialChannelId) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.placeholder.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.initialChannelId);
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.initialChannelId != null) {
            builder.append(", ");
            builder.append("initialChannelId=").append(this.initialChannelId);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChannelSelectMenu fromJson(Json json) {
        Builder builder = ChannelSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.initialChannelId != null) {
            builder.setInitialChannelId(json.initialChannelId);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static ChannelSelectMenu of(Text placeholder, String actionId) {
        return new ChannelSelectMenu(placeholder, actionId);
    }

    public static ChannelSelectMenu copyOf(ChannelSelectMenuIF instance) {
        if (instance instanceof ChannelSelectMenu) {
            return (ChannelSelectMenu)instance;
        }
        return ChannelSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChannelSelectMenuIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        @Nullable
        private String initialChannelId;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChannelSelectMenuIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof ChannelSelectMenuIF) {
                Optional<ConfirmationDialog> confirmationDialogOptional;
                instance = (ChannelSelectMenuIF)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                this.setPlaceholder(instance.getPlaceholder());
                Optional<String> initialChannelIdOptional = instance.getInitialChannelId();
                if (initialChannelIdOptional.isPresent()) {
                    this.setInitialChannelId(initialChannelIdOptional);
                }
            }
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setInitialChannelId(@Nullable String initialChannelId) {
            this.initialChannelId = initialChannelId;
            return this;
        }

        public final Builder setInitialChannelId(Optional<String> initialChannelId) {
            this.initialChannelId = initialChannelId.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public ChannelSelectMenu build() {
            this.checkRequiredAttributes();
            return new ChannelSelectMenu(this.placeholder, this.actionId, this.initialChannelId, this.confirmationDialog);
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build ChannelSelectMenu, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChannelSelectMenuIF", generator="Immutables")
    static final class Json
    implements ChannelSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        @Nullable
        Optional<String> initialChannelId = Optional.empty();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty(value="initial_channel")
        public void setInitialChannelId(Optional<String> initialChannelId) {
            this.initialChannelId = initialChannelId;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInitialChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

