/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.models.blocks.SlackFileObjectIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackFileObjectIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackFileObject
implements SlackFileObjectIF {
    @Nullable
    private final String url;
    @Nullable
    private final String id;

    private SlackFileObject(@Nullable String url, @Nullable String id) {
        this.url = url;
        this.id = id;
    }

    @Override
    @JsonProperty
    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    @Override
    @JsonProperty
    public Optional<String> getId() {
        return Optional.ofNullable(this.id);
    }

    public final SlackFileObject withUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.url, newValue)) {
            return this;
        }
        return new SlackFileObject(newValue, this.id);
    }

    public final SlackFileObject withUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new SlackFileObject(value, this.id);
    }

    public final SlackFileObject withId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.id, newValue)) {
            return this;
        }
        return new SlackFileObject(this.url, newValue);
    }

    public final SlackFileObject withId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new SlackFileObject(this.url, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackFileObject && this.equalTo(0, (SlackFileObject)another);
    }

    private boolean equalTo(int synthetic, SlackFileObject another) {
        return Objects.equals(this.url, another.url) && Objects.equals(this.id, another.id);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.id);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackFileObject{");
        if (this.url != null) {
            builder.append("url=").append(this.url);
        }
        if (this.id != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("id=").append(this.id);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackFileObject fromJson(Json json) {
        Builder builder = SlackFileObject.builder();
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.id != null) {
            builder.setId(json.id);
        }
        return builder.build();
    }

    public static SlackFileObject copyOf(SlackFileObjectIF instance) {
        if (instance instanceof SlackFileObject) {
            return (SlackFileObject)instance;
        }
        return SlackFileObject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackFileObjectIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String url;
        @Nullable
        private String id;

        private Builder() {
        }

        public final Builder from(SlackFileObjectIF instance) {
            Optional<String> idOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> urlOptional = instance.getUrl();
            if (urlOptional.isPresent()) {
                this.setUrl(urlOptional);
            }
            if ((idOptional = instance.getId()).isPresent()) {
                this.setId(idOptional);
            }
            return this;
        }

        public final Builder setUrl(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder setUrl(Optional<String> url) {
            this.url = url.orElse(null);
            return this;
        }

        public final Builder setId(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder setId(Optional<String> id) {
            this.id = id.orElse(null);
            return this;
        }

        public SlackFileObject build() {
            return new SlackFileObject(this.url, this.id);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackFileObjectIF", generator="Immutables")
    static final class Json
    implements SlackFileObjectIF {
        @Nullable
        Optional<String> url = Optional.empty();
        @Nullable
        Optional<String> id = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setUrl(Optional<String> url) {
            this.url = url;
        }

        @JsonProperty
        public void setId(Optional<String> id) {
            this.id = id;
        }

        @Override
        public Optional<String> getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getId() {
            throw new UnsupportedOperationException();
        }
    }
}

