/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.elements.BlockElement;
import com.hubspot.slack.client.models.blocks.objects.Text;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public interface SectionIF
extends Block {
    public static final String TYPE = "section";

    @Override
    @Value.Derived
    default public String getType() {
        return TYPE;
    }

    @Nullable
    @Value.Default
    @Value.Parameter
    default public Text getText() {
        return null;
    }

    public List<Text> getFields();

    public Optional<BlockElement> getAccessory();

    @Value.Check
    default public void check() {
        boolean hasNonEmptyTextField = this.getText() != null && !Strings.isNullOrEmpty((String)this.getText().getText());
        boolean hasFields = !this.getFields().isEmpty();
        Preconditions.checkState((hasNonEmptyTextField || hasFields ? 1 : 0) != 0, (Object)"Must include text if not providing a list of fields");
        boolean fieldsTextLengthValid = hasFields && this.getFields().stream().allMatch(item -> item.getText().length() <= 3000);
        boolean textLengthValid = this.getText() != null && this.getText().getText().length() <= 3000;
        Preconditions.checkState((textLengthValid || fieldsTextLengthValid ? 1 : 0) != 0, (Object)"The text length of a Section block cannot exceed 3000 characters");
    }
}

