/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.objects.Text;
import com.hubspot.slack.client.models.blocks.objects.TextType;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public interface HeaderIF
extends Block {
    public static final String TYPE = "header";

    @Override
    @Value.Derived
    default public String getType() {
        return TYPE;
    }

    @Value.Parameter
    public Text getText();

    @Value.Check
    default public void check() {
        boolean isTextTypeValid = this.getText().getType() == TextType.PLAIN_TEXT;
        Preconditions.checkState((boolean)isTextTypeValid, (Object)"The text type of a Header block must be plain_text");
        boolean isTextLengthValid = this.getText().getText().length() <= 3000;
        Preconditions.checkState((boolean)isTextLengthValid, (Object)"The text length of a Header block cannot exceed 3000 characters");
    }
}

