/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.ContextIF;
import com.hubspot.slack.client.models.blocks.json.ImageBlockOrTextDeserializer;
import com.hubspot.slack.client.models.blocks.objects.ImageBlockOrText;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ContextIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Context
implements ContextIF {
    @Nullable
    private final String blockId;
    private final transient String type;
    private final List<ImageBlockOrText> elements;

    private Context(Iterable<? extends ImageBlockOrText> elements) {
        this.elements = Context.createUnmodifiableList(false, Context.createSafeList(elements, true, false));
        this.blockId = null;
        this.type = Objects.requireNonNull(ContextIF.super.getType(), "type");
    }

    private Context(@Nullable String blockId, List<ImageBlockOrText> elements) {
        this.blockId = blockId;
        this.elements = elements;
        this.type = Objects.requireNonNull(ContextIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=ImageBlockOrTextDeserializer.class)
    public List<ImageBlockOrText> getElements() {
        return this.elements;
    }

    public final Context withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Context(newValue, this.elements);
    }

    public final Context withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Context(value, this.elements);
    }

    public final Context withElements(ImageBlockOrText ... elements) {
        List<ImageBlockOrText> newValue = Context.createUnmodifiableList(false, Context.createSafeList(Arrays.asList(elements), true, false));
        return new Context(this.blockId, newValue);
    }

    public final Context withElements(Iterable<? extends ImageBlockOrText> elements) {
        if (this.elements == elements) {
            return this;
        }
        List<ImageBlockOrText> newValue = Context.createUnmodifiableList(false, Context.createSafeList(elements, true, false));
        return new Context(this.blockId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Context && this.equalTo(0, (Context)another);
    }

    private boolean equalTo(int synthetic, Context another) {
        return Objects.equals(this.blockId, another.blockId) && this.type.equals(another.type) && this.elements.equals(another.elements);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.blockId);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.elements.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Context{");
        if (this.blockId != null) {
            builder.append("blockId=").append(this.blockId);
        }
        if (builder.length() > 8) {
            builder.append(", ");
        }
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("elements=").append(this.elements);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Context fromJson(Json json) {
        Builder builder = Context.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        if (json.elements != null) {
            builder.addAllElements(json.elements);
        }
        return builder.build();
    }

    public static Context of(List<ImageBlockOrText> elements) {
        return Context.of(elements);
    }

    public static Context of(Iterable<? extends ImageBlockOrText> elements) {
        return new Context(elements);
    }

    public static Context copyOf(ContextIF instance) {
        if (instance instanceof Context) {
            return (Context)instance;
        }
        return Context.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ContextIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String blockId;
        private List<ImageBlockOrText> elements = new ArrayList<ImageBlockOrText>();

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ContextIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> blockIdOptional;
            Block instance;
            long bits = 0L;
            if (object instanceof Block) {
                instance = (Block)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof ContextIF) {
                instance = (ContextIF)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
                this.addAllElements(instance.getElements());
            }
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public final Builder addElements(ImageBlockOrText element) {
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        public final Builder addElements(ImageBlockOrText ... elements) {
            for (ImageBlockOrText element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public final Builder setElements(Iterable<? extends ImageBlockOrText> elements) {
            this.elements.clear();
            return this.addAllElements(elements);
        }

        public final Builder addAllElements(Iterable<? extends ImageBlockOrText> elements) {
            for (ImageBlockOrText imageBlockOrText : elements) {
                this.elements.add(Objects.requireNonNull(imageBlockOrText, "elements element"));
            }
            return this;
        }

        public Context build() {
            return new Context(this.blockId, Context.createUnmodifiableList(true, this.elements));
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ContextIF", generator="Immutables")
    static final class Json
    implements ContextIF {
        @Nullable
        Optional<String> blockId = Optional.empty();
        @Nullable
        List<ImageBlockOrText> elements = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=ImageBlockOrTextDeserializer.class)
        public void setElements(List<ImageBlockOrText> elements) {
            this.elements = elements;
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ImageBlockOrText> getElements() {
            throw new UnsupportedOperationException();
        }
    }
}

