/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.auth.OAuthV2CredentialsIF;
import com.hubspot.slack.client.models.teams.SlackTeamLite;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OAuthV2CredentialsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class OAuthV2Credentials
extends OAuthV2CredentialsIF {
    private final String botAccessToken;
    private final SlackTeamLite team;
    @Nullable
    private final String scope;
    private final SlackUserLite authedUser;
    private final String botUserId;

    private OAuthV2Credentials(String botAccessToken, SlackTeamLite team, @Nullable String scope, SlackUserLite authedUser, String botUserId) {
        this.botAccessToken = botAccessToken;
        this.team = team;
        this.scope = scope;
        this.authedUser = authedUser;
        this.botUserId = botUserId;
    }

    @Override
    @JsonProperty(value="access_token")
    public String getBotAccessToken() {
        return this.botAccessToken;
    }

    @Override
    @JsonProperty
    public SlackTeamLite getTeam() {
        return this.team;
    }

    @Override
    @JsonProperty
    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    @Override
    @JsonProperty
    public SlackUserLite getAuthedUser() {
        return this.authedUser;
    }

    @Override
    @JsonProperty
    public String getBotUserId() {
        return this.botUserId;
    }

    public final OAuthV2Credentials withBotAccessToken(String value) {
        String newValue = Objects.requireNonNull(value, "botAccessToken");
        if (this.botAccessToken.equals(newValue)) {
            return this;
        }
        return new OAuthV2Credentials(newValue, this.team, this.scope, this.authedUser, this.botUserId);
    }

    public final OAuthV2Credentials withTeam(SlackTeamLite value) {
        if (this.team == value) {
            return this;
        }
        SlackTeamLite newValue = Objects.requireNonNull(value, "team");
        return new OAuthV2Credentials(this.botAccessToken, newValue, this.scope, this.authedUser, this.botUserId);
    }

    public final OAuthV2Credentials withScope(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.scope, newValue)) {
            return this;
        }
        return new OAuthV2Credentials(this.botAccessToken, this.team, newValue, this.authedUser, this.botUserId);
    }

    public final OAuthV2Credentials withScope(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new OAuthV2Credentials(this.botAccessToken, this.team, value, this.authedUser, this.botUserId);
    }

    public final OAuthV2Credentials withAuthedUser(SlackUserLite value) {
        if (this.authedUser == value) {
            return this;
        }
        SlackUserLite newValue = Objects.requireNonNull(value, "authedUser");
        return new OAuthV2Credentials(this.botAccessToken, this.team, this.scope, newValue, this.botUserId);
    }

    public final OAuthV2Credentials withBotUserId(String value) {
        String newValue = Objects.requireNonNull(value, "botUserId");
        if (this.botUserId.equals(newValue)) {
            return this;
        }
        return new OAuthV2Credentials(this.botAccessToken, this.team, this.scope, this.authedUser, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OAuthV2Credentials && this.equalTo(0, (OAuthV2Credentials)another);
    }

    private boolean equalTo(int synthetic, OAuthV2Credentials another) {
        return this.botAccessToken.equals(another.botAccessToken) && this.team.equals(another.team) && Objects.equals(this.scope, another.scope) && this.authedUser.equals(another.authedUser) && this.botUserId.equals(another.botUserId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.botAccessToken.hashCode();
        h += (h << 5) + this.team.hashCode();
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + this.authedUser.hashCode();
        h += (h << 5) + this.botUserId.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OAuthV2Credentials{");
        builder.append("botAccessToken=").append(this.botAccessToken);
        builder.append(", ");
        builder.append("team=").append(this.team);
        if (this.scope != null) {
            builder.append(", ");
            builder.append("scope=").append(this.scope);
        }
        builder.append(", ");
        builder.append("authedUser=").append(this.authedUser);
        builder.append(", ");
        builder.append("botUserId=").append(this.botUserId);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static OAuthV2Credentials fromJson(Json json) {
        Builder builder = OAuthV2Credentials.builder();
        if (json.botAccessToken != null) {
            builder.setBotAccessToken(json.botAccessToken);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        if (json.scope != null) {
            builder.setScope(json.scope);
        }
        if (json.authedUser != null) {
            builder.setAuthedUser(json.authedUser);
        }
        if (json.botUserId != null) {
            builder.setBotUserId(json.botUserId);
        }
        return builder.build();
    }

    public static OAuthV2Credentials copyOf(OAuthV2CredentialsIF instance) {
        if (instance instanceof OAuthV2Credentials) {
            return (OAuthV2Credentials)instance;
        }
        return OAuthV2Credentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OAuthV2CredentialsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_BOT_ACCESS_TOKEN = 1L;
        private static final long INIT_BIT_TEAM = 2L;
        private static final long INIT_BIT_AUTHED_USER = 4L;
        private static final long INIT_BIT_BOT_USER_ID = 8L;
        private long initBits = 15L;
        @Nullable
        private String botAccessToken;
        @Nullable
        private SlackTeamLite team;
        @Nullable
        private String scope;
        @Nullable
        private SlackUserLite authedUser;
        @Nullable
        private String botUserId;

        private Builder() {
        }

        public final Builder from(OAuthV2CredentialsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setBotAccessToken(instance.getBotAccessToken());
            this.setTeam(instance.getTeam());
            Optional<String> scopeOptional = instance.getScope();
            if (scopeOptional.isPresent()) {
                this.setScope(scopeOptional);
            }
            this.setAuthedUser(instance.getAuthedUser());
            this.setBotUserId(instance.getBotUserId());
            return this;
        }

        public final Builder setBotAccessToken(String botAccessToken) {
            this.botAccessToken = Objects.requireNonNull(botAccessToken, "botAccessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTeam(SlackTeamLite team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setScope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        public final Builder setScope(Optional<String> scope) {
            this.scope = scope.orElse(null);
            return this;
        }

        public final Builder setAuthedUser(SlackUserLite authedUser) {
            this.authedUser = Objects.requireNonNull(authedUser, "authedUser");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setBotUserId(String botUserId) {
            this.botUserId = Objects.requireNonNull(botUserId, "botUserId");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public OAuthV2Credentials build() {
            this.checkRequiredAttributes();
            return new OAuthV2Credentials(this.botAccessToken, this.team, this.scope, this.authedUser, this.botUserId);
        }

        private boolean botAccessTokenIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean authedUserIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean botUserIdIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.botAccessTokenIsSet()) {
                attributes.add("botAccessToken");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            if (!this.authedUserIsSet()) {
                attributes.add("authedUser");
            }
            if (!this.botUserIdIsSet()) {
                attributes.add("botUserId");
            }
            return "Cannot build OAuthV2Credentials, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OAuthV2CredentialsIF", generator="Immutables")
    static final class Json
    extends OAuthV2CredentialsIF {
        @Nullable
        String botAccessToken;
        @Nullable
        SlackTeamLite team;
        @Nullable
        Optional<String> scope = Optional.empty();
        @Nullable
        SlackUserLite authedUser;
        @Nullable
        String botUserId;

        Json() {
        }

        @JsonProperty(value="access_token")
        public void setBotAccessToken(String botAccessToken) {
            this.botAccessToken = botAccessToken;
        }

        @JsonProperty
        public void setTeam(SlackTeamLite team) {
            this.team = team;
        }

        @JsonProperty
        public void setScope(Optional<String> scope) {
            this.scope = scope;
        }

        @JsonProperty
        public void setAuthedUser(SlackUserLite authedUser) {
            this.authedUser = authedUser;
        }

        @JsonProperty
        public void setBotUserId(String botUserId) {
            this.botUserId = botUserId;
        }

        @Override
        public String getBotAccessToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackTeamLite getTeam() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackUserLite getAuthedUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getBotUserId() {
            throw new UnsupportedOperationException();
        }
    }
}

