/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.auth.IncomingWebhookIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="IncomingWebhookIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class IncomingWebhook
implements IncomingWebhookIF {
    private final String url;
    private final String channel;
    private final String configurationUrl;

    private IncomingWebhook(String url, String channel, String configurationUrl) {
        this.url = url;
        this.channel = channel;
        this.configurationUrl = configurationUrl;
    }

    @Override
    @JsonProperty
    public String getUrl() {
        return this.url;
    }

    @Override
    @JsonProperty
    public String getChannel() {
        return this.channel;
    }

    @Override
    @JsonProperty
    public String getConfigurationUrl() {
        return this.configurationUrl;
    }

    public final IncomingWebhook withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new IncomingWebhook(newValue, this.channel, this.configurationUrl);
    }

    public final IncomingWebhook withChannel(String value) {
        String newValue = Objects.requireNonNull(value, "channel");
        if (this.channel.equals(newValue)) {
            return this;
        }
        return new IncomingWebhook(this.url, newValue, this.configurationUrl);
    }

    public final IncomingWebhook withConfigurationUrl(String value) {
        String newValue = Objects.requireNonNull(value, "configurationUrl");
        if (this.configurationUrl.equals(newValue)) {
            return this;
        }
        return new IncomingWebhook(this.url, this.channel, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof IncomingWebhook && this.equalTo(0, (IncomingWebhook)another);
    }

    private boolean equalTo(int synthetic, IncomingWebhook another) {
        return this.url.equals(another.url) && this.channel.equals(another.channel) && this.configurationUrl.equals(another.configurationUrl);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.channel.hashCode();
        h += (h << 5) + this.configurationUrl.hashCode();
        return h;
    }

    public String toString() {
        return "IncomingWebhook{url=" + this.url + ", channel=" + this.channel + ", configurationUrl=" + this.configurationUrl + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static IncomingWebhook fromJson(Json json) {
        Builder builder = IncomingWebhook.builder();
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.channel != null) {
            builder.setChannel(json.channel);
        }
        if (json.configurationUrl != null) {
            builder.setConfigurationUrl(json.configurationUrl);
        }
        return builder.build();
    }

    public static IncomingWebhook copyOf(IncomingWebhookIF instance) {
        if (instance instanceof IncomingWebhook) {
            return (IncomingWebhook)instance;
        }
        return IncomingWebhook.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="IncomingWebhookIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_CHANNEL = 2L;
        private static final long INIT_BIT_CONFIGURATION_URL = 4L;
        private long initBits = 7L;
        @Nullable
        private String url;
        @Nullable
        private String channel;
        @Nullable
        private String configurationUrl;

        private Builder() {
        }

        public final Builder from(IncomingWebhookIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setUrl(instance.getUrl());
            this.setChannel(instance.getChannel());
            this.setConfigurationUrl(instance.getConfigurationUrl());
            return this;
        }

        public final Builder setUrl(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setChannel(String channel) {
            this.channel = Objects.requireNonNull(channel, "channel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setConfigurationUrl(String configurationUrl) {
            this.configurationUrl = Objects.requireNonNull(configurationUrl, "configurationUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public IncomingWebhook build() {
            this.checkRequiredAttributes();
            return new IncomingWebhook(this.url, this.channel, this.configurationUrl);
        }

        private boolean urlIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean channelIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean configurationUrlIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.urlIsSet()) {
                attributes.add("url");
            }
            if (!this.channelIsSet()) {
                attributes.add("channel");
            }
            if (!this.configurationUrlIsSet()) {
                attributes.add("configurationUrl");
            }
            return "Cannot build IncomingWebhook, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="IncomingWebhookIF", generator="Immutables")
    static final class Json
    implements IncomingWebhookIF {
        @Nullable
        String url;
        @Nullable
        String channel;
        @Nullable
        String configurationUrl;

        Json() {
        }

        @JsonProperty
        public void setUrl(String url) {
            this.url = url;
        }

        @JsonProperty
        public void setChannel(String channel) {
            this.channel = channel;
        }

        @JsonProperty
        public void setConfigurationUrl(String configurationUrl) {
            this.configurationUrl = configurationUrl;
        }

        @Override
        public String getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getConfigurationUrl() {
            throw new UnsupportedOperationException();
        }
    }
}

