/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.actions.ConfirmIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConfirmIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Confirm
implements ConfirmIF {
    private final String title;
    private final String text;
    private final String okText;
    private final String dismissText;

    private Confirm(String title, String text, String okText, String dismissText) {
        this.title = title;
        this.text = text;
        this.okText = okText;
        this.dismissText = dismissText;
    }

    @Override
    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public String getOkText() {
        return this.okText;
    }

    @Override
    @JsonProperty
    public String getDismissText() {
        return this.dismissText;
    }

    public final Confirm withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new Confirm(newValue, this.text, this.okText, this.dismissText);
    }

    public final Confirm withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new Confirm(this.title, newValue, this.okText, this.dismissText);
    }

    public final Confirm withOkText(String value) {
        String newValue = Objects.requireNonNull(value, "okText");
        if (this.okText.equals(newValue)) {
            return this;
        }
        return new Confirm(this.title, this.text, newValue, this.dismissText);
    }

    public final Confirm withDismissText(String value) {
        String newValue = Objects.requireNonNull(value, "dismissText");
        if (this.dismissText.equals(newValue)) {
            return this;
        }
        return new Confirm(this.title, this.text, this.okText, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Confirm && this.equalTo(0, (Confirm)another);
    }

    private boolean equalTo(int synthetic, Confirm another) {
        return this.title.equals(another.title) && this.text.equals(another.text) && this.okText.equals(another.okText) && this.dismissText.equals(another.dismissText);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.okText.hashCode();
        h += (h << 5) + this.dismissText.hashCode();
        return h;
    }

    public String toString() {
        return "Confirm{title=" + this.title + ", text=" + this.text + ", okText=" + this.okText + ", dismissText=" + this.dismissText + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Confirm fromJson(Json json) {
        Builder builder = Confirm.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.okText != null) {
            builder.setOkText(json.okText);
        }
        if (json.dismissText != null) {
            builder.setDismissText(json.dismissText);
        }
        return builder.build();
    }

    public static Confirm copyOf(ConfirmIF instance) {
        if (instance instanceof Confirm) {
            return (Confirm)instance;
        }
        return Confirm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfirmIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long INIT_BIT_OK_TEXT = 4L;
        private static final long INIT_BIT_DISMISS_TEXT = 8L;
        private long initBits = 15L;
        @Nullable
        private String title;
        @Nullable
        private String text;
        @Nullable
        private String okText;
        @Nullable
        private String dismissText;

        private Builder() {
        }

        public final Builder from(ConfirmIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setTitle(instance.getTitle());
            this.setText(instance.getText());
            this.setOkText(instance.getOkText());
            this.setDismissText(instance.getDismissText());
            return this;
        }

        public final Builder setTitle(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setOkText(String okText) {
            this.okText = Objects.requireNonNull(okText, "okText");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setDismissText(String dismissText) {
            this.dismissText = Objects.requireNonNull(dismissText, "dismissText");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Confirm build() {
            this.checkRequiredAttributes();
            return new Confirm(this.title, this.text, this.okText, this.dismissText);
        }

        private boolean titleIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean okTextIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean dismissTextIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.okTextIsSet()) {
                attributes.add("okText");
            }
            if (!this.dismissTextIsSet()) {
                attributes.add("dismissText");
            }
            return "Cannot build Confirm, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfirmIF", generator="Immutables")
    static final class Json
    implements ConfirmIF {
        @Nullable
        String title;
        @Nullable
        String text;
        @Nullable
        String okText;
        @Nullable
        String dismissText;

        Json() {
        }

        @JsonProperty
        public void setTitle(String title) {
            this.title = title;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty
        public void setOkText(String okText) {
            this.okText = okText;
        }

        @JsonProperty
        public void setDismissText(String dismissText) {
            this.dismissText = dismissText;
        }

        @Override
        public String getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getOkText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getDismissText() {
            throw new UnsupportedOperationException();
        }
    }
}

