/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.models.AttachmentIF;
import com.hubspot.slack.client.models.Field;
import com.hubspot.slack.client.models.actions.Action;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AttachmentIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Attachment
implements AttachmentIF {
    @Nullable
    private final String fallback;
    @Nullable
    private final String color;
    @Nullable
    private final String pretext;
    @Nullable
    private final String authorName;
    @Nullable
    private final String authorLink;
    @Nullable
    private final String authorIcon;
    @Nullable
    private final String title;
    @Nullable
    private final String titleLink;
    @Nullable
    private final String text;
    @Nullable
    private final String imageUrl;
    @Nullable
    private final String attachmentType;
    private final List<Field> fields;
    @Nullable
    private final String footer;
    @Nullable
    private final String footerIcon;
    @Nullable
    private final String thumbUrl;
    @Nullable
    private final String epochSeconds;
    @Nullable
    private final String callbackId;
    private final List<Action> actions;
    private final Set<String> mrkdwnIn;
    private final List<Block> blocks;

    private Attachment(@Nullable String fallback, @Nullable String color, @Nullable String pretext, @Nullable String authorName, @Nullable String authorLink, @Nullable String authorIcon, @Nullable String title, @Nullable String titleLink, @Nullable String text, @Nullable String imageUrl, @Nullable String attachmentType, List<Field> fields, @Nullable String footer, @Nullable String footerIcon, @Nullable String thumbUrl, @Nullable String epochSeconds, @Nullable String callbackId, List<Action> actions, Set<String> mrkdwnIn, List<Block> blocks) {
        this.fallback = fallback;
        this.color = color;
        this.pretext = pretext;
        this.authorName = authorName;
        this.authorLink = authorLink;
        this.authorIcon = authorIcon;
        this.title = title;
        this.titleLink = titleLink;
        this.text = text;
        this.imageUrl = imageUrl;
        this.attachmentType = attachmentType;
        this.fields = fields;
        this.footer = footer;
        this.footerIcon = footerIcon;
        this.thumbUrl = thumbUrl;
        this.epochSeconds = epochSeconds;
        this.callbackId = callbackId;
        this.actions = actions;
        this.mrkdwnIn = mrkdwnIn;
        this.blocks = blocks;
    }

    @Override
    @JsonProperty
    public Optional<String> getFallback() {
        return Optional.ofNullable(this.fallback);
    }

    @Override
    @JsonProperty
    public Optional<String> getColor() {
        return Optional.ofNullable(this.color);
    }

    @Override
    @JsonProperty
    public Optional<String> getPretext() {
        return Optional.ofNullable(this.pretext);
    }

    @Override
    @JsonProperty
    public Optional<String> getAuthorName() {
        return Optional.ofNullable(this.authorName);
    }

    @Override
    @JsonProperty
    public Optional<String> getAuthorLink() {
        return Optional.ofNullable(this.authorLink);
    }

    @Override
    @JsonProperty
    public Optional<String> getAuthorIcon() {
        return Optional.ofNullable(this.authorIcon);
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public Optional<String> getTitleLink() {
        return Optional.ofNullable(this.titleLink);
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public Optional<String> getImageUrl() {
        return Optional.ofNullable(this.imageUrl);
    }

    @Override
    @JsonProperty
    public Optional<String> getAttachmentType() {
        return Optional.ofNullable(this.attachmentType);
    }

    @Override
    @JsonProperty
    public List<Field> getFields() {
        return this.fields;
    }

    @Override
    @JsonProperty
    public Optional<String> getFooter() {
        return Optional.ofNullable(this.footer);
    }

    @Override
    @JsonProperty
    public Optional<String> getFooterIcon() {
        return Optional.ofNullable(this.footerIcon);
    }

    @Override
    @JsonProperty
    public Optional<String> getThumbUrl() {
        return Optional.ofNullable(this.thumbUrl);
    }

    @Override
    @JsonProperty(value="ts")
    public Optional<String> getEpochSeconds() {
        return Optional.ofNullable(this.epochSeconds);
    }

    @Override
    @JsonProperty
    public Optional<String> getCallbackId() {
        return Optional.ofNullable(this.callbackId);
    }

    @Override
    @JsonProperty
    public List<Action> getActions() {
        return this.actions;
    }

    @Override
    @JsonProperty
    public Set<String> getMrkdwnIn() {
        return this.mrkdwnIn;
    }

    @Override
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<Block> getBlocks() {
        return this.blocks;
    }

    public final Attachment withFallback(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.fallback, newValue)) {
            return this;
        }
        return new Attachment(newValue, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withFallback(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.fallback, value)) {
            return this;
        }
        return new Attachment(value, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withColor(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.color, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, newValue, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withColor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.color, value)) {
            return this;
        }
        return new Attachment(this.fallback, value, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withPretext(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.pretext, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, newValue, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withPretext(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.pretext, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, value, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withAuthorName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.authorName, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, newValue, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withAuthorName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.authorName, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, value, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withAuthorLink(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.authorLink, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, newValue, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withAuthorLink(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.authorLink, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, value, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withAuthorIcon(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.authorIcon, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, newValue, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withAuthorIcon(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.authorIcon, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, value, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, newValue, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, value, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withTitleLink(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.titleLink, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, newValue, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withTitleLink(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.titleLink, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, value, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, newValue, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, value, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withImageUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.imageUrl, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, newValue, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withImageUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.imageUrl, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, value, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withAttachmentType(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.attachmentType, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, newValue, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withAttachmentType(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.attachmentType, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, value, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withFields(Field ... elements) {
        List<Field> newValue = Attachment.createUnmodifiableList(false, Attachment.createSafeList(Arrays.asList(elements), true, false));
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, newValue, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withFields(Iterable<? extends Field> elements) {
        if (this.fields == elements) {
            return this;
        }
        List<Field> newValue = Attachment.createUnmodifiableList(false, Attachment.createSafeList(elements, true, false));
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, newValue, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withFooter(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.footer, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, newValue, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withFooter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.footer, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, value, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withFooterIcon(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.footerIcon, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, newValue, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withFooterIcon(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.footerIcon, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, value, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withThumbUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.thumbUrl, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, newValue, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withThumbUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.thumbUrl, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, value, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withEpochSeconds(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.epochSeconds, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, newValue, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withEpochSeconds(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.epochSeconds, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, value, this.callbackId, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withCallbackId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.callbackId, newValue)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, newValue, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withCallbackId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.callbackId, value)) {
            return this;
        }
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, value, this.actions, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withActions(Action ... elements) {
        List<Action> newValue = Attachment.createUnmodifiableList(false, Attachment.createSafeList(Arrays.asList(elements), true, false));
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, newValue, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withActions(Iterable<? extends Action> elements) {
        if (this.actions == elements) {
            return this;
        }
        List<Action> newValue = Attachment.createUnmodifiableList(false, Attachment.createSafeList(elements, true, false));
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, newValue, this.mrkdwnIn, this.blocks);
    }

    public final Attachment withMrkdwnIn(String ... elements) {
        Set<String> newValue = Attachment.createUnmodifiableSet(Attachment.createSafeList(Arrays.asList(elements), true, false));
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, newValue, this.blocks);
    }

    public final Attachment withMrkdwnIn(Iterable<String> elements) {
        if (this.mrkdwnIn == elements) {
            return this;
        }
        Set<String> newValue = Attachment.createUnmodifiableSet(Attachment.createSafeList(elements, true, false));
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, newValue, this.blocks);
    }

    public final Attachment withBlocks(Block ... elements) {
        List<Block> newValue = Attachment.createUnmodifiableList(false, Attachment.createSafeList(Arrays.asList(elements), true, false));
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, newValue);
    }

    public final Attachment withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = Attachment.createUnmodifiableList(false, Attachment.createSafeList(elements, true, false));
        return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, this.fields, this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, this.actions, this.mrkdwnIn, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Attachment && this.equalTo(0, (Attachment)another);
    }

    private boolean equalTo(int synthetic, Attachment another) {
        return Objects.equals(this.fallback, another.fallback) && Objects.equals(this.color, another.color) && Objects.equals(this.pretext, another.pretext) && Objects.equals(this.authorName, another.authorName) && Objects.equals(this.authorLink, another.authorLink) && Objects.equals(this.authorIcon, another.authorIcon) && Objects.equals(this.title, another.title) && Objects.equals(this.titleLink, another.titleLink) && Objects.equals(this.text, another.text) && Objects.equals(this.imageUrl, another.imageUrl) && Objects.equals(this.attachmentType, another.attachmentType) && this.fields.equals(another.fields) && Objects.equals(this.footer, another.footer) && Objects.equals(this.footerIcon, another.footerIcon) && Objects.equals(this.thumbUrl, another.thumbUrl) && Objects.equals(this.epochSeconds, another.epochSeconds) && Objects.equals(this.callbackId, another.callbackId) && this.actions.equals(another.actions) && this.mrkdwnIn.equals(another.mrkdwnIn) && this.blocks.equals(another.blocks);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.fallback);
        h += (h << 5) + Objects.hashCode(this.color);
        h += (h << 5) + Objects.hashCode(this.pretext);
        h += (h << 5) + Objects.hashCode(this.authorName);
        h += (h << 5) + Objects.hashCode(this.authorLink);
        h += (h << 5) + Objects.hashCode(this.authorIcon);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + Objects.hashCode(this.titleLink);
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + Objects.hashCode(this.imageUrl);
        h += (h << 5) + Objects.hashCode(this.attachmentType);
        h += (h << 5) + this.fields.hashCode();
        h += (h << 5) + Objects.hashCode(this.footer);
        h += (h << 5) + Objects.hashCode(this.footerIcon);
        h += (h << 5) + Objects.hashCode(this.thumbUrl);
        h += (h << 5) + Objects.hashCode(this.epochSeconds);
        h += (h << 5) + Objects.hashCode(this.callbackId);
        h += (h << 5) + this.actions.hashCode();
        h += (h << 5) + this.mrkdwnIn.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Attachment{");
        if (this.fallback != null) {
            builder.append("fallback=").append(this.fallback);
        }
        if (this.color != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("color=").append(this.color);
        }
        if (this.pretext != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("pretext=").append(this.pretext);
        }
        if (this.authorName != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("authorName=").append(this.authorName);
        }
        if (this.authorLink != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("authorLink=").append(this.authorLink);
        }
        if (this.authorIcon != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("authorIcon=").append(this.authorIcon);
        }
        if (this.title != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("title=").append(this.title);
        }
        if (this.titleLink != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("titleLink=").append(this.titleLink);
        }
        if (this.text != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("text=").append(this.text);
        }
        if (this.imageUrl != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("imageUrl=").append(this.imageUrl);
        }
        if (this.attachmentType != null) {
            if (builder.length() > 11) {
                builder.append(", ");
            }
            builder.append("attachmentType=").append(this.attachmentType);
        }
        if (builder.length() > 11) {
            builder.append(", ");
        }
        builder.append("fields=").append(this.fields);
        if (this.footer != null) {
            builder.append(", ");
            builder.append("footer=").append(this.footer);
        }
        if (this.footerIcon != null) {
            builder.append(", ");
            builder.append("footerIcon=").append(this.footerIcon);
        }
        if (this.thumbUrl != null) {
            builder.append(", ");
            builder.append("thumbUrl=").append(this.thumbUrl);
        }
        if (this.epochSeconds != null) {
            builder.append(", ");
            builder.append("epochSeconds=").append(this.epochSeconds);
        }
        if (this.callbackId != null) {
            builder.append(", ");
            builder.append("callbackId=").append(this.callbackId);
        }
        builder.append(", ");
        builder.append("actions=").append(this.actions);
        builder.append(", ");
        builder.append("mrkdwnIn=").append(this.mrkdwnIn);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Attachment fromJson(Json json) {
        Builder builder = Attachment.builder();
        if (json.fallback != null) {
            builder.setFallback(json.fallback);
        }
        if (json.color != null) {
            builder.setColor(json.color);
        }
        if (json.pretext != null) {
            builder.setPretext(json.pretext);
        }
        if (json.authorName != null) {
            builder.setAuthorName(json.authorName);
        }
        if (json.authorLink != null) {
            builder.setAuthorLink(json.authorLink);
        }
        if (json.authorIcon != null) {
            builder.setAuthorIcon(json.authorIcon);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.titleLink != null) {
            builder.setTitleLink(json.titleLink);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.imageUrl != null) {
            builder.setImageUrl(json.imageUrl);
        }
        if (json.attachmentType != null) {
            builder.setAttachmentType(json.attachmentType);
        }
        if (json.fields != null) {
            builder.addAllFields(json.fields);
        }
        if (json.footer != null) {
            builder.setFooter(json.footer);
        }
        if (json.footerIcon != null) {
            builder.setFooterIcon(json.footerIcon);
        }
        if (json.thumbUrl != null) {
            builder.setThumbUrl(json.thumbUrl);
        }
        if (json.epochSeconds != null) {
            builder.setEpochSeconds(json.epochSeconds);
        }
        if (json.callbackId != null) {
            builder.setCallbackId(json.callbackId);
        }
        if (json.actions != null) {
            builder.addAllActions(json.actions);
        }
        if (json.mrkdwnIn != null) {
            builder.addAllMrkdwnIn(json.mrkdwnIn);
        }
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        return builder.build();
    }

    public static Attachment copyOf(AttachmentIF instance) {
        if (instance instanceof Attachment) {
            return (Attachment)instance;
        }
        return Attachment.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="AttachmentIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String fallback;
        @Nullable
        private String color;
        @Nullable
        private String pretext;
        @Nullable
        private String authorName;
        @Nullable
        private String authorLink;
        @Nullable
        private String authorIcon;
        @Nullable
        private String title;
        @Nullable
        private String titleLink;
        @Nullable
        private String text;
        @Nullable
        private String imageUrl;
        @Nullable
        private String attachmentType;
        private List<Field> fields = new ArrayList<Field>();
        @Nullable
        private String footer;
        @Nullable
        private String footerIcon;
        @Nullable
        private String thumbUrl;
        @Nullable
        private String epochSeconds;
        @Nullable
        private String callbackId;
        private List<Action> actions = new ArrayList<Action>();
        private List<String> mrkdwnIn = new ArrayList<String>();
        private List<Block> blocks = new ArrayList<Block>();

        private Builder() {
        }

        public final Builder from(AttachmentIF instance) {
            Optional<String> callbackIdOptional;
            Optional<String> epochSecondsOptional;
            Optional<String> thumbUrlOptional;
            Optional<String> footerIconOptional;
            Optional<String> attachmentTypeOptional;
            Optional<String> imageUrlOptional;
            Optional<String> textOptional;
            Optional<String> titleLinkOptional;
            Optional<String> titleOptional;
            Optional<String> authorIconOptional;
            Optional<String> authorLinkOptional;
            Optional<String> authorNameOptional;
            Optional<String> pretextOptional;
            Optional<String> colorOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> fallbackOptional = instance.getFallback();
            if (fallbackOptional.isPresent()) {
                this.setFallback(fallbackOptional);
            }
            if ((colorOptional = instance.getColor()).isPresent()) {
                this.setColor(colorOptional);
            }
            if ((pretextOptional = instance.getPretext()).isPresent()) {
                this.setPretext(pretextOptional);
            }
            if ((authorNameOptional = instance.getAuthorName()).isPresent()) {
                this.setAuthorName(authorNameOptional);
            }
            if ((authorLinkOptional = instance.getAuthorLink()).isPresent()) {
                this.setAuthorLink(authorLinkOptional);
            }
            if ((authorIconOptional = instance.getAuthorIcon()).isPresent()) {
                this.setAuthorIcon(authorIconOptional);
            }
            if ((titleOptional = instance.getTitle()).isPresent()) {
                this.setTitle(titleOptional);
            }
            if ((titleLinkOptional = instance.getTitleLink()).isPresent()) {
                this.setTitleLink(titleLinkOptional);
            }
            if ((textOptional = instance.getText()).isPresent()) {
                this.setText(textOptional);
            }
            if ((imageUrlOptional = instance.getImageUrl()).isPresent()) {
                this.setImageUrl(imageUrlOptional);
            }
            if ((attachmentTypeOptional = instance.getAttachmentType()).isPresent()) {
                this.setAttachmentType(attachmentTypeOptional);
            }
            this.addAllFields(instance.getFields());
            Optional<String> footerOptional = instance.getFooter();
            if (footerOptional.isPresent()) {
                this.setFooter(footerOptional);
            }
            if ((footerIconOptional = instance.getFooterIcon()).isPresent()) {
                this.setFooterIcon(footerIconOptional);
            }
            if ((thumbUrlOptional = instance.getThumbUrl()).isPresent()) {
                this.setThumbUrl(thumbUrlOptional);
            }
            if ((epochSecondsOptional = instance.getEpochSeconds()).isPresent()) {
                this.setEpochSeconds(epochSecondsOptional);
            }
            if ((callbackIdOptional = instance.getCallbackId()).isPresent()) {
                this.setCallbackId(callbackIdOptional);
            }
            this.addAllActions(instance.getActions());
            this.addAllMrkdwnIn(instance.getMrkdwnIn());
            this.addAllBlocks(instance.getBlocks());
            return this;
        }

        public final Builder setFallback(@Nullable String fallback) {
            this.fallback = fallback;
            return this;
        }

        public final Builder setFallback(Optional<String> fallback) {
            this.fallback = fallback.orElse(null);
            return this;
        }

        public final Builder setColor(@Nullable String color) {
            this.color = color;
            return this;
        }

        public final Builder setColor(Optional<String> color) {
            this.color = color.orElse(null);
            return this;
        }

        public final Builder setPretext(@Nullable String pretext) {
            this.pretext = pretext;
            return this;
        }

        public final Builder setPretext(Optional<String> pretext) {
            this.pretext = pretext.orElse(null);
            return this;
        }

        public final Builder setAuthorName(@Nullable String authorName) {
            this.authorName = authorName;
            return this;
        }

        public final Builder setAuthorName(Optional<String> authorName) {
            this.authorName = authorName.orElse(null);
            return this;
        }

        public final Builder setAuthorLink(@Nullable String authorLink) {
            this.authorLink = authorLink;
            return this;
        }

        public final Builder setAuthorLink(Optional<String> authorLink) {
            this.authorLink = authorLink.orElse(null);
            return this;
        }

        public final Builder setAuthorIcon(@Nullable String authorIcon) {
            this.authorIcon = authorIcon;
            return this;
        }

        public final Builder setAuthorIcon(Optional<String> authorIcon) {
            this.authorIcon = authorIcon.orElse(null);
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder setTitleLink(@Nullable String titleLink) {
            this.titleLink = titleLink;
            return this;
        }

        public final Builder setTitleLink(Optional<String> titleLink) {
            this.titleLink = titleLink.orElse(null);
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder setImageUrl(@Nullable String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public final Builder setImageUrl(Optional<String> imageUrl) {
            this.imageUrl = imageUrl.orElse(null);
            return this;
        }

        public final Builder setAttachmentType(@Nullable String attachmentType) {
            this.attachmentType = attachmentType;
            return this;
        }

        public final Builder setAttachmentType(Optional<String> attachmentType) {
            this.attachmentType = attachmentType.orElse(null);
            return this;
        }

        public final Builder addFields(Field element) {
            this.fields.add(Objects.requireNonNull(element, "fields element"));
            return this;
        }

        public final Builder addFields(Field ... elements) {
            for (Field element : elements) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
            }
            return this;
        }

        public final Builder setFields(Iterable<? extends Field> elements) {
            this.fields.clear();
            return this.addAllFields(elements);
        }

        public final Builder addAllFields(Iterable<? extends Field> elements) {
            for (Field field : elements) {
                this.fields.add(Objects.requireNonNull(field, "fields element"));
            }
            return this;
        }

        public final Builder setFooter(@Nullable String footer) {
            this.footer = footer;
            return this;
        }

        public final Builder setFooter(Optional<String> footer) {
            this.footer = footer.orElse(null);
            return this;
        }

        public final Builder setFooterIcon(@Nullable String footerIcon) {
            this.footerIcon = footerIcon;
            return this;
        }

        public final Builder setFooterIcon(Optional<String> footerIcon) {
            this.footerIcon = footerIcon.orElse(null);
            return this;
        }

        public final Builder setThumbUrl(@Nullable String thumbUrl) {
            this.thumbUrl = thumbUrl;
            return this;
        }

        public final Builder setThumbUrl(Optional<String> thumbUrl) {
            this.thumbUrl = thumbUrl.orElse(null);
            return this;
        }

        public final Builder setEpochSeconds(@Nullable String epochSeconds) {
            this.epochSeconds = epochSeconds;
            return this;
        }

        public final Builder setEpochSeconds(Optional<String> epochSeconds) {
            this.epochSeconds = epochSeconds.orElse(null);
            return this;
        }

        public final Builder setCallbackId(@Nullable String callbackId) {
            this.callbackId = callbackId;
            return this;
        }

        public final Builder setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId.orElse(null);
            return this;
        }

        public final Builder addActions(Action element) {
            this.actions.add(Objects.requireNonNull(element, "actions element"));
            return this;
        }

        public final Builder addActions(Action ... elements) {
            for (Action element : elements) {
                this.actions.add(Objects.requireNonNull(element, "actions element"));
            }
            return this;
        }

        public final Builder setActions(Iterable<? extends Action> elements) {
            this.actions.clear();
            return this.addAllActions(elements);
        }

        public final Builder addAllActions(Iterable<? extends Action> elements) {
            for (Action action : elements) {
                this.actions.add(Objects.requireNonNull(action, "actions element"));
            }
            return this;
        }

        public final Builder addMrkdwnIn(String element) {
            this.mrkdwnIn.add(Objects.requireNonNull(element, "mrkdwnIn element"));
            return this;
        }

        public final Builder addMrkdwnIn(String ... elements) {
            for (String element : elements) {
                this.mrkdwnIn.add(Objects.requireNonNull(element, "mrkdwnIn element"));
            }
            return this;
        }

        public final Builder setMrkdwnIn(Iterable<String> elements) {
            this.mrkdwnIn.clear();
            return this.addAllMrkdwnIn(elements);
        }

        public final Builder addAllMrkdwnIn(Iterable<String> elements) {
            for (String element : elements) {
                this.mrkdwnIn.add(Objects.requireNonNull(element, "mrkdwnIn element"));
            }
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public Attachment build() {
            return new Attachment(this.fallback, this.color, this.pretext, this.authorName, this.authorLink, this.authorIcon, this.title, this.titleLink, this.text, this.imageUrl, this.attachmentType, Attachment.createUnmodifiableList(true, this.fields), this.footer, this.footerIcon, this.thumbUrl, this.epochSeconds, this.callbackId, Attachment.createUnmodifiableList(true, this.actions), Attachment.createUnmodifiableSet(this.mrkdwnIn), Attachment.createUnmodifiableList(true, this.blocks));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AttachmentIF", generator="Immutables")
    static final class Json
    implements AttachmentIF {
        @Nullable
        Optional<String> fallback = Optional.empty();
        @Nullable
        Optional<String> color = Optional.empty();
        @Nullable
        Optional<String> pretext = Optional.empty();
        @Nullable
        Optional<String> authorName = Optional.empty();
        @Nullable
        Optional<String> authorLink = Optional.empty();
        @Nullable
        Optional<String> authorIcon = Optional.empty();
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        Optional<String> titleLink = Optional.empty();
        @Nullable
        Optional<String> text = Optional.empty();
        @Nullable
        Optional<String> imageUrl = Optional.empty();
        @Nullable
        Optional<String> attachmentType = Optional.empty();
        @Nullable
        List<Field> fields = Collections.emptyList();
        @Nullable
        Optional<String> footer = Optional.empty();
        @Nullable
        Optional<String> footerIcon = Optional.empty();
        @Nullable
        Optional<String> thumbUrl = Optional.empty();
        @Nullable
        Optional<String> epochSeconds = Optional.empty();
        @Nullable
        Optional<String> callbackId = Optional.empty();
        @Nullable
        List<Action> actions = Collections.emptyList();
        @Nullable
        Set<String> mrkdwnIn = Collections.emptySet();
        @Nullable
        List<Block> blocks = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setFallback(Optional<String> fallback) {
            this.fallback = fallback;
        }

        @JsonProperty
        public void setColor(Optional<String> color) {
            this.color = color;
        }

        @JsonProperty
        public void setPretext(Optional<String> pretext) {
            this.pretext = pretext;
        }

        @JsonProperty
        public void setAuthorName(Optional<String> authorName) {
            this.authorName = authorName;
        }

        @JsonProperty
        public void setAuthorLink(Optional<String> authorLink) {
            this.authorLink = authorLink;
        }

        @JsonProperty
        public void setAuthorIcon(Optional<String> authorIcon) {
            this.authorIcon = authorIcon;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setTitleLink(Optional<String> titleLink) {
            this.titleLink = titleLink;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setImageUrl(Optional<String> imageUrl) {
            this.imageUrl = imageUrl;
        }

        @JsonProperty
        public void setAttachmentType(Optional<String> attachmentType) {
            this.attachmentType = attachmentType;
        }

        @JsonProperty
        public void setFields(List<Field> fields) {
            this.fields = fields;
        }

        @JsonProperty
        public void setFooter(Optional<String> footer) {
            this.footer = footer;
        }

        @JsonProperty
        public void setFooterIcon(Optional<String> footerIcon) {
            this.footerIcon = footerIcon;
        }

        @JsonProperty
        public void setThumbUrl(Optional<String> thumbUrl) {
            this.thumbUrl = thumbUrl;
        }

        @JsonProperty(value="ts")
        public void setEpochSeconds(Optional<String> epochSeconds) {
            this.epochSeconds = epochSeconds;
        }

        @JsonProperty
        public void setCallbackId(Optional<String> callbackId) {
            this.callbackId = callbackId;
        }

        @JsonProperty
        public void setActions(List<Action> actions) {
            this.actions = actions;
        }

        @JsonProperty
        public void setMrkdwnIn(Set<String> mrkdwnIn) {
            this.mrkdwnIn = mrkdwnIn;
        }

        @JsonProperty
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @Override
        public Optional<String> getFallback() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getColor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPretext() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAuthorName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAuthorLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAuthorIcon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitleLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getImageUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getAttachmentType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Field> getFields() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getFooter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getFooterIcon() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThumbUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCallbackId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Action> getActions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getMrkdwnIn() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }
    }
}

