/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupListParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsergroupListParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsergroupListParams
implements UsergroupListParamsIF {
    @Nullable
    private final Boolean includeCount;
    @Nullable
    private final Boolean includeDisabled;
    @Nullable
    private final Boolean includeUsers;

    private UsergroupListParams(@Nullable Boolean includeCount, @Nullable Boolean includeDisabled, @Nullable Boolean includeUsers) {
        this.includeCount = includeCount;
        this.includeDisabled = includeDisabled;
        this.includeUsers = includeUsers;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeCount() {
        return Optional.ofNullable(this.includeCount);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeDisabled() {
        return Optional.ofNullable(this.includeDisabled);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeUsers() {
        return Optional.ofNullable(this.includeUsers);
    }

    public final UsergroupListParams withIncludeCount(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeCount, newValue)) {
            return this;
        }
        return new UsergroupListParams(newValue, this.includeDisabled, this.includeUsers);
    }

    public final UsergroupListParams withIncludeCount(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeCount, value)) {
            return this;
        }
        return new UsergroupListParams(value, this.includeDisabled, this.includeUsers);
    }

    public final UsergroupListParams withIncludeDisabled(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeDisabled, newValue)) {
            return this;
        }
        return new UsergroupListParams(this.includeCount, newValue, this.includeUsers);
    }

    public final UsergroupListParams withIncludeDisabled(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeDisabled, value)) {
            return this;
        }
        return new UsergroupListParams(this.includeCount, value, this.includeUsers);
    }

    public final UsergroupListParams withIncludeUsers(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeUsers, newValue)) {
            return this;
        }
        return new UsergroupListParams(this.includeCount, this.includeDisabled, newValue);
    }

    public final UsergroupListParams withIncludeUsers(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeUsers, value)) {
            return this;
        }
        return new UsergroupListParams(this.includeCount, this.includeDisabled, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupListParams && this.equalTo(0, (UsergroupListParams)another);
    }

    private boolean equalTo(int synthetic, UsergroupListParams another) {
        return Objects.equals(this.includeCount, another.includeCount) && Objects.equals(this.includeDisabled, another.includeDisabled) && Objects.equals(this.includeUsers, another.includeUsers);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.includeCount);
        h += (h << 5) + Objects.hashCode(this.includeDisabled);
        h += (h << 5) + Objects.hashCode(this.includeUsers);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupListParams{");
        if (this.includeCount != null) {
            builder.append("includeCount=").append(this.includeCount);
        }
        if (this.includeDisabled != null) {
            if (builder.length() > 20) {
                builder.append(", ");
            }
            builder.append("includeDisabled=").append(this.includeDisabled);
        }
        if (this.includeUsers != null) {
            if (builder.length() > 20) {
                builder.append(", ");
            }
            builder.append("includeUsers=").append(this.includeUsers);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsergroupListParams fromJson(Json json) {
        Builder builder = UsergroupListParams.builder();
        if (json.includeCount != null) {
            builder.setIncludeCount(json.includeCount);
        }
        if (json.includeDisabled != null) {
            builder.setIncludeDisabled(json.includeDisabled);
        }
        if (json.includeUsers != null) {
            builder.setIncludeUsers(json.includeUsers);
        }
        return builder.build();
    }

    public static UsergroupListParams copyOf(UsergroupListParamsIF instance) {
        if (instance instanceof UsergroupListParams) {
            return (UsergroupListParams)instance;
        }
        return UsergroupListParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UsergroupListParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean includeCount;
        @Nullable
        private Boolean includeDisabled;
        @Nullable
        private Boolean includeUsers;

        private Builder() {
        }

        public final Builder from(UsergroupListParamsIF instance) {
            Optional<Boolean> includeUsersOptional;
            Optional<Boolean> includeDisabledOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<Boolean> includeCountOptional = instance.getIncludeCount();
            if (includeCountOptional.isPresent()) {
                this.setIncludeCount(includeCountOptional);
            }
            if ((includeDisabledOptional = instance.getIncludeDisabled()).isPresent()) {
                this.setIncludeDisabled(includeDisabledOptional);
            }
            if ((includeUsersOptional = instance.getIncludeUsers()).isPresent()) {
                this.setIncludeUsers(includeUsersOptional);
            }
            return this;
        }

        public final Builder setIncludeCount(@Nullable Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public final Builder setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount.orElse(null);
            return this;
        }

        public final Builder setIncludeDisabled(@Nullable Boolean includeDisabled) {
            this.includeDisabled = includeDisabled;
            return this;
        }

        public final Builder setIncludeDisabled(Optional<Boolean> includeDisabled) {
            this.includeDisabled = includeDisabled.orElse(null);
            return this;
        }

        public final Builder setIncludeUsers(@Nullable Boolean includeUsers) {
            this.includeUsers = includeUsers;
            return this;
        }

        public final Builder setIncludeUsers(Optional<Boolean> includeUsers) {
            this.includeUsers = includeUsers.orElse(null);
            return this;
        }

        public UsergroupListParams build() {
            return new UsergroupListParams(this.includeCount, this.includeDisabled, this.includeUsers);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsergroupListParamsIF", generator="Immutables")
    static final class Json
    implements UsergroupListParamsIF {
        @Nullable
        Optional<Boolean> includeCount = Optional.empty();
        @Nullable
        Optional<Boolean> includeDisabled = Optional.empty();
        @Nullable
        Optional<Boolean> includeUsers = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount;
        }

        @JsonProperty
        public void setIncludeDisabled(Optional<Boolean> includeDisabled) {
            this.includeDisabled = includeDisabled;
        }

        @JsonProperty
        public void setIncludeUsers(Optional<Boolean> includeUsers) {
            this.includeUsers = includeUsers;
        }

        @Override
        public Optional<Boolean> getIncludeCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeDisabled() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeUsers() {
            throw new UnsupportedOperationException();
        }
    }
}

