/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.usergroups.UsergroupEnableParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsergroupEnableParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsergroupEnableParams
implements UsergroupEnableParamsIF {
    private final String usergroupId;
    @Nullable
    private final Boolean includeCount;

    private UsergroupEnableParams(String usergroupId, @Nullable Boolean includeCount) {
        this.usergroupId = usergroupId;
        this.includeCount = includeCount;
    }

    @Override
    @JsonProperty(value="usergroup")
    public String getUsergroupId() {
        return this.usergroupId;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeCount() {
        return Optional.ofNullable(this.includeCount);
    }

    public final UsergroupEnableParams withUsergroupId(String value) {
        String newValue = Objects.requireNonNull(value, "usergroupId");
        if (this.usergroupId.equals(newValue)) {
            return this;
        }
        return new UsergroupEnableParams(newValue, this.includeCount);
    }

    public final UsergroupEnableParams withIncludeCount(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeCount, newValue)) {
            return this;
        }
        return new UsergroupEnableParams(this.usergroupId, newValue);
    }

    public final UsergroupEnableParams withIncludeCount(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeCount, value)) {
            return this;
        }
        return new UsergroupEnableParams(this.usergroupId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsergroupEnableParams && this.equalTo(0, (UsergroupEnableParams)another);
    }

    private boolean equalTo(int synthetic, UsergroupEnableParams another) {
        return this.usergroupId.equals(another.usergroupId) && Objects.equals(this.includeCount, another.includeCount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.usergroupId.hashCode();
        h += (h << 5) + Objects.hashCode(this.includeCount);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsergroupEnableParams{");
        builder.append("usergroupId=").append(this.usergroupId);
        if (this.includeCount != null) {
            builder.append(", ");
            builder.append("includeCount=").append(this.includeCount);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsergroupEnableParams fromJson(Json json) {
        Builder builder = UsergroupEnableParams.builder();
        if (json.usergroupId != null) {
            builder.setUsergroupId(json.usergroupId);
        }
        if (json.includeCount != null) {
            builder.setIncludeCount(json.includeCount);
        }
        return builder.build();
    }

    public static UsergroupEnableParams copyOf(UsergroupEnableParamsIF instance) {
        if (instance instanceof UsergroupEnableParams) {
            return (UsergroupEnableParams)instance;
        }
        return UsergroupEnableParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="UsergroupEnableParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERGROUP_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String usergroupId;
        @Nullable
        private Boolean includeCount;

        private Builder() {
        }

        public final Builder from(UsergroupEnableParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setUsergroupId(instance.getUsergroupId());
            Optional<Boolean> includeCountOptional = instance.getIncludeCount();
            if (includeCountOptional.isPresent()) {
                this.setIncludeCount(includeCountOptional);
            }
            return this;
        }

        public final Builder setUsergroupId(String usergroupId) {
            this.usergroupId = Objects.requireNonNull(usergroupId, "usergroupId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIncludeCount(@Nullable Boolean includeCount) {
            this.includeCount = includeCount;
            return this;
        }

        public final Builder setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount.orElse(null);
            return this;
        }

        public UsergroupEnableParams build() {
            this.checkRequiredAttributes();
            return new UsergroupEnableParams(this.usergroupId, this.includeCount);
        }

        private boolean usergroupIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.usergroupIdIsSet()) {
                attributes.add("usergroupId");
            }
            return "Cannot build UsergroupEnableParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsergroupEnableParamsIF", generator="Immutables")
    static final class Json
    implements UsergroupEnableParamsIF {
        @Nullable
        String usergroupId;
        @Nullable
        Optional<Boolean> includeCount = Optional.empty();

        Json() {
        }

        @JsonProperty(value="usergroup")
        public void setUsergroupId(String usergroupId) {
            this.usergroupId = usergroupId;
        }

        @JsonProperty
        public void setIncludeCount(Optional<Boolean> includeCount) {
            this.includeCount = includeCount;
        }

        @Override
        public String getUsergroupId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeCount() {
            throw new UnsupportedOperationException();
        }
    }
}

