/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.channels.BaseChannelsFilter;
import com.hubspot.slack.client.methods.params.group.GroupsListParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="GroupsListParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class GroupsListParams
implements GroupsListParamsIF {
    @Nullable
    private final Boolean shouldExcludeArchived;
    private final boolean shouldExcludeMembers;

    private GroupsListParams(Builder builder) {
        this.shouldExcludeArchived = builder.shouldExcludeArchived;
        this.shouldExcludeMembers = builder.shouldExcludeMembersIsSet() ? builder.shouldExcludeMembers : GroupsListParamsIF.super.shouldExcludeMembers();
    }

    private GroupsListParams(@Nullable Boolean shouldExcludeArchived, boolean shouldExcludeMembers) {
        this.shouldExcludeArchived = shouldExcludeArchived;
        this.shouldExcludeMembers = shouldExcludeMembers;
    }

    @Override
    @JsonProperty(value="exclude_archived")
    public Optional<Boolean> shouldExcludeArchived() {
        return Optional.ofNullable(this.shouldExcludeArchived);
    }

    @Override
    @JsonProperty(value="exclude_members")
    public boolean shouldExcludeMembers() {
        return this.shouldExcludeMembers;
    }

    public final GroupsListParams withShouldExcludeArchived(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.shouldExcludeArchived, newValue)) {
            return this;
        }
        return new GroupsListParams(newValue, this.shouldExcludeMembers);
    }

    public final GroupsListParams withShouldExcludeArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.shouldExcludeArchived, value)) {
            return this;
        }
        return new GroupsListParams(value, this.shouldExcludeMembers);
    }

    public final GroupsListParams withShouldExcludeMembers(boolean value) {
        if (this.shouldExcludeMembers == value) {
            return this;
        }
        return new GroupsListParams(this.shouldExcludeArchived, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupsListParams && this.equalTo(0, (GroupsListParams)another);
    }

    private boolean equalTo(int synthetic, GroupsListParams another) {
        return Objects.equals(this.shouldExcludeArchived, another.shouldExcludeArchived) && this.shouldExcludeMembers == another.shouldExcludeMembers;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.shouldExcludeArchived);
        h += (h << 5) + Boolean.hashCode(this.shouldExcludeMembers);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GroupsListParams{");
        if (this.shouldExcludeArchived != null) {
            builder.append("shouldExcludeArchived=").append(this.shouldExcludeArchived);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("shouldExcludeMembers=").append(this.shouldExcludeMembers);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static GroupsListParams fromJson(Json json) {
        Builder builder = GroupsListParams.builder();
        if (json.shouldExcludeArchived != null) {
            builder.setShouldExcludeArchived(json.shouldExcludeArchived);
        }
        if (json.shouldExcludeMembersIsSet) {
            builder.setShouldExcludeMembers(json.shouldExcludeMembers);
        }
        return builder.build();
    }

    public static GroupsListParams copyOf(GroupsListParamsIF instance) {
        if (instance instanceof GroupsListParams) {
            return (GroupsListParams)instance;
        }
        return GroupsListParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GroupsListParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SHOULD_EXCLUDE_MEMBERS = 1L;
        private long optBits;
        @Nullable
        private Boolean shouldExcludeArchived;
        private boolean shouldExcludeMembers;

        private Builder() {
        }

        public final Builder from(BaseChannelsFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(GroupsListParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<Boolean> shouldExcludeArchivedOptional;
            BaseChannelsFilter instance;
            long bits = 0L;
            if (object instanceof BaseChannelsFilter) {
                instance = (BaseChannelsFilter)object;
                if ((bits & 1L) == 0L) {
                    shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
                    if (shouldExcludeArchivedOptional.isPresent()) {
                        this.setShouldExcludeArchived(shouldExcludeArchivedOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setShouldExcludeMembers(instance.shouldExcludeMembers());
                    bits |= 2L;
                }
            }
            if (object instanceof GroupsListParamsIF) {
                instance = (GroupsListParamsIF)object;
                if ((bits & 1L) == 0L) {
                    shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
                    if (shouldExcludeArchivedOptional.isPresent()) {
                        this.setShouldExcludeArchived(shouldExcludeArchivedOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setShouldExcludeMembers(instance.shouldExcludeMembers());
                    bits |= 2L;
                }
            }
        }

        public final Builder setShouldExcludeArchived(@Nullable Boolean shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
            return this;
        }

        public final Builder setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived.orElse(null);
            return this;
        }

        public final Builder setShouldExcludeMembers(boolean shouldExcludeMembers) {
            this.shouldExcludeMembers = shouldExcludeMembers;
            this.optBits |= 1L;
            return this;
        }

        public GroupsListParams build() {
            return new GroupsListParams(this);
        }

        private boolean shouldExcludeMembersIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GroupsListParamsIF", generator="Immutables")
    static final class Json
    implements GroupsListParamsIF {
        @Nullable
        Optional<Boolean> shouldExcludeArchived = Optional.empty();
        boolean shouldExcludeMembers;
        boolean shouldExcludeMembersIsSet;

        Json() {
        }

        @JsonProperty(value="exclude_archived")
        public void setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
        }

        @JsonProperty(value="exclude_members")
        public void setShouldExcludeMembers(boolean shouldExcludeMembers) {
            this.shouldExcludeMembers = shouldExcludeMembers;
            this.shouldExcludeMembersIsSet = true;
        }

        @Override
        public Optional<Boolean> shouldExcludeArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldExcludeMembers() {
            throw new UnsupportedOperationException();
        }
    }
}

