/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.files;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.files.SlackFileType;
import java.io.File;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@Value.Immutable
@HubSpotStyle
public interface FilesUploadParamsIF {
    public List<String> getChannels();

    public Optional<String> getContent();

    public Optional<File> getFile();

    public Optional<String> getFilename();

    public Optional<SlackFileType> getFiletype();

    public Optional<String> getInitialComment();

    public Optional<String> getThreadTs();

    public Optional<String> getTitle();

    @JsonIgnore
    @Value.Check
    default public void hasContent() {
        if (!this.getContent().isPresent() && !this.getFile().isPresent()) {
            throw new IllegalStateException("Must provide either content or raw file");
        }
    }
}

