/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.conversations.BaseConversationsFilter;
import com.hubspot.slack.client.methods.params.conversations.ConversationsFilterIF;
import com.hubspot.slack.client.models.conversations.ConversationType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConversationsFilterIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConversationsFilter
implements ConversationsFilterIF {
    @Nullable
    private final Boolean shouldExcludeArchived;
    private final transient String types;
    private final Set<ConversationType> conversationTypes;

    private ConversationsFilter(@Nullable Boolean shouldExcludeArchived, Set<ConversationType> conversationTypes) {
        this.shouldExcludeArchived = shouldExcludeArchived;
        this.conversationTypes = conversationTypes;
        this.types = Objects.requireNonNull(ConversationsFilterIF.super.getTypes(), "types");
    }

    @Override
    @JsonProperty(value="exclude_archived")
    public Optional<Boolean> shouldExcludeArchived() {
        return Optional.ofNullable(this.shouldExcludeArchived);
    }

    @Override
    @JsonProperty
    public String getTypes() {
        return this.types;
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Set<ConversationType> getConversationTypes() {
        return this.conversationTypes;
    }

    public final ConversationsFilter withShouldExcludeArchived(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.shouldExcludeArchived, newValue)) {
            return this;
        }
        return new ConversationsFilter(newValue, this.conversationTypes);
    }

    public final ConversationsFilter withShouldExcludeArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.shouldExcludeArchived, value)) {
            return this;
        }
        return new ConversationsFilter(value, this.conversationTypes);
    }

    public final ConversationsFilter withConversationTypes(ConversationType ... elements) {
        Set<ConversationType> newValue = ConversationsFilter.createUnmodifiableEnumSet(Arrays.asList(elements));
        return new ConversationsFilter(this.shouldExcludeArchived, newValue);
    }

    public final ConversationsFilter withConversationTypes(Iterable<ConversationType> elements) {
        if (this.conversationTypes == elements) {
            return this;
        }
        Set<ConversationType> newValue = ConversationsFilter.createUnmodifiableEnumSet(elements);
        return new ConversationsFilter(this.shouldExcludeArchived, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsFilter && this.equalTo(0, (ConversationsFilter)another);
    }

    private boolean equalTo(int synthetic, ConversationsFilter another) {
        return Objects.equals(this.shouldExcludeArchived, another.shouldExcludeArchived) && this.types.equals(another.types) && this.conversationTypes.equals(another.conversationTypes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.shouldExcludeArchived);
        h += (h << 5) + this.types.hashCode();
        h += (h << 5) + this.conversationTypes.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsFilter{");
        if (this.shouldExcludeArchived != null) {
            builder.append("shouldExcludeArchived=").append(this.shouldExcludeArchived);
        }
        if (builder.length() > 20) {
            builder.append(", ");
        }
        builder.append("types=").append(this.types);
        builder.append(", ");
        builder.append("conversationTypes=").append(this.conversationTypes);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConversationsFilter fromJson(Json json) {
        Builder builder = ConversationsFilter.builder();
        if (json.shouldExcludeArchived != null) {
            builder.setShouldExcludeArchived(json.shouldExcludeArchived);
        }
        if (json.conversationTypes != null) {
            builder.addAllConversationTypes(json.conversationTypes);
        }
        return builder.build();
    }

    public static ConversationsFilter copyOf(ConversationsFilterIF instance) {
        if (instance instanceof ConversationsFilter) {
            return (ConversationsFilter)instance;
        }
        return ConversationsFilter.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T extends Enum<T>> Set<T> createUnmodifiableEnumSet(Iterable<T> iterable) {
        if (iterable instanceof EnumSet) {
            return Collections.unmodifiableSet(EnumSet.copyOf((EnumSet)iterable));
        }
        List<T> list = ConversationsFilter.createSafeList(iterable, true, false);
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton((Enum)list.get(0));
            }
        }
        return Collections.unmodifiableSet(EnumSet.copyOf(list));
    }

    @Generated(from="ConversationsFilterIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private Boolean shouldExcludeArchived;
        private EnumSet<ConversationType> conversationTypes = EnumSet.noneOf(ConversationType.class);

        private Builder() {
        }

        public final Builder from(BaseConversationsFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ConversationsFilterIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<Boolean> shouldExcludeArchivedOptional;
            BaseConversationsFilter instance;
            long bits = 0L;
            if (object instanceof BaseConversationsFilter) {
                instance = (BaseConversationsFilter)object;
                if ((bits & 1L) == 0L) {
                    shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
                    if (shouldExcludeArchivedOptional.isPresent()) {
                        this.setShouldExcludeArchived(shouldExcludeArchivedOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllConversationTypes(instance.getConversationTypes());
                    bits |= 2L;
                }
            }
            if (object instanceof ConversationsFilterIF) {
                instance = (ConversationsFilterIF)object;
                if ((bits & 1L) == 0L) {
                    shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
                    if (shouldExcludeArchivedOptional.isPresent()) {
                        this.setShouldExcludeArchived(shouldExcludeArchivedOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllConversationTypes(instance.getConversationTypes());
                    bits |= 2L;
                }
            }
        }

        public final Builder setShouldExcludeArchived(@Nullable Boolean shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
            return this;
        }

        public final Builder setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived.orElse(null);
            return this;
        }

        public final Builder addConversationTypes(ConversationType element) {
            this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
            return this;
        }

        public final Builder addConversationTypes(ConversationType ... elements) {
            for (ConversationType element : elements) {
                this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
            }
            return this;
        }

        public final Builder setConversationTypes(Iterable<ConversationType> elements) {
            this.conversationTypes.clear();
            return this.addAllConversationTypes(elements);
        }

        public final Builder addAllConversationTypes(Iterable<ConversationType> elements) {
            for (ConversationType element : elements) {
                this.conversationTypes.add(Objects.requireNonNull(element, "conversationTypes element"));
            }
            return this;
        }

        public ConversationsFilter build() {
            return new ConversationsFilter(this.shouldExcludeArchived, ConversationsFilter.createUnmodifiableEnumSet(this.conversationTypes));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConversationsFilterIF", generator="Immutables")
    static final class Json
    implements ConversationsFilterIF {
        @Nullable
        Optional<Boolean> shouldExcludeArchived = Optional.empty();
        @Nullable
        Set<ConversationType> conversationTypes = Collections.emptySet();

        Json() {
        }

        @JsonProperty(value="exclude_archived")
        public void setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
        }

        @JsonProperty
        @JsonIgnore
        public void setConversationTypes(Set<ConversationType> conversationTypes) {
            this.conversationTypes = conversationTypes;
        }

        @Override
        public Optional<Boolean> shouldExcludeArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getTypes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<ConversationType> getConversationTypes() {
            throw new UnsupportedOperationException();
        }
    }
}

