/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.ConversationMemberParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConversationMemberParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConversationMemberParams
implements ConversationMemberParamsIF {
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer limit;
    private final String channelId;

    private ConversationMemberParams(@Nullable String cursor, @Nullable Integer limit, String channelId) {
        this.cursor = cursor;
        this.limit = limit;
        this.channelId = channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getCursor() {
        return Optional.ofNullable(this.cursor);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    public final ConversationMemberParams withCursor(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.cursor, newValue)) {
            return this;
        }
        return new ConversationMemberParams(newValue, this.limit, this.channelId);
    }

    public final ConversationMemberParams withCursor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.cursor, value)) {
            return this;
        }
        return new ConversationMemberParams(value, this.limit, this.channelId);
    }

    public final ConversationMemberParams withLimit(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ConversationMemberParams(this.cursor, newValue, this.channelId);
    }

    public final ConversationMemberParams withLimit(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ConversationMemberParams(this.cursor, value, this.channelId);
    }

    public final ConversationMemberParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ConversationMemberParams(this.cursor, this.limit, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationMemberParams && this.equalTo(0, (ConversationMemberParams)another);
    }

    private boolean equalTo(int synthetic, ConversationMemberParams another) {
        return Objects.equals(this.cursor, another.cursor) && Objects.equals(this.limit, another.limit) && this.channelId.equals(another.channelId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.cursor);
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + this.channelId.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationMemberParams{");
        if (this.cursor != null) {
            builder.append("cursor=").append(this.cursor);
        }
        if (this.limit != null) {
            if (builder.length() > 25) {
                builder.append(", ");
            }
            builder.append("limit=").append(this.limit);
        }
        if (builder.length() > 25) {
            builder.append(", ");
        }
        builder.append("channelId=").append(this.channelId);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConversationMemberParams fromJson(Json json) {
        Builder builder = ConversationMemberParams.builder();
        if (json.cursor != null) {
            builder.setCursor(json.cursor);
        }
        if (json.limit != null) {
            builder.setLimit(json.limit);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        return builder.build();
    }

    public static ConversationMemberParams copyOf(ConversationMemberParamsIF instance) {
        if (instance instanceof ConversationMemberParams) {
            return (ConversationMemberParams)instance;
        }
        return ConversationMemberParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConversationMemberParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String cursor;
        @Nullable
        private Integer limit;
        @Nullable
        private String channelId;

        private Builder() {
        }

        public final Builder from(ConversationMemberParamsIF instance) {
            Optional<Integer> limitOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> cursorOptional = instance.getCursor();
            if (cursorOptional.isPresent()) {
                this.setCursor(cursorOptional);
            }
            if ((limitOptional = instance.getLimit()).isPresent()) {
                this.setLimit(limitOptional);
            }
            this.setChannelId(instance.getChannelId());
            return this;
        }

        public final Builder setCursor(@Nullable String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final Builder setCursor(Optional<String> cursor) {
            this.cursor = cursor.orElse(null);
            return this;
        }

        public final Builder setLimit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Builder setLimit(Optional<Integer> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ConversationMemberParams build() {
            this.checkRequiredAttributes();
            return new ConversationMemberParams(this.cursor, this.limit, this.channelId);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ConversationMemberParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConversationMemberParamsIF", generator="Immutables")
    static final class Json
    implements ConversationMemberParamsIF {
        @Nullable
        Optional<String> cursor = Optional.empty();
        @Nullable
        Optional<Integer> limit = Optional.empty();
        @Nullable
        String channelId;

        Json() {
        }

        @JsonProperty
        public void setCursor(Optional<String> cursor) {
            this.cursor = cursor;
        }

        @JsonProperty
        public void setLimit(Optional<Integer> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @Override
        public Optional<String> getCursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getLimit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }
    }
}

