/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.conversations.ConversationInviteSharedParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConversationInviteSharedParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConversationInviteSharedParams
implements ConversationInviteSharedParamsIF {
    private final String channelId;
    private final List<String> emails;
    private final List<String> userIds;

    private ConversationInviteSharedParams(String channelId, List<String> emails, List<String> userIds) {
        this.channelId = channelId;
        this.emails = emails;
        this.userIds = userIds;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public List<String> getEmails() {
        return this.emails;
    }

    @Override
    @JsonProperty
    public List<String> getUserIds() {
        return this.userIds;
    }

    public final ConversationInviteSharedParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ConversationInviteSharedParams(newValue, this.emails, this.userIds);
    }

    public final ConversationInviteSharedParams withEmails(String ... elements) {
        List<String> newValue = ConversationInviteSharedParams.createUnmodifiableList(false, ConversationInviteSharedParams.createSafeList(Arrays.asList(elements), true, false));
        return new ConversationInviteSharedParams(this.channelId, newValue, this.userIds);
    }

    public final ConversationInviteSharedParams withEmails(Iterable<String> elements) {
        if (this.emails == elements) {
            return this;
        }
        List<String> newValue = ConversationInviteSharedParams.createUnmodifiableList(false, ConversationInviteSharedParams.createSafeList(elements, true, false));
        return new ConversationInviteSharedParams(this.channelId, newValue, this.userIds);
    }

    public final ConversationInviteSharedParams withUserIds(String ... elements) {
        List<String> newValue = ConversationInviteSharedParams.createUnmodifiableList(false, ConversationInviteSharedParams.createSafeList(Arrays.asList(elements), true, false));
        return new ConversationInviteSharedParams(this.channelId, this.emails, newValue);
    }

    public final ConversationInviteSharedParams withUserIds(Iterable<String> elements) {
        if (this.userIds == elements) {
            return this;
        }
        List<String> newValue = ConversationInviteSharedParams.createUnmodifiableList(false, ConversationInviteSharedParams.createSafeList(elements, true, false));
        return new ConversationInviteSharedParams(this.channelId, this.emails, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationInviteSharedParams && this.equalTo(0, (ConversationInviteSharedParams)another);
    }

    private boolean equalTo(int synthetic, ConversationInviteSharedParams another) {
        return this.channelId.equals(another.channelId) && this.emails.equals(another.emails) && this.userIds.equals(another.userIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.emails.hashCode();
        h += (h << 5) + this.userIds.hashCode();
        return h;
    }

    public String toString() {
        return "ConversationInviteSharedParams{channelId=" + this.channelId + ", emails=" + this.emails + ", userIds=" + this.userIds + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConversationInviteSharedParams fromJson(Json json) {
        Builder builder = ConversationInviteSharedParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.emails != null) {
            builder.addAllEmails(json.emails);
        }
        if (json.userIds != null) {
            builder.addAllUserIds(json.userIds);
        }
        return builder.build();
    }

    public static ConversationInviteSharedParams copyOf(ConversationInviteSharedParamsIF instance) {
        if (instance instanceof ConversationInviteSharedParams) {
            return (ConversationInviteSharedParams)instance;
        }
        return ConversationInviteSharedParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ConversationInviteSharedParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String channelId;
        private List<String> emails = new ArrayList<String>();
        private List<String> userIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(ConversationInviteSharedParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof ConversationInviteSharedParamsIF) {
                instance = (ConversationInviteSharedParamsIF)object;
                this.addAllEmails(instance.getEmails());
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
                this.addAllUserIds(instance.getUserIds());
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addEmails(String element) {
            this.emails.add(Objects.requireNonNull(element, "emails element"));
            return this;
        }

        public final Builder addEmails(String ... elements) {
            for (String element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        public final Builder setEmails(Iterable<String> elements) {
            this.emails.clear();
            return this.addAllEmails(elements);
        }

        public final Builder addAllEmails(Iterable<String> elements) {
            for (String element : elements) {
                this.emails.add(Objects.requireNonNull(element, "emails element"));
            }
            return this;
        }

        public final Builder addUserIds(String element) {
            this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            return this;
        }

        public final Builder addUserIds(String ... elements) {
            for (String element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public final Builder setUserIds(Iterable<String> elements) {
            this.userIds.clear();
            return this.addAllUserIds(elements);
        }

        public final Builder addAllUserIds(Iterable<String> elements) {
            for (String element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public ConversationInviteSharedParams build() {
            this.checkRequiredAttributes();
            return new ConversationInviteSharedParams(this.channelId, ConversationInviteSharedParams.createUnmodifiableList(true, this.emails), ConversationInviteSharedParams.createUnmodifiableList(true, this.userIds));
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ConversationInviteSharedParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConversationInviteSharedParamsIF", generator="Immutables")
    static final class Json
    implements ConversationInviteSharedParamsIF {
        @Nullable
        String channelId;
        @Nullable
        List<String> emails = Collections.emptyList();
        @Nullable
        List<String> userIds = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setEmails(List<String> emails) {
            this.emails = emails;
        }

        @JsonProperty
        public void setUserIds(List<String> userIds) {
            this.userIds = userIds;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getEmails() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getUserIds() {
            throw new UnsupportedOperationException();
        }
    }
}

